/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.app.ReplaceMapProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplaceMap<K, V>
extends HashMap<K, V> {
    private static final Logger logger = LogManager.getLogger(ReplaceMap.class);
    private ArrayList<ReplaceMapProxy<K, V>> proxylist = new ArrayList();

    public ReplaceMap() {
    }

    public ReplaceMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ReplaceMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ReplaceMap(Map<? extends K, ? extends V> m) {
        super(m);
        if (m instanceof ReplaceMap) {
            this.proxylist.addAll(((ReplaceMap)m).proxylist);
        }
    }

    @Override
    public boolean containsKey(Object s) {
        if (super.containsKey(s)) {
            return true;
        }
        for (ReplaceMapProxy<K, V> proxy : this.proxylist) {
            if (!proxy.containsKey(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object s) {
        logger.debug(s);
        if (super.containsKey(s)) {
            logger.debug("return super.containsKey, s=" + s + " ,super.s=" + super.get(s));
            return super.get(s);
        }
        for (ReplaceMapProxy<K, V> proxy : this.proxylist) {
            V value = proxy.get(s);
            if (value == null) continue;
            logger.debug("return proxy value, s=" + s + " value=" + value);
            return value;
        }
        logger.debug("return null, " + s);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        super.putAll(t);
        if (t instanceof ReplaceMap) {
            this.proxylist.addAll(((ReplaceMap)t).proxylist);
        }
    }

    public void addReplaceMapProxy(ReplaceMapProxy<K, V> proxy) {
        this.proxylist.add(proxy);
    }
}

