/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.IMailProcessor;
import jp.jasminesoft.jfc.app.MailMessageManager;
import jp.jasminesoft.jfc.core.util.IOUtils;
import jp.jasminesoft.jfc.dao.SendMailScroller;
import jp.jasminesoft.jfc.dao.Updator;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SendMailProcessor<E extends ContainerBase<E>, PK extends Serializable, D>
implements IMailProcessor {
    private static final Logger logger = LogManager.getLogger(SendMailProcessor.class);
    @Autowired
    @Qualifier(value="MailMessageManager")
    protected MailMessageManager mailMessageManager;
    protected JFCEntityService<E, PK> entityService;
    protected SendMailScroller<E, PK, D> scroller;
    protected List<String> errorMessages = new ArrayList<String>();

    @Override
    public int process(ActionParameter p) {
        if (this.mailMessageManager.getMailmessage(this.getMid(), p) == null) {
            logger.warn("mail id '" + this.getMid() + "' is not found. skip the sendmail process.");
            return 0;
        }
        this.entityService.scroll(this.scroller);
        this.postProcess(p);
        return this.scroller.successCounter().getValue();
    }

    protected void postProcess(ActionParameter p) {
        if (this.isSkipPostProcess()) {
            return;
        }
        String errorHeader = JFCUtils.getRValue("__jfc_template.selectionmodel.id", p.locale);
        for (Serializable primaryKey : this.scroller.successEntityIds()) {
            try {
                this.entityService.update(primaryKey, new Updator<E>(){

                    @Override
                    public void execute(E entity) {
                        SendMailProcessor.this.success(entity);
                    }
                });
            }
            catch (Exception e) {
                this.errorMessages.add(errorHeader + " : " + primaryKey + ", " + e.getMessage());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e, (Throwable)e);
            }
        }
        for (Serializable primaryKey : this.scroller.errorEntityIds()) {
            try {
                this.entityService.update(primaryKey, new Updator<E>(){

                    @Override
                    public void execute(E entity) {
                        SendMailProcessor.this.fail(entity);
                    }
                });
            }
            catch (Exception e) {
                this.errorMessages.add(errorHeader + " : " + primaryKey + ", " + e.getMessage());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    public boolean isSkipPostProcess() {
        return true;
    }

    protected void success(E entity) {
    }

    protected void fail(E entity) {
    }

    public void setMid(String mid) {
        this.scroller.setMid(mid);
    }

    public String getMid() {
        return this.scroller.getMid();
    }

    public JFCEntityService<E, ?> getEntityService() {
        return this.entityService;
    }

    public void setEntityService(JFCEntityService<E, PK> entityService) {
        this.entityService = entityService;
    }

    public SendMailScroller<E, PK, D> getScroller() {
        return this.scroller;
    }

    public void setScroller(SendMailScroller<E, PK, D> scroller) {
        this.scroller = scroller;
    }

    @Override
    public String getErrorMessage(ActionParameter p) {
        if (this.errorMessages.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(JFCUtils.getRValue("__jfc_common.job.log", new Object[]{this.scroller.successCounter().getValue()}, p.locale));
        sb.append(IOUtils.LINE_SEPARATOR_WINDOWS);
        sb.append("---");
        sb.append(IOUtils.LINE_SEPARATOR_WINDOWS);
        for (String message : this.errorMessages) {
            sb.append(message);
            sb.append(IOUtils.LINE_SEPARATOR_WINDOWS);
        }
        sb.append("---");
        return sb.toString();
    }
}

