/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.core.support.spring.security.DefaultLogonAuthenticationFilter;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class DefaultLogonAuthenticationConfigure<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<DefaultLogonAuthenticationConfigure<B>, B> {
    private DefaultLogonAuthenticationFilter authFilter;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;
    private AuthenticationSuccessHandler successHandler;
    private AuthenticationFailureHandler failureHandler;
    private String internetUserName;
    private String internetUserPassword;
    private RequestMatcher requestMatcher;

    public void configure(B http) throws Exception {
        RememberMeServices rememberMeServices;
        if (this.authFilter == null) {
            this.authFilter = new DefaultLogonAuthenticationFilter(this.internetUserName, this.internetUserPassword);
        }
        this.authFilter.setRequiresAuthenticationRequestMatcher(this.requestMatcher);
        this.authFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        if (this.successHandler != null) {
            this.authFilter.setAuthenticationSuccessHandler(this.successHandler);
        } else {
            this.authFilter.setAuthenticationSuccessHandler((request, response, authentication) -> {});
        }
        this.authFilter.setAuthenticationFailureHandler(this.failureHandler);
        if (this.authenticationDetailsSource != null) {
            this.authFilter.setAuthenticationDetailsSource(this.authenticationDetailsSource);
        }
        if ((rememberMeServices = (RememberMeServices)http.getSharedObject(RememberMeServices.class)) != null) {
            this.authFilter.setRememberMeServices(rememberMeServices);
        }
        DefaultLogonAuthenticationFilter filter = (DefaultLogonAuthenticationFilter)((Object)this.postProcess((Object)this.authFilter));
        http.addFilterAfter((Filter)filter, UsernamePasswordAuthenticationFilter.class);
    }

    public final DefaultLogonAuthenticationConfigure<B> successHandler(AuthenticationSuccessHandler handler) {
        this.successHandler = handler;
        return this;
    }

    public final DefaultLogonAuthenticationConfigure<B> failureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.failureHandler = authenticationFailureHandler;
        return this;
    }

    public void setAuthenticationFilter(DefaultLogonAuthenticationFilter filter) {
        this.authFilter = filter;
    }

    protected final DefaultLogonAuthenticationFilter getAuthenticationFilter() {
        return this.authFilter;
    }

    public DefaultLogonAuthenticationConfigure<B> internetUserName(String name) {
        this.internetUserName = name;
        return this;
    }

    public String getInternetUserName() {
        return this.internetUserName;
    }

    public DefaultLogonAuthenticationConfigure<B> internetUserPassword(String password) {
        this.internetUserPassword = password;
        return this;
    }

    public String getInternetUserPassword() {
        return this.internetUserPassword;
    }

    public RequestMatcher getRequiresAuthenticationRequestMatcher() {
        return this.requestMatcher;
    }

    public DefaultLogonAuthenticationConfigure<B> requiresAuthenticationRequestMatcher(RequestMatcher authenticationRequestMatcher) {
        this.requestMatcher = authenticationRequestMatcher;
        return this;
    }
}

