/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import jp.jasminesoft.jfc.JFCUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wagby.filestore.s3")
public class FilestoreS3Properties {
    private static final Logger logger = LogManager.getLogger(FilestoreS3Properties.class);
    private String bucket;
    private String folder;
    private String s3basedir = JFCUtils.getUploadDir().toString();
    private Scheduler scheduler = new Scheduler();
    private KeySettingImpl defaultKeySetting = new KeySettingImpl();
    private KeySettingImpl[] keySettings = new KeySettingImpl[]{new KeySettingImpl(172800000L, "^jfcjob/.*$")};

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getS3basedir() {
        return this.s3basedir;
    }

    public void setS3basedir(String s3basedir) {
        this.s3basedir = s3basedir;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public KeySettingImpl getDefaultKeySetting() {
        return this.defaultKeySetting;
    }

    public void setDefaultKeySetting(KeySettingImpl defaultKeySetting) {
        this.defaultKeySetting = defaultKeySetting;
    }

    public long getUploadfileinterval() {
        return this.defaultKeySetting.uploadfileinterval;
    }

    public void setUploadfileinterval(long uploadfileinterval) {
        this.defaultKeySetting.uploadfileinterval = uploadfileinterval;
    }

    public boolean isOverwrite() {
        return this.defaultKeySetting.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.defaultKeySetting.overwrite = overwrite;
    }

    public boolean isDeletefileforexistsobject() {
        return this.defaultKeySetting.deletefileforexistsobject;
    }

    public void setDeletefileforexistsobject(boolean deletefileforexistsobject) {
        this.defaultKeySetting.deletefileforexistsobject = deletefileforexistsobject;
    }

    public KeySettingImpl[] getKeySettings() {
        return this.keySettings;
    }

    public void setKeySettings(KeySettingImpl[] keySettings) {
        this.keySettings = keySettings;
    }

    @PostConstruct
    public void postConstruct() {
        logger.info("postConstruct keySettings.length=" + this.keySettings.length);
        for (KeySettingImpl setting : this.keySettings) {
            logger.info("postConstruct keySettings=" + setting);
            String patstr = setting.getPattern();
            if (patstr == null) continue;
            try {
                Pattern pat = Pattern.compile(patstr);
                setting.setPattern2(pat);
            }
            catch (PatternSyntaxException e) {
                logger.warn("wagby.filestore.s3.key-settings[?].pattern is illegal pattern syntax. pattern:" + patstr, (Throwable)e);
            }
        }
    }

    public static class KeySettingImpl {
        private long uploadfileinterval = 300000L;
        private boolean overwrite = true;
        private boolean deletefileforexistsobject = true;
        private String pattern;
        private Pattern pattern2;

        KeySettingImpl() {
        }

        KeySettingImpl(long uploadfileinterval, String pattern) {
            this.uploadfileinterval = uploadfileinterval;
            this.pattern = pattern;
        }

        public String toString() {
            return "uploadfileinterval=" + this.uploadfileinterval + ",overwrite=" + this.overwrite + ",deletefileforexistsobject=" + this.deletefileforexistsobject + ",pattern=" + this.pattern;
        }

        public long getUploadfileinterval() {
            return this.uploadfileinterval;
        }

        public void setUploadfileinterval(long uploadfileinterval) {
            this.uploadfileinterval = uploadfileinterval;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public boolean isDeletefileforexistsobject() {
            return this.deletefileforexistsobject;
        }

        public void setDeletefileforexistsobject(boolean deletefileforexistsobject) {
            this.deletefileforexistsobject = deletefileforexistsobject;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Pattern getPattern2() {
            return this.pattern2;
        }

        public void setPattern2(Pattern pattern2) {
            this.pattern2 = pattern2;
        }
    }

    public static class Scheduler {
        private String cron;
        private String minute = "0/5";

        public String getCron() {
            return this.cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public String getMinute() {
            return this.minute;
        }

        public void setMinute(String minute) {
            this.minute = minute;
        }
    }
}

