/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import javax.servlet.Filter;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionAuthenticationSuccessHandler;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionAutoLogonFilter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class MultipleSessionAutoLogonConfigure<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<MultipleSessionAutoLogonConfigure<B>, B> {
    private MultipleSessionAutoLogonFilter authFilter;
    private RequestMatcher requestMatcher;
    private AuthenticationSuccessHandler successHandler;
    private AuthenticationFailureHandler failureHandler;

    public void configure(B http) throws Exception {
        if (this.authFilter == null) {
            this.authFilter = new MultipleSessionAutoLogonFilter();
        }
        this.authFilter.setRequiresAuthenticationRequestMatcher(this.requestMatcher);
        this.authFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        if (this.successHandler != null) {
            this.authFilter.setAuthenticationSuccessHandler(this.successHandler);
        } else {
            this.authFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new MultipleSessionAuthenticationSuccessHandler("/dummy"));
        }
        this.authFilter.setAuthenticationFailureHandler(this.failureHandler);
        SessionAuthenticationStrategy sessionAuthenticationStrategy = (SessionAuthenticationStrategy)http.getSharedObject(SessionAuthenticationStrategy.class);
        if (sessionAuthenticationStrategy != null) {
            this.authFilter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        }
        MultipleSessionAutoLogonFilter filter = (MultipleSessionAutoLogonFilter)((Object)this.postProcess((Object)this.authFilter));
        http.addFilterBefore((Filter)filter, UsernamePasswordAuthenticationFilter.class);
    }

    public final MultipleSessionAutoLogonConfigure<B> successHandler(AuthenticationSuccessHandler handler) {
        this.successHandler = handler;
        return this;
    }

    public final MultipleSessionAutoLogonConfigure<B> failureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.failureHandler = authenticationFailureHandler;
        return this;
    }

    public RequestMatcher getRequiresAuthenticationRequestMatcher() {
        return this.requestMatcher;
    }

    public MultipleSessionAutoLogonConfigure<B> requiresAuthenticationRequestMatcher(RequestMatcher authenticationRequestMatcher) {
        this.requestMatcher = authenticationRequestMatcher;
        return this;
    }
}

