/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.Enumeration;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MyHttpSessionListener
implements InitializingBean,
HttpSessionListener {
    private static final Logger logger = LogManager.getLogger(MyHttpSessionListener.class);
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    LogonStatusManager lsman;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void afterPropertiesSet() {
        logger.debug("afterPropertiesSet");
        this.servletContext.addListener((EventListener)((Object)this));
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (logger.isDebugEnabled()) {
            logger.debug("session created. id=" + se.getSession().getId());
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        this.sessionDestroyed(session);
    }

    public void sessionDestroyed(HttpSession session) {
        String sessionid = session.getId();
        if (logger.isDebugEnabled()) {
            logger.debug("session destroyed. id=" + sessionid);
            Enumeration enu = session.getAttributeNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                logger.debug("session destroyed. key=" + key);
            }
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, "sessionDestroyed");
        User suser = JFCUtils.getUserInSession(session, this.appctx);
        if (suser != null) {
            suser.valueUnbound(event);
        } else {
            logger.debug("session destroyed. user object nothing. id=" + sessionid);
        }
    }
}

