/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.core.support.spring.security.RequestRemoteUserAuthenticationFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;

public class PreAuthenticationConfigurer
extends AbstractHttpConfigurer<PreAuthenticationConfigurer, HttpSecurity> {
    @Autowired
    protected SecurityProperties securityProperties;
    private PreAuthenticatedAuthenticationProvider authenticationProvider;
    private AbstractPreAuthenticatedProcessingFilter preAuthenticationFilter;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;

    public PreAuthenticationConfigurer authenticationProvider(PreAuthenticatedAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
        return this;
    }

    public PreAuthenticationConfigurer preAuthenticationFilter(AbstractPreAuthenticatedProcessingFilter preAuthenticationFilter) {
        this.preAuthenticationFilter = preAuthenticationFilter;
        return this;
    }

    public PreAuthenticationConfigurer authenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
        return this;
    }

    public void init(HttpSecurity http) throws Exception {
        System.out.println("AbstractHttpConfigurer#init(HttpSecurity http)");
        if (this.authenticationProvider == null) {
            this.authenticationProvider = new PreAuthenticatedAuthenticationProvider();
            this.authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new PreAuthenticatedGrantedAuthoritiesUserDetailsService());
        }
        if (this.preAuthenticationFilter == null) {
            this.preAuthenticationFilter = new RequestRemoteUserAuthenticationFilter();
        }
        if (this.authenticationDetailsSource == null) {
            this.authenticationDetailsSource = request -> new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        }
        this.preAuthenticationFilter.setAuthenticationDetailsSource(this.authenticationDetailsSource);
        this.authenticationProvider = (PreAuthenticatedAuthenticationProvider)this.postProcess(this.authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    public void configure(HttpSecurity http) throws Exception {
        this.preAuthenticationFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        this.preAuthenticationFilter = (AbstractPreAuthenticatedProcessingFilter)this.postProcess(this.preAuthenticationFilter);
        http.addFilterBefore((Filter)this.preAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
    }
}

