/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.core.support.spring.boot.JFCErrorAttribues;
import jp.jasminesoft.jfc.core.support.spring.security.JFCLegacyPasswordEncoder;
import jp.jasminesoft.jfc.core.support.spring.security.LogonFailureEventListener;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionAuthenticationFailureHandler;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionAuthenticationSuccessHandler;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionLoginUrlAuthenticationEntryPoint;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionLogoutSuccessHandler;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
public class SecurityBeanConfiguration {
    @Autowired
    protected SecurityProperties securityProperties;
    private static final List<String> ALLOWED_METHODS = Arrays.asList("GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE");
    private static final List<String> ALLOWED_HEADERS = Arrays.asList("Content-Type", "X-Requested-With", "accept", "Origin", "X-Wagby-Authorization", "X-Wagby-RESTAPIVersion", "Access-Control-Request-Method", "Access-Control-Request-Headers");
    private static final List<String> EXPOSE_HEADERS = Arrays.asList("Access-Control-Allow-Origin", "Access-Control-Allow-Credentials", "X-Total-Count");

    @Bean
    public DataSource dataSource() {
        JndiDataSourceLookup lookup = new JndiDataSourceLookup();
        return lookup.getDataSource("jdbc/jfc");
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationSuccessHandler.class})
    protected AuthenticationSuccessHandler authenticationSuccessHandler() {
        return new MultipleSessionAuthenticationSuccessHandler(this.securityProperties.getLogonSuccessUrl(), this.securityProperties.isAlwaysUseDefaultTargetUrl());
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationFailureHandler.class})
    protected AuthenticationFailureHandler authenticationFailureHandler() {
        return new MultipleSessionAuthenticationFailureHandler(this.securityProperties.getLogonPage() + "?error");
    }

    @Bean
    @ConditionalOnMissingBean(value={LoginUrlAuthenticationEntryPoint.class})
    protected LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new MultipleSessionLoginUrlAuthenticationEntryPoint(this.securityProperties.getLogonPage());
    }

    @Bean
    @ConditionalOnMissingBean(value={LogoutSuccessHandler.class})
    protected LogoutSuccessHandler logoutSuccessHandler() {
        String logoutSuccessUrl = this.securityProperties.getLogonPage() + "?logout";
        if (this.securityProperties.isRequestRemoteUser()) {
            logoutSuccessUrl = this.securityProperties.getRemoteUserLogoffSuccessUrl();
        }
        return new MultipleSessionLogoutSuccessHandler(logoutSuccessUrl);
    }

    @Bean
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        if (this.securityProperties.getBcrypt().getStrength() != null) {
            return new BCryptPasswordEncoder(this.securityProperties.getBcrypt().getStrength().intValue());
        }
        return this.jfcLegacyPasswordEncoder();
    }

    @Bean
    public PasswordEncoder jfcLegacyPasswordEncoder() {
        return new JFCLegacyPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class})
    public DefaultErrorAttributes errorAttributes() {
        return new JFCErrorAttribues();
    }

    @Bean
    public ApplicationListener<AuthenticationFailureBadCredentialsEvent> logonFailureEventListener() {
        return new LogonFailureEventListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={CorsConfigurationSource.class})
    public CorsConfigurationSource corsConfigurationSource() {
        if (CollectionUtils.isEmpty(this.securityProperties.getCorsAllowedOrigins())) {
            return null;
        }
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(this.securityProperties.getCorsAllowedOrigins());
        List<String> allowMethods = ALLOWED_METHODS;
        if (CollectionUtils.isNotEmpty(this.securityProperties.getCorsAllowedMethods())) {
            allowMethods = new ArrayList<String>(allowMethods);
            allowMethods.addAll(this.securityProperties.getCorsAllowedMethods());
        }
        configuration.setAllowedMethods(allowMethods);
        List<String> allowHeaders = ALLOWED_HEADERS;
        if (CollectionUtils.isNotEmpty(this.securityProperties.getCorsAllowedHeaders())) {
            allowHeaders = new ArrayList<String>(allowHeaders);
            allowHeaders.addAll(this.securityProperties.getCorsAllowedHeaders());
        }
        configuration.setAllowedHeaders(allowHeaders);
        List<String> exposeHeaders = EXPOSE_HEADERS;
        if (CollectionUtils.isNotEmpty(this.securityProperties.getCorsExposedHeaders())) {
            exposeHeaders = new ArrayList<String>(exposeHeaders);
            exposeHeaders.addAll(this.securityProperties.getCorsExposedHeaders());
        }
        configuration.setExposedHeaders(exposeHeaders);
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setMaxAge(Long.valueOf(10L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Controller
    public class RemoteUserLogoffController {
        @GetMapping(value={"/remoteUserLogoff"})
        public String logoff() {
            return "system/remoteUserLogoff";
        }
    }
}

