/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.function.Function;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.autoconfiguration.DefaultLogonAuthenticationConfigure;
import jp.jasminesoft.jfc.autoconfiguration.MultipleSessionAutoLogonConfigure;
import jp.jasminesoft.jfc.autoconfiguration.PreAuthenticationConfigurer;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.autoconfiguration.util.SecurityConfigurationUtils;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@ConditionalOnSingleCandidate(value=SecurityConfiguration.class)
@ConditionalOnMissingBean(value={OAuth2UserService.class})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    protected SessionProperties sessionProperties;
    @Autowired
    protected ServerProperties serverProperties;
    @Autowired
    protected SecurityProperties securityProperties;
    @Autowired
    protected DataSource dataSource;
    @Autowired
    protected AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    protected AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    protected AuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    protected LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    protected PasswordEncoder passwordEncoder;

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/img/**", "/**/*.css", "/**/*.js", "/error"})).antMatchers(new String[]{"/**/favicon.ico"})).antMatchers(new String[]{"/dojo-release-*/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.permitAllUrls())).permitAll().anyRequest()).authenticated().and()).headers().frameOptions().sameOrigin().and()).formLogin().usernameParameter("user").passwordParameter("pass").loginPage(this.securityProperties.logonPage).loginProcessingUrl(this.securityProperties.loginProcessingUrl)).successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).and()).exceptionHandling().authenticationEntryPoint(this.authenticationEntryPoint).and()).logout().logoutSuccessHandler(this.logoutSuccessHandler).invalidateHttpSession(true).permitAll().and()).csrf().disable();
        this.multipleSessionAutoLogonConfigure(http);
        this.defaultLogonConfigure(http);
        this.preAuthenticationConfigure(http);
        if (CollectionUtils.isNotEmpty(this.securityProperties.getCorsAllowedOrigins())) {
            http.cors();
        }
    }

    public void preAuthenticationConfigure(HttpSecurity http) throws Exception {
        if (!this.securityProperties.isValidPreAuthentication()) {
            return;
        }
        http.apply((SecurityConfigurerAdapter)new PreAuthenticationConfigurer());
    }

    public void multipleSessionAutoLogonConfigure(HttpSecurity http) throws Exception {
        if (StoreType.NONE == this.sessionProperties.getStoreType() && !this.securityProperties.isMapSessionRepository()) {
            return;
        }
        ((MultipleSessionAutoLogonConfigure)http.apply(new MultipleSessionAutoLogonConfigure())).requiresAuthenticationRequestMatcher(SecurityConfigurationUtils.autoLogonAuthenticationRequestMatcher(this.securityProperties)).failureHandler(this.authenticationFailureHandler);
    }

    public String[] permitAllUrls() {
        return SecurityConfigurationUtils.permitAllUrls(this.securityProperties);
    }

    private void defaultLogonConfigure(HttpSecurity http) throws Exception {
        if (StringUtils.isBlank((String)this.securityProperties.internetUserName)) {
            return;
        }
        ((DefaultLogonAuthenticationConfigure)http.apply(new DefaultLogonAuthenticationConfigure())).internetUserName(this.securityProperties.internetUserName).internetUserPassword(this.securityProperties.internetUserPassword).requiresAuthenticationRequestMatcher(SecurityConfigurationUtils.defaultLogonAuthenticationRequestMatcher(this.securityProperties)).failureHandler(this.authenticationFailureHandler);
    }

    @Autowired
    protected void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        if (this.securityProperties.isValidPreAuthentication()) {
            return;
        }
        this.ldapAuthentication(auth);
        this.activeDirectoryAuthentication(auth);
        this.jdbcAuthentication(auth);
    }

    protected SecurityProperties.Ldap ldap() {
        return this.securityProperties.getLdap();
    }

    protected SecurityProperties.ActiveDirectory activeDirectory() {
        return this.securityProperties.getActiveDirectory();
    }

    protected void ldapAuthentication(AuthenticationManagerBuilder auth) throws Exception {
        if (StringUtils.isBlank((String)this.ldap().getUrl())) {
            return;
        }
        auth.ldapAuthentication().userSearchFilter(this.ldap().getUserSearchFilter()).userSearchBase(this.ldap().getUserSearchBase()).groupSearchBase(null).contextSource().url(this.ldap().getUrl()).managerDn(this.ldap().getManagerDn()).managerPassword(this.ldap().getManagerPassword());
    }

    protected void activeDirectoryAuthentication(AuthenticationManagerBuilder auth) {
        if (StringUtils.isBlank((String)this.securityProperties.getActiveDirectory().getUrl())) {
            return;
        }
        SecurityProperties.ActiveDirectory ad = this.activeDirectory();
        ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(ad.getDomain(), ad.getUrl());
        if (StringUtils.isNotBlank((String)ad.getSearchFilter())) {
            provider.setSearchFilter(ad.getSearchFilter());
        }
        provider.setConvertSubErrorCodesToExceptions(true);
        provider.setUseAuthenticationRequestCredentials(true);
        auth.authenticationProvider((AuthenticationProvider)provider);
    }

    protected void jdbcAuthentication(AuthenticationManagerBuilder auth) throws Exception {
        if (!this.securityProperties.isValidJdbcAuthentication()) {
            return;
        }
        String quoteId = (String)this.serverProperties.getServlet().getContextParameters().get("jdbc.quote_id");
        Function<String, String> quote = name -> StringUtils.enclose(name, quoteId, quoteId);
        String usersByUsernameQuery = "SELECT " + quote.apply("userid") + ", " + quote.apply("passwd") + ", " + "1 AS ENABLED " + "FROM " + quote.apply("juser") + " WHERE " + quote.apply("userid") + " = ?";
        String authoritiesByUsernameQuery = "SELECT " + quote.apply("userid") + ", " + "'ROLE_USER' " + "FROM " + quote.apply("juser") + " WHERE " + quote.apply("userid") + " = ?";
        auth.jdbcAuthentication().dataSource(this.dataSource).usersByUsernameQuery(usersByUsernameQuery).authoritiesByUsernameQuery(authoritiesByUsernameQuery).passwordEncoder(this.passwordEncoder);
    }
}

