/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component(value="jfcSecurityProperties")
@ConfigurationProperties(prefix="wagby.security")
public class SecurityProperties {
    protected String logonPage = "/logonPage.do";
    protected String loginProcessingUrl = "/logon.do";
    protected String logonSuccessUrl = "/logon.do";
    @Value(value="${server.servlet.context-parameters.backToMenuAfterSessionTimeout:false}")
    protected boolean alwaysUseDefaultTargetUrl;
    protected List<String> permitAllUrls = new ArrayList<String>();
    private final Ldap ldap = new Ldap();
    private final ActiveDirectory activeDirectory = new ActiveDirectory();
    private boolean useJdbcAuthentication;
    @Value(value="${server.servlet.context-parameters.ignore_logoncheckUsername:}")
    protected String internetUserName;
    @Value(value="${server.servlet.context-parameters.ignore_logoncheckPassword:}")
    protected String internetUserPassword;
    protected List<String> corsAllowedOrigins = new ArrayList<String>();
    protected List<String> corsAllowedMethods = new ArrayList<String>();
    protected List<String> corsAllowedHeaders = new ArrayList<String>();
    protected List<String> corsExposedHeaders = new ArrayList<String>();
    protected String resturlRegex;
    private String authenticationType;
    private final BCrypt bcrypt = new BCrypt();
    private String remoteUserLogoffSuccessUrl = "/remoteUserLogoff.do";
    private boolean mapSessionRepository;

    public String getLogonPage() {
        return this.logonPage;
    }

    public void setLogonPage(String logonPage) {
        this.logonPage = logonPage;
    }

    public String getLoginProcessingUrl() {
        return this.loginProcessingUrl;
    }

    public void setLoginProcessingUrl(String loginProcessingUrl) {
        this.loginProcessingUrl = loginProcessingUrl;
    }

    public String getLogonSuccessUrl() {
        return this.logonSuccessUrl;
    }

    public void setLogonSuccessUrl(String logonSuccessUrl) {
        this.logonSuccessUrl = logonSuccessUrl;
    }

    public String getRemoteUserLogoffSuccessUrl() {
        return this.remoteUserLogoffSuccessUrl;
    }

    public void setRemoteUserLogoffSuccessUrl(String remoteUserLogoffSuccessUrl) {
        this.remoteUserLogoffSuccessUrl = remoteUserLogoffSuccessUrl;
    }

    public boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    public List<String> getPermitAllUrls() {
        return this.permitAllUrls;
    }

    public Ldap getLdap() {
        return this.ldap;
    }

    public ActiveDirectory getActiveDirectory() {
        return this.activeDirectory;
    }

    public boolean isUseJdbcAuthentication() {
        return this.useJdbcAuthentication;
    }

    public void setUseJdbcAuthentication(boolean useJdbcAuthentication) {
        this.useJdbcAuthentication = useJdbcAuthentication;
    }

    public boolean isValidJdbcAuthentication() {
        if (this.isValidPreAuthentication()) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)this.getLdap().getUrl()) && !StringUtils.isNotBlank((CharSequence)this.getActiveDirectory().getUrl()) || this.isUseJdbcAuthentication();
    }

    public List<String> getCorsAllowedOrigins() {
        return this.corsAllowedOrigins;
    }

    public List<String> getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public List<String> getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public List<String> getCorsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    public String getResturlRegex() {
        return this.resturlRegex;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public boolean isRequestRemoteUser() {
        return "requestRemoteUser".equals(this.getAuthenticationType());
    }

    public boolean isValidPreAuthentication() {
        return this.isRequestRemoteUser();
    }

    public BCrypt getBcrypt() {
        return this.bcrypt;
    }

    public boolean isMapSessionRepository() {
        return this.mapSessionRepository;
    }

    public void setMapSessionRepository(boolean mapSessionRepository) {
        this.mapSessionRepository = mapSessionRepository;
    }

    public class BCrypt {
        private Integer strength;

        public Integer getStrength() {
            return this.strength;
        }

        public void setStrength(Integer strength) {
            this.strength = strength;
        }
    }

    public static class ActiveDirectory {
        private String url;
        private String domain;
        private String searchFilter;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getSearchFilter() {
            return this.searchFilter;
        }

        public void setSearchFilter(String searchFilter) {
            this.searchFilter = searchFilter;
        }
    }

    public static class Ldap {
        private String url;
        private String userSearchFilter;
        private String userSearchBase;
        private String managerDn;
        private String managerPassword;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUserSearchFilter() {
            return this.userSearchFilter;
        }

        public void setUserSearchFilter(String userSearchFilter) {
            this.userSearchFilter = userSearchFilter;
        }

        public String getUserSearchBase() {
            if (StringUtils.isBlank((CharSequence)this.userSearchBase)) {
                return "";
            }
            return this.userSearchBase;
        }

        public void setUserSearchBase(String userSearchBase) {
            this.userSearchBase = userSearchBase;
        }

        public String getManagerDn() {
            if (StringUtils.isBlank((CharSequence)this.managerDn)) {
                return null;
            }
            return this.managerDn;
        }

        public void setManagerDn(String managerDn) {
            this.managerDn = managerDn;
        }

        public String getManagerPassword() {
            if (StringUtils.isBlank((CharSequence)this.managerPassword)) {
                return null;
            }
            return this.managerPassword;
        }

        public void setManagerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
        }
    }
}

