/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
public class WebMvcConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    @Qualifier(value="stringHttpMessageConverter")
    protected StringHttpMessageConverter stringHttpMessageConverter;
    @Autowired
    @Qualifier(value="formHttpMessageConverter")
    protected FormHttpMessageConverter formHttpMessageConverter;
    @Autowired
    @Qualifier(value="mappingJacksonMessageConverter")
    protected MappingJackson2HttpMessageConverter jacksonMessageConverter;
    @Autowired
    @Qualifier(value="jaxb2RootElementMessageConverter")
    protected Jaxb2RootElementHttpMessageConverter jaxbMessageConverter;
    private static final String JSON_CONTENT_DISPOSITION_VALUE = "attachment; filename=\"a.json\"";

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.stringHttpMessageConverter);
        converters.add((HttpMessageConverter<?>)this.formHttpMessageConverter);
        converters.add((HttpMessageConverter<?>)this.jacksonMessageConverter);
        converters.add((HttpMessageConverter<?>)this.jaxbMessageConverter);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.RestContentDispositionInterceptor()).addPathPatterns(new String[]{"/rest/**"});
    }

    @Bean
    RestContentDispositionInterceptor RestContentDispositionInterceptor() {
        return new RestContentDispositionInterceptor();
    }

    private static class RestContentDispositionInterceptor
    implements HandlerInterceptor {
        private RestContentDispositionInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            response.setHeader("Content-Disposition", WebMvcConfiguration.JSON_CONTENT_DISPOSITION_VALUE);
            return true;
        }
    }
}

