/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.ExcelFunction;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AnalyticsLogController
extends BaseController {
    public static final String FromDateName = "_from_day";
    public static final String ToDateName = "_to_day";
    public static final String LogDataName = "logdata";
    public static final String LogDataLabel = "logdatalabels";
    public static final String[] analyticsRange = new String[]{"Month", "24Hour"};

    @Override
    @RequestMapping(value={"/analyticsLog.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.analyticsLog";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "analyticsLog");
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("analystics", "show");
    }

    @Override
    public String perform0(ActionParameter p) throws IOException, ServletException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date from_day = DateTimeUtil.getUtilDate((java.sql.Date)ExcelFunction.BOMONTH((Date)new Date()));
        p.request.setAttribute(FromDateName, (Object)sdf.format(from_day));
        Date to_day = DateTimeUtil.getUtilDate((java.sql.Date)ExcelFunction.EOMONTH((Date)new Date()));
        p.request.setAttribute(ToDateName, (Object)sdf.format(to_day));
        String _analytics_range_selected = p.request.getParameter("analyticsRange");
        if (StringUtils.isBlank((CharSequence)_analytics_range_selected)) {
            _analytics_range_selected = analyticsRange[0];
        }
        p.request.setAttribute("_analytics_range", (Object)analyticsRange);
        p.request.setAttribute("_analytics_range_selected", (Object)_analytics_range_selected);
        return this.getInputForward(p);
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }
}

