/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.Serializable;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.IListHelper;
import jp.jasminesoft.jfc.app.IListPHelper;
import jp.jasminesoft.jfc.controller.DbShowControllerDataitem;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.jfc.tag.CheckLogonBase;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ChildDbShowControllerDataitem<E extends ContainerBase<E>, EL, ELp, PK extends Serializable, T extends ContainerBase<T>, TPK extends Serializable>
implements DbShowControllerDataitem<T> {
    private JFCErrorManager errorManager;
    private JFCEntityService<E, PK> service;
    private EntityHelper<T, TPK> parentEntityHelper;
    private IListHelper<E, EL> listHelper;
    private IListPHelper<EL, ELp, E> listPHelper;

    @Autowired
    public void setJFCErrorManager(JFCErrorManager errorManager1) {
        this.errorManager = errorManager1;
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    public void setEntityService(JFCEntityService<E, PK> service) {
        this.service = service;
    }

    public void setParentEntityHelper(EntityHelper<T, TPK> helper) {
        this.parentEntityHelper = helper;
    }

    public EntityHelper<T, TPK> getParentEntityHelper() {
        return this.parentEntityHelper;
    }

    public void setListHelper(IListHelper<E, EL> helper) {
        this.listHelper = helper;
    }

    public IListHelper<E, EL> getListHelper() {
        return this.listHelper;
    }

    public void setListPHelper(IListPHelper<EL, ELp, E> helper) {
        this.listPHelper = helper;
    }

    public IListPHelper<EL, ELp, E> getListPHelper() {
        return this.listPHelper;
    }

    public FinderContext<TPK> getFinderContext() {
        throw new RuntimeException();
    }

    public abstract String getModelId();

    @Override
    public void do_show(ActionParameter p, T tentity) {
        Object entitylp = null;
        CheckLogonBase cl = new CheckLogonBase();
        cl.setPermclassname("jp.jasminesoft.jfc.JFCAppPermission");
        cl.setPermname(this.getModelIdPermission());
        cl.setPermactions("showlist");
        boolean ret = cl.checkLogon(p);
        String tpks = this.getParentEntityHelper().getPrimarykeyAsString(tentity, p);
        if (ret && StringUtils.isNotBlank((CharSequence)tpks)) {
            ContainerBase[] entityAry = null;
            try {
                FinderContext<TPK> finderContext = this.getFinderContext();
                TPK tpk = this.getParentEntityHelper().getPrimarykey(tentity);
                finderContext.setCondition(tpk);
                List<E> op = this.service.find(finderContext);
                if (op != null) {
                    entityAry = op.toArray(this.newEntityArray(op.size()));
                    EL entityl = this.getListHelper().s2l(entityAry, p);
                    entitylp = this.getListPHelper().l2lp(entityl, p);
                    p.request.setAttribute(this.getEntityArrayRequestName(), (Object)entityAry);
                    p.pageMap.put(this.getEntityArrayPageMapName(), entityAry);
                    p.request.setAttribute(this.getDatasListPRequestName(), (Object)entityAry);
                    p.request.setAttribute(this.getListPRequestName(), entitylp);
                    p.appMap.put(this.getListPAppMapName(), entitylp);
                }
            }
            catch (Exception e) {
                Object[] ep = new Object[]{e.getMessage()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess", ep, p.locale));
            }
        }
        if (entitylp == null) {
            entitylp = this.newListPModel();
        }
        p.request.setAttribute(this.getListPRequestName(), entitylp);
        p.appMap.put(this.getListPAppMapName(), entitylp);
    }

    protected String getModelIdPermission() {
        return this.getModelId();
    }

    protected String getEntityArrayRequestName() {
        return this.getModelId() + "_ary";
    }

    protected String getEntityArrayPageMapName() {
        return this.getModelId() + "_ary";
    }

    protected String getListPRequestName() {
        return this.getModelId() + "_lp";
    }

    protected String getListPAppMapName() {
        return this.getModelId() + "_lp_preserve";
    }

    protected String getDatasListPRequestName() {
        return "datas_" + this.getModelId() + "_lp";
    }

    public abstract ELp newListPModel();

    public abstract E[] newEntityArray(int var1);
}

