/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCErrorMessageConverter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuManager;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.ScriptCodeRunner4Controller;
import jp.jasminesoft.jfc.app.Changelog;
import jp.jasminesoft.jfc.app.ChangelogFormatter;
import jp.jasminesoft.jfc.app.CreateObjectHelper;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.JfccspreferenceitemManager;
import jp.jasminesoft.jfc.app.MailMessageManager;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.model.PresentationContainerBase;
import jp.jasminesoft.jfc.model.jfccspreferenceitem.IJfccspreferenceitem;
import jp.jasminesoft.jfc.model.mailmessage.Mailmessage;
import jp.jasminesoft.jfc.model.pankuzu.Pankuzu;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.repgen.JfcreporttemplateUtil;
import jp.jasminesoft.jfc.service.JFCAbstractEntityService;
import jp.jasminesoft.jfc.textsearch.servlet.TextsearchUtil;
import jp.jasminesoft.util.HolidayManager;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringConvKigouZ2HFilter;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.TransactionStatus;

public class DbBaseController<E>
extends BaseController {
    public static final String ConnectionAppmapName = "__jfc_connection";
    public static final String ConnectionInterfaceAppmapName = "__jfc_connectioninterface";
    public static final String IsKeepConnectionAppmapName = "__jfc_isKeepConnection";
    public static final String ResultBeanName = "jfc_result";
    public static final String WizardKeyRequestName = "__jfc_keyname";
    public static final String ClassnameLockobjMapSessionName = "__jfc_DbBaseAction_classnameLockobjMap";
    public static final String EMPTY_ERROR_MESSAGE = " ";
    private static final Logger logger = LogManager.getLogger((String)DbBaseController.class.getName());
    private static final String LoadConditionSettingActionStr = "LoadConditionSetting";
    private static final String DeleteConditionSettingActionStr = "DeleteConditionSetting";
    private static final String SaveConditionSettingActionStr = "SaveConditionSetting";
    private static final String CONDITION_NAME_PARAM = "conditionname";
    private static final String COMMON_CONDITION_ATTR_HEADER = "jfcconditionsetting_";
    private static final String USER_CONDITION_ATTR_HEADER = "jfcuserconditionsetting_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String perform0(ActionParameter p) throws IOException, ServletException {
        Object object;
        String forward = super.perform0(p);
        if (forward != null) {
            return forward;
        }
        HolidayManager hman = HolidayManager.getInstance();
        if (hman.isNeedsToReadUserData()) {
            object = hman;
            synchronized (object) {
                this.initHolidayManager(p, hman);
            }
        }
        try {
            object = this.getLockObject(p);
            synchronized (object) {
                this.before_perform_db(p);
                forward = this.perform_db(p);
                this.after_perform_db(p);
                String forward0 = this.processScript4Controller(p);
                if (forward0 != null && forward0.startsWith("forward:")) {
                    forward = forward0;
                } else if (forward0 != null && forward0.startsWith("redirect:")) {
                    forward = forward0;
                } else if (forward0 != null && forward0.equals("none")) {
                    p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
                    forward = null;
                }
            }
        }
        finally {
            String username = "";
            if (p.user != null) {
                username = p.user.getUsername();
            }
        }
        return forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHolidayManager(ActionParameter dp, HolidayManager hman) {
        if (!hman.isNeedsToReadUserData()) {
            return;
        }
        try {
            hman.reset();
            hman.readICS(this.getResourceAsStream("/WEB-INF/" + this.getJfcConfig().getICSfilename()));
            ApplicationContext appctx = this.getApplicationContext();
            JFCAbstractEntityService entityService = (JFCAbstractEntityService)appctx.getBean("JholidayEntityService", JFCAbstractEntityService.class);
            List list = entityService.find();
            list.stream().forEach(holiday -> hman.setHoliday((Date)holiday.getHdate(), holiday.getName()));
            hman.setIsHolidayScript(this.getResourceAsStream("/WEB-INF/" + JFCUtils.getIsHolidayScriptName()), (Object)dp);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00211), LogCodeManager.getMessage(LogCode.JFC00211, dp.user, e.getMessage()), (Throwable)e);
        }
        finally {
            hman.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLockObject(ActionParameter p) {
        HttpSession session = p.request.getSession();
        ConcurrentHashMap<String, String> classnameLockobjMap = (ConcurrentHashMap<String, String>)session.getAttribute(ClassnameLockobjMapSessionName);
        if (classnameLockobjMap == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                classnameLockobjMap = (ConcurrentHashMap)session.getAttribute(ClassnameLockobjMapSessionName);
                if (classnameLockobjMap == null) {
                    classnameLockobjMap = new ConcurrentHashMap<String, String>();
                    session.setAttribute(ClassnameLockobjMapSessionName, classnameLockobjMap);
                }
            }
        } else {
            session.setAttribute(ClassnameLockobjMapSessionName, (Object)classnameLockobjMap);
        }
        String newlockobj = new String();
        String lockobj = classnameLockobjMap.putIfAbsent(this.getClass().toString(), newlockobj);
        if (lockobj == null) {
            return newlockobj;
        }
        return lockobj;
    }

    protected Connection getConnection(ActionParameter p) {
        Connection con = null;
        DataSource dataSource = JFCUtils.getDataSource();
        try {
            if (dataSource != null) {
                con = dataSource.getConnection();
                logger.debug(JFCUtils.logmsg(p, "Connection object has been reassigned."));
            }
        }
        catch (SQLException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00110), LogCodeManager.getMessage(LogCode.JFC00110, p.user, new String[0]), (Throwable)e);
        }
        return con;
    }

    protected boolean isWishCloseConnection(ActionParameter p) {
        return true;
    }

    protected boolean isWishCloseConnectionInterface(ActionParameter p) {
        return true;
    }

    public String perform_db(ActionParameter p) throws IOException, ServletException {
        return null;
    }

    public Object retrieveKey(ActionParameter p) {
        return null;
    }

    public Object retrieveData(ActionParameter p) {
        return null;
    }

    public String do_original(ActionParameter p) throws IOException, ServletException {
        return null;
    }

    public String do_default(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public void before_perform_db(ActionParameter p) throws IOException, ServletException {
    }

    public void after_perform_db(ActionParameter p) throws IOException, ServletException {
    }

    public String do_masterref(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_addItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_removeItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_moveUpItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_moveDownItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_sortItem(ActionParameter p) throws IOException, ServletException {
        boolean normalOrder = true;
        String key = this.getKey4SortItem();
        String sort_key = (String)p.pageMap.get(key);
        String _sort_key = p.action.substring("Sort_".length());
        if (_sort_key != null && _sort_key.length() > 0) {
            if (_sort_key.endsWith(":DESC")) {
                normalOrder = false;
                _sort_key = _sort_key.substring(0, _sort_key.length() - ":DESC".length());
            }
            sort_key = _sort_key;
        }
        p.pageMap.put(key, sort_key);
        p.request.setAttribute("__jfc_container_sortorder", (Object)normalOrder);
        return this.do_sortItem0(p);
    }

    protected String getKey4SortItem() {
        return this.getStatus() + "__jfc_container_sortkey";
    }

    public String do_sortItem0(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    protected void sortContainer(E entity, String itemName, String contName, String cidName, ActionParameter p) {
        String sort_key = (String)p.pageMap.get(this.getKey4SortItem());
        Boolean normalOrder = (Boolean)p.request.getAttribute("__jfc_container_sortorder");
        if (sort_key == null || normalOrder == null) {
            return;
        }
        if (itemName.indexOf(sort_key) < 0) {
            return;
        }
        String getter = SourceGeneratorUtil.getterMethod((String)contName);
        String setter = SourceGeneratorUtil.setterMethod((String)contName);
        String sortKeyItemName = StringUtil.convertELProperty((String)sort_key);
        Object[] array = null;
        try {
            array = (Object[])MethodUtils.invokeMethod(entity, (String)getter, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        BeanComparator comp = null;
        try {
            BeanComparator comp1;
            comp = normalOrder != false ? (comp1 = new BeanComparator(sortKeyItemName, (Comparator)new NullComparator(false))) : (comp1 = new BeanComparator(sortKeyItemName, (Comparator)new ReverseComparator((Comparator)new NullComparator(false))));
            Arrays.sort(array, comp);
            if (cidName != null) {
                String setter4Cid = SourceGeneratorUtil.setterMethod((String)cidName);
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    Object v_array_on_index = Array.get(array, i);
                    MethodUtils.invokeMethod((Object)v_array_on_index, (String)setter4Cid, (Object)(i + 1));
                }
            }
            MethodUtils.invokeMethod(entity, (String)setter, (Object[])new Object[]{array});
            return;
        }
        catch (Exception setter4Cid) {
            Object[] fields = array[0].getClass().getDeclaredFields();
            if (ArrayUtils.isEmpty((Object[])fields)) {
                return;
            }
            LinkedHashSet<String> candidateSet = new LinkedHashSet<String>();
            for (Object field : fields) {
                String fname = ((Field)field).getName();
                String fname2 = fname.substring(0, 1).toUpperCase() + fname.substring(1, fname.length());
                if (fname.startsWith(sortKeyItemName)) {
                    if (fname.endsWith("_")) {
                        fname = fname.substring(0, fname.length() - 1);
                    }
                    candidateSet.add(fname);
                    continue;
                }
                if (!fname2.startsWith(sortKeyItemName)) continue;
                if (fname2.endsWith("_")) {
                    fname2 = fname2.substring(0, fname2.length() - 1);
                }
                candidateSet.add(fname2);
            }
            try {
                int i;
                String[] items;
                if (normalOrder.booleanValue()) {
                    items = candidateSet.toArray(new String[candidateSet.size()]);
                    for (i = 0; i < items.length; ++i) {
                        BeanComparator comp1;
                        comp = comp1 = new BeanComparator(items[i], (Comparator)new NullComparator(false));
                    }
                } else {
                    items = candidateSet.toArray(new String[candidateSet.size()]);
                    for (i = 0; i < items.length; ++i) {
                        BeanComparator comp1;
                        comp = comp1 = new BeanComparator(items[i], (Comparator)new ReverseComparator((Comparator)new NullComparator(false)));
                    }
                }
                Arrays.sort(array, comp);
                if (cidName != null) {
                    String setter4Cid2 = SourceGeneratorUtil.setterMethod((String)cidName);
                    int length = Array.getLength(array);
                    for (int i2 = 0; i2 < length; ++i2) {
                        Object v_array_on_index = Array.get(array, i2);
                        MethodUtils.invokeMethod((Object)v_array_on_index, (String)setter4Cid2, (Object)(i2 + 1));
                    }
                }
                MethodUtils.invokeMethod(entity, (String)setter, (Object[])new Object[]{array});
            }
            catch (NoSuchMethodException e) {
                System.out.println("stauts=" + this.getStatus() + ", entity=" + entity);
                System.out.println("itemName=" + itemName + ",contName=" + contName + ",cidName=" + cidName + ",sort_key=" + sort_key + ",normalOrder=" + normalOrder);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.out.println("stauts=" + this.getStatus() + ", entity=" + entity);
                System.out.println("itemName=" + itemName + ",contName=" + contName + ",cidName=" + cidName + ",sort_key=" + sort_key + ",normalOrder=" + normalOrder);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                System.out.println("stauts=" + this.getStatus() + ", entity=" + entity);
                System.out.println("itemName=" + itemName + ",contName=" + contName + ",cidName=" + cidName + ",sort_key=" + sort_key + ",normalOrder=" + normalOrder);
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("stauts=" + this.getStatus() + ", entity=" + entity);
                System.out.println("itemName=" + itemName + ",contName=" + contName + ",cidName=" + cidName + ",sort_key=" + sort_key + ",normalOrder=" + normalOrder);
                e.printStackTrace();
            }
            return;
        }
    }

    protected <P> void setSortOrder(P entity_p, String itemName, String contName, ActionParameter p) {
        String sort_key = (String)p.pageMap.get(this.getKey4SortItem());
        Boolean normalOrder = (Boolean)p.request.getAttribute("__jfc_container_sortorder");
        if (sort_key == null || normalOrder == null) {
            return;
        }
        if (itemName.indexOf(sort_key) < 0) {
            return;
        }
        String getter = SourceGeneratorUtil.getterMethod((String)contName);
        try {
            Object[] array = (Object[])MethodUtils.invokeMethod(entity_p, (String)getter, null);
            int length = Array.getLength(array);
            if (array != null && length > 0) {
                Object v_array_on_index = Array.get(array, 0);
                MethodUtils.invokeMethod((Object)v_array_on_index, (String)"setSort", (Object)sort_key);
                if (normalOrder.booleanValue()) {
                    MethodUtils.invokeMethod((Object)v_array_on_index, (String)"setOrder", (Object)"normal");
                } else {
                    MethodUtils.invokeMethod((Object)v_array_on_index, (String)"setOrder", (Object)"reverse");
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String do_zipCode(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String getWizardStatusKeyName() {
        StringBuffer sb = new StringBuffer("__jfc_");
        sb.append(this.getModelId());
        sb.append("_wpage");
        return sb.toString();
    }

    public int getWizardStatus(ActionParameter p) {
        int wpage = 1;
        String _wpage_key = this.getWizardStatusKeyName();
        Integer _wpage = (Integer)p.request.getAttribute(_wpage_key);
        if (_wpage != null) {
            wpage = _wpage;
        } else {
            String _wpage_str = p.request.getParameter(_wpage_key);
            if (_wpage_str != null && _wpage_str.length() > 0) {
                wpage = StringUtil.intValue((String)_wpage_str);
                if (wpage == 0) {
                    wpage = 1;
                }
                logger.debug(JFCUtils.logmsg(p, _wpage_key + " is " + wpage));
            } else {
                Integer _wpagei = (Integer)p.pageMap.get(_wpage_key);
                if (_wpagei != null) {
                    wpage = _wpagei;
                }
                logger.debug(JFCUtils.logmsg(p, "use pageMap, " + _wpage_key + " is " + wpage));
            }
        }
        return wpage;
    }

    public void setWizardStatus(ActionParameter p, int wpage) {
        String _wpage_key = this.getWizardStatusKeyName();
        String _o_wpage_key = (String)p.pageMap.get(WizardKeyRequestName);
        if (_o_wpage_key != null && !_o_wpage_key.equals(_wpage_key)) {
            return;
        }
        if (wpage < 1) {
            wpage = 1;
        }
        Integer _wpage = wpage;
        p.pageMap.put(WizardKeyRequestName, _wpage_key);
        p.pageMap.put(_wpage_key, _wpage);
        p.request.setAttribute(WizardKeyRequestName, (Object)_wpage_key);
        p.request.setAttribute(_wpage_key, (Object)_wpage);
        p.redirectMap.put(WizardKeyRequestName, _wpage_key);
        p.redirectMap.put(_wpage_key, _wpage);
    }

    public String do_wizread(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_wizmove(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_nodata(ActionParameter p) {
        Object[] ep = new Object[]{p.user.getUsername()};
        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.nodata", ep, p.locale));
        p.request.setAttribute("action", (Object)"");
        p.request.setAttribute("jfcErrorHttpStatus", (Object)HttpStatus.NOT_FOUND);
        return this.getNodataForward();
    }

    public void do_preprocess(ActionParameter p) {
    }

    public String getNodataForward() {
        return "noData";
    }

    public String getEmptyForward() {
        return "empty";
    }

    public boolean do_sendmail(String mid, Map replaceMap, boolean isDisplayMessage, ActionParameter p) {
        ApplicationContext appctx = this.getApplicationContext();
        MailMessageManager mailman = (MailMessageManager)appctx.getBean("MailMessageManager");
        Mailmessage mm = mailman.getMailmessage(mid, p);
        if (mm == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00210), LogCodeManager.getMessage(LogCode.JFC00210, p.user, mid));
            return false;
        }
        Mailmessage n_mm = mailman.replace(mm, replaceMap);
        MimeMessage msg = mailman.createMimeMessage(mm, replaceMap);
        boolean status = mailman.send(n_mm, msg, this.getJFCErrorManager(), this.getLogHeader(p), p);
        if (isDisplayMessage) {
            p.request.setAttribute("__jfc_message_status", (Object)status);
        }
        return status;
    }

    public boolean isCommand(String cmd, ActionParameter p) {
        String _action = p.action;
        if (_action != null) {
            if (_action.indexOf(":") > 0) {
                _action = _action.substring(0, _action.indexOf(":"));
            }
            return _action.equals(cmd);
        }
        return false;
    }

    public boolean isAvailableCondPObject(ActionParameter p) {
        return this.getCommand(p) != CommandType.ChangeSidebar;
    }

    protected Map convertParameterMapKeyName(Map _map) {
        if (_map == null) {
            return null;
        }
        HashMap convertedMap = new HashMap();
        Iterator iterator = _map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            String convertedKey = key;
            String prefix = "${";
            String suffix = "}";
            if (key != null && key.startsWith(prefix) && key.endsWith(suffix)) {
                convertedKey = key.substring(prefix.length());
                convertedKey = convertedKey.substring(0, convertedKey.length() - suffix.length());
            }
            if (value != null && value instanceof String && ((String)value).length() == 0) {
                value = null;
            }
            convertedMap.put(convertedKey, value);
        }
        return convertedMap;
    }

    public JfcreporttemplateUtil.OutputType readReportTemplateValues(String templateid, Map<String, String> valueMap, ActionParameter p) {
        return JfcreporttemplateUtil.readTemplateValues(templateid, valueMap, p);
    }

    protected void deleteCookieHavingPrefix(String prefix, ActionParameter p) {
        ArrayList<String> cookiesForDeletion = new ArrayList<String>();
        Cookie[] cookies = p.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!StringUtils.startsWith((String)cookieName, (String)prefix)) continue;
                cookiesForDeletion.add(cookieName);
            }
        }
        if (cookiesForDeletion.size() > 0) {
            for (String cookieName : cookiesForDeletion) {
                this.setCookie(p, cookieName, "", 0);
            }
        }
    }

    protected String moveUpContainer(E entity, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveUpContainer(entity, null, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String moveUpContainer(E entity, Object entityp, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveContainer("MoveUp_", "moveUpContainer", entity, entityp, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String moveDownContainer(E entity, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveDownContainer(entity, null, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String moveDownContainer(E entity, Object entityp, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveContainer("MoveDown_", "moveDownContainer", entity, entityp, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String removeContainer(E entity, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.removeContainer(entity, null, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String removeContainer(E entity, Object entityp, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveContainer("Remove_", "removeContainer", entity, entityp, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String removeMultiple(E entity, String pid, String multipleName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.removeMultiple(entity, null, pid, multipleName, storeHelper, presentationHelper, p);
    }

    protected String removeMultiple(E entity, Object entityp, String pid, String multipleName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveContainer("Remove_", "removeMultiple", entity, entityp, pid, multipleName, null, storeHelper, presentationHelper, p);
    }

    protected String moveContainer(String actionHeader, String methodName, E entity, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.moveContainer(actionHeader, methodName, entity, null, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String moveContainer(String actionHeader, String methodName, E entity, Object entityp, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        String itempath0;
        String itempath = CreateObjectHelper.convertEscaping(p.action.substring(actionHeader.length()));
        String string = itempath0 = itempath.indexOf("[") >= 0 ? itempath.substring(0, itempath.indexOf("[")) : itempath;
        if (!itempath0.equals(pid + "/" + contName)) {
            return null;
        }
        try {
            if (cidName != null) {
                String index_str = itempath.substring(itempath0.length() + 1, itempath.length() - 1);
                int index_value = StringUtil.intValue((String)index_str);
                int[] jshcontnums = this.getJshcontnums(entityp, contName);
                if (jshcontnums != null) {
                    this.setCidSequence(entity, contName, cidName);
                    this.moveContainerJshcontnums(methodName, entity, contName, cidName, storeHelper, index_value, jshcontnums);
                } else {
                    Object[] params = new Object[]{entity, index_value - 1, contName, cidName};
                    MethodUtils.invokeMethod(storeHelper, (String)methodName, (Object[])params);
                }
            } else {
                Object[] params = new Object[]{entity, contName};
                MethodUtils.invokeMethod(storeHelper, (String)methodName, (Object[])params);
            }
            if (p.errors.sizeJfcerror() > 0) {
                Object n_obj = presentationHelper.s2p(entity, p, 2);
                p.request.setAttribute(pid, n_obj);
                p.appMap.put(pid + "_preserve", n_obj);
                return this.getInputForward(p);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setCidSequence(E entity, String contName, String cidName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String getter = SourceGeneratorUtil.getterMethod((String)contName);
        Object[] array = (Object[])MethodUtils.invokeMethod(entity, (String)getter, null);
        int length = Array.getLength(array);
        if (array != null && length > 0) {
            String setter4Cid = SourceGeneratorUtil.setterMethod((String)cidName);
            for (int i = 0; i < length; ++i) {
                Object v_array_on_index = Array.get(array, i);
                MethodUtils.invokeMethod((Object)v_array_on_index, (String)setter4Cid, (Object)(i + 1));
            }
        }
    }

    private void moveContainerJshcontnums(String methodName, E entity, String contName, String cidName, Object storeHelper, int index_value, int[] jshcontnums) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<Integer> index_values = this.getMoveContainerIndexValue(jshcontnums, index_value);
        if (methodName.equals("removeContainer")) {
            Collections.reverse(index_values);
            for (Integer index_value1 : index_values) {
                Object[] params = new Object[]{entity, index_value1 - 1, contName, cidName};
                MethodUtils.invokeMethod((Object)storeHelper, (String)methodName, (Object[])params);
            }
            return;
        }
        if (methodName.equals("moveUpContainer")) {
            if (index_value <= 1) {
                return;
            }
            List<Integer> before_index_values = this.getMoveContainerIndexValue(jshcontnums, index_value - 1);
            int move_size = before_index_values.size();
            if (move_size == 0) {
                return;
            }
            for (Integer index_value1 : index_values) {
                int k = index_value1 - 1;
                for (int j = 0; j < move_size; ++j) {
                    Object[] params = new Object[]{entity, k - j, contName, cidName};
                    MethodUtils.invokeMethod((Object)storeHelper, (String)methodName, (Object[])params);
                }
            }
            return;
        }
        if (methodName.equals("moveDownContainer")) {
            List<Integer> after_index_values = this.getMoveContainerIndexValue(jshcontnums, index_value + 1);
            int move_size = after_index_values.size();
            if (move_size == 0) {
                return;
            }
            Collections.reverse(index_values);
            for (Integer index_value1 : index_values) {
                int k = index_value1 - 1;
                for (int j = 0; j < move_size; ++j) {
                    Object[] params = new Object[]{entity, k + j, contName, cidName};
                    MethodUtils.invokeMethod((Object)storeHelper, (String)methodName, (Object[])params);
                }
            }
            return;
        }
        throw new IllegalStateException("Unknown methodName " + methodName);
    }

    protected String addMultiple(E entity, String pid, String multipleName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.addMultiple(entity, null, pid, multipleName, storeHelper, presentationHelper, p);
    }

    protected String addMultiple(E entity, Object entityp, String pid, String multipleName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        String itempath0;
        String itempath = CreateObjectHelper.convertEscaping(p.action.substring("Add_".length()));
        String string = itempath0 = itempath.indexOf("[") >= 0 ? itempath.substring(0, itempath.indexOf("[")) : itempath;
        if (!itempath0.equals(pid + "/" + multipleName)) {
            return null;
        }
        try {
            Object[] params = new Object[]{entity, p, this.getJFCErrorManager()};
            String methodName = "add" + StringUtil.capFirst((String)multipleName);
            MethodUtils.invokeMethod(storeHelper, (String)methodName, (Object[])params);
            if (p.errors.sizeJfcerror() > 0) {
                Object n_obj = presentationHelper.s2p(entity, p, 2);
                p.request.setAttribute(pid, n_obj);
                p.appMap.put(pid + "_preserve", n_obj);
                return this.getInputForward(p);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String addContainer(E entity, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        return this.addContainer(entity, null, pid, contName, cidName, storeHelper, presentationHelper, p);
    }

    protected String addContainer(E entity, Object entityp, String pid, String contName, String cidName, EntityHelper<?, ?> storeHelper, PresentationPHelper<E, ?> presentationHelper, ActionParameter p) {
        String itempath0;
        String itempath = CreateObjectHelper.convertEscaping(p.action.substring("Add_".length()));
        String string = itempath0 = itempath.indexOf("[") >= 0 ? itempath.substring(0, itempath.indexOf("[")) : itempath;
        if (!itempath0.equals(pid + "/" + contName)) {
            return null;
        }
        String index_str = itempath.substring(itempath0.length() + 1, itempath.length() - 1);
        boolean appendMode = false;
        if (index_str.startsWith("a_003a")) {
            index_str = index_str.substring("a_003a".length());
            appendMode = true;
        }
        int index_value = StringUtil.intValue((String)index_str);
        try {
            int[] jshcontnums = this.getJshcontnums(entityp, contName);
            if (jshcontnums != null) {
                index_value = this.getAddContainerIndexValue(jshcontnums, index_value, appendMode);
            }
            String methodName = "add" + StringUtil.capFirst((String)contName);
            Object[] params = new Object[]{entity, index_value - 1, appendMode, p, this.getJFCErrorManager()};
            MethodUtils.invokeMethod(storeHelper, (String)methodName, (Object[])params);
            if (p.errors.sizeJfcerror() > 0) {
                Object n_obj = presentationHelper.s2p(entity, p, 2);
                p.request.setAttribute(pid, n_obj);
                p.appMap.put(pid + "_preserve", n_obj);
                return this.getInputForward(p);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected int[] getJshcontnums(Object entityp, String contName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (entityp == null) {
            return null;
        }
        String getter = SourceGeneratorUtil.getterMethod((String)contName);
        Object[] conts = (Object[])MethodUtils.invokeMethod((Object)entityp, (String)getter, (Object[])new Object[0]);
        int len = conts.length;
        int[] nums = new int[len];
        for (int i = 0; i < len; ++i) {
            Object cont = conts[i];
            if (!(cont instanceof PresentationContainerBase)) {
                return null;
            }
            nums[i] = ((PresentationContainerBase)cont).getJshcontnum();
        }
        if (!this.isCorrectContainer(nums)) {
            return null;
        }
        return nums;
    }

    private boolean isCorrectContainer(int[] nums) {
        boolean is_zero = true;
        boolean is_seqnum = true;
        int i = 1;
        for (int jshcontnum : nums) {
            if (jshcontnum != 0) {
                is_zero = false;
            }
            if (jshcontnum != i) {
                is_seqnum = false;
            }
            ++i;
        }
        return !is_zero && !is_seqnum;
    }

    protected int getAddContainerIndexValue(int[] jshcontnums, int index_value, boolean appendMode) {
        int i;
        for (i = 0; i < jshcontnums.length; ++i) {
            if (jshcontnums[i] == index_value) {
                if (appendMode) {
                    return i + 1;
                }
                ++i;
                while (i < jshcontnums.length) {
                    if (jshcontnums[i] != -1) {
                        return i;
                    }
                    ++i;
                }
            }
            if (jshcontnums[i] <= index_value) continue;
            if (appendMode) {
                return i + 1;
            }
            return i + 2;
        }
        return i + 1;
    }

    protected List<Integer> getMoveContainerIndexValue(int[] jshcontnums, int index_value) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < jshcontnums.length; ++i) {
            if (jshcontnums[i] != index_value) continue;
            list.add(i + 1);
            ++i;
            while (i < jshcontnums.length && jshcontnums[i] == -1) {
                list.add(i + 1);
                ++i;
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P> void outputXml(ActionParameter p, P entity_p) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        String contenttype = "text/xml";
        try (ServletOutputStream ostream = null;){
            ostream = p.response.getOutputStream();
            p.response.setCharacterEncoding(charset.name());
            p.response.setContentType("text/xml");
            p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
            ostream.write(entity_p.toString().getBytes(charset));
        }
    }

    protected void outputChangelog(String pkeyAsString, Changelog[] changelogs, Logger logger, ActionParameter p) {
        if (changelogs == null || changelogs.length == 0) {
            return;
        }
        ChangelogFormatter fmt = ChangelogFormatter.getInstance();
        for (Changelog changelog : changelogs) {
            StringBuilder msg = new StringBuilder();
            msg.append(pkeyAsString);
            msg.append("|");
            msg.append(fmt.format(changelog));
            logger.info(this.getLogHeader(p, msg.toString()));
        }
        p.request.setAttribute("__jfc_changelog", (Object)changelogs);
    }

    protected String getHttpSessionKey4TextSearch(ActionParameter p) {
        return TextsearchUtil.getHttpSessionKey4TextSearch(this.getMainModelId(), p);
    }

    protected Map<String, Object> getTextsearchReasultMap(ActionParameter p) {
        if (p.appMap == null) {
            return null;
        }
        return (Map)p.appMap.get(this.getHttpSessionKey4TextSearch(p));
    }

    protected Map<String, String>[] getTextsearchResult(ActionParameter p) {
        if (p.appMap == null) {
            return null;
        }
        Map<String, Object> rmap = this.getTextsearchReasultMap(p);
        return rmap != null ? (Map[])rmap.get("TEXTSEARCH_RESULT") : null;
    }

    protected void resetTextsearchResult(ActionParameter p) {
        if (p.appMap == null) {
            return;
        }
        String key = this.getHttpSessionKey4TextSearch(p);
        if (p.appMap.containsKey(key)) {
            p.appMap.remove(key);
        }
    }

    protected void prepareTextsearchResult(ActionParameter p) throws IOException, ServletException {
        Map rmap;
        if (p.request != null && p.appMap != null && (rmap = (Map)p.appMap.get(this.getHttpSessionKey4TextSearch(p))) != null) {
            for (String key : new String[]{"TEXTSEARCH_RESULT", "TEXTSEARCH_RESULT_SIZE", "TEXTSEARCH_HIGHLIGHT_WORDS", "TEXTSEARCH_TITLE_ITEMS", "TEXTSEARCH_CURRENT", "TEXTSEARCH_QMODE"}) {
                if (!rmap.containsKey(key)) continue;
                p.request.setAttribute(key, rmap.get(key));
            }
        }
    }

    protected void preprocessTextSearch(ActionParameter p) {
        String s;
        if (p.request != null && StringUtils.isNotBlank((String)(s = p.request.getParameter("TEXTSEARCH_CURRENT")))) {
            p.request.setAttribute("TEXTSEARCH_CURRENT", (Object)s);
        }
        if (p.request != null && p.appMap != null) {
            HashMap<String, Object> rmap = (HashMap<String, Object>)p.appMap.get(this.getHttpSessionKey4TextSearch(p));
            if (rmap == null) {
                rmap = new HashMap<String, Object>();
                p.appMap.put(this.getHttpSessionKey4TextSearch(p), rmap);
            }
            if (p.request.getParameter("TEXTSEARCH_SUGGEST_METHOD") == null) {
                for (String s2 : new String[]{"TEXTSEARCH_CURRENT", "TEXTSEARCH_QMODE"}) {
                    if (p.request.getParameter(s2) != null) {
                        rmap.put(s2, p.request.getParameter(s2));
                        continue;
                    }
                    if (p.request.getAttribute(s2) == null) continue;
                    rmap.put(s2, p.request.getAttribute(s2));
                }
            }
        }
    }

    protected String getLatestPankuzu(ActionParameter p) {
        String raction = "";
        PankuzuManager pkman = (PankuzuManager)this.getApplicationContext().getBean(PankuzuManager.class);
        Pankuzu pankuzu = pkman.getPankuzu();
        int size = pankuzu.sizeItem();
        for (int i = size - 1; i >= 0; --i) {
            jp.jasminesoft.jfc.model.pankuzu.Item item = pankuzu.getItem(i);
            String url = item.getUrl();
            if (StringUtils.isBlank((String)url)) continue;
            String querystr = item.getQuerystring();
            if (url.startsWith("show") && !url.startsWith("showList") && StringUtils.isBlank((String)querystr)) continue;
            if (StringUtils.isNotBlank((String)querystr) && querystr.startsWith("?")) {
                querystr = querystr.substring(1);
            }
            if (StringUtils.isNotBlank((String)querystr)) {
                String[] tokens;
                StringBuilder nqs = new StringBuilder();
                for (String token : tokens = querystr.split("&")) {
                    int ptr = token.indexOf("=");
                    if (ptr <= 0) continue;
                    String key = token.substring(0, ptr);
                    String value = token.substring(ptr + 1);
                    if (key.startsWith("action%5f")) {
                        String rest = key.substring("action%5f".length());
                        key = "action_" + rest;
                    }
                    nqs.append(key).append("=").append(value).append("&");
                }
                querystr = nqs.toString();
                if (querystr.endsWith("&")) {
                    querystr = querystr.substring(0, querystr.length() - 1);
                }
            }
            raction = url + (StringUtils.isNotBlank((String)querystr) ? "?" + querystr : "");
            break;
        }
        return raction;
    }

    protected String getPreviousShowActionForwardWithPkey(ActionParameter p, String ... pkeyNames) {
        String[] params;
        int ptr;
        String _forward = this.getPreviousShowActionForward(p);
        int n = ptr = _forward != null ? _forward.indexOf("?") : -1;
        if (ptr < 0) {
            return _forward;
        }
        String beforepart = _forward.substring(0, ptr);
        String parampart = _forward.substring(ptr + 1);
        String mid = new String(beforepart);
        if (mid.endsWith(".do")) {
            mid = mid.substring(0, mid.length() - ".do".length());
        }
        if (mid.startsWith("redirect:")) {
            mid = mid.substring("redirect:".length());
        } else if (mid.startsWith("forward:")) {
            mid = mid.substring("forward:".length());
        }
        if (mid.startsWith("showList")) {
            mid = mid.substring("showList".length());
        } else if (mid.startsWith("show")) {
            mid = mid.substring("show".length());
        }
        String me = null;
        String __jfc_screen_type = (String)p.request.getAttribute("__jfc_screen_type");
        String __jfc_screen_nid = (String)p.request.getAttribute("__jfc_screen_nid");
        if (__jfc_screen_type != null && __jfc_screen_nid != null) {
            me = __jfc_screen_nid.substring(__jfc_screen_type.length());
        }
        if (me != null && mid != null && !me.toLowerCase().equals(mid.toLowerCase())) {
            return _forward;
        }
        StringBuilder sb = new StringBuilder();
        for (String param : params = parampart.split("&")) {
            String key = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1);
            if (key.equals("action_ShowNext") || key.equals("action_ShowPrev")) continue;
            String key4match = key.indexOf("%") >= 0 ? StringUtil.replaceAll((String)key, (String)"%5f", (String)"_") : key;
            for (String pkeyName : pkeyNames) {
                Object v;
                if (!key4match.equals(pkeyName) || (v = p.request.getAttribute(pkeyName)) == null) continue;
                try {
                    value = WebStringEncodeUtilities.encodeString((String)v.toString(), (String)"utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = v.toString();
                    logger.warn("parameter encode error, name=" + key + ",value=" + value);
                }
                break;
            }
            sb.append(key).append("=").append(value).append("&");
        }
        _forward = beforepart + "?" + sb.toString();
        if (_forward.endsWith("&")) {
            _forward = _forward.substring(0, _forward.length() - 1);
        }
        return _forward;
    }

    protected String getPreviousShowActionForward(ActionParameter p) {
        return this.getPreviousActionForward(p, new URLMatchPattern(){

            @Override
            public boolean isMatch(String url, String querystr) {
                return url.startsWith("show") && !url.startsWith("showList");
            }
        });
    }

    protected String getPreviousShowActionForward(final String modelId, ActionParameter p) {
        p.request.setAttribute("__jfc_insertcancel_forward2menu", (Object)Boolean.TRUE);
        return this.getPreviousActionForward(p, new URLMatchPattern(){

            @Override
            public boolean isMatch(String url, String querystr) {
                return url.startsWith("showList" + StringUtil.capFirst((String)modelId)) || url.startsWith("show");
            }
        });
    }

    protected String getPreviousShowOrShowListActionForwardExceptModel(final String[] modelIds, ActionParameter p) {
        String s = this.getPreviousActionForward(p, new URLMatchPattern(){

            @Override
            public boolean isMatch(String url, String querystr) {
                boolean b = true;
                for (String modelId : modelIds) {
                    if (!(b &= (url.startsWith("show") && !url.startsWith("show" + StringUtil.capFirst((String)modelId)) || url.startsWith("showList" + StringUtil.capFirst((String)modelId))) && StringUtils.isNotBlank((String)querystr))) break;
                }
                return b;
            }
        });
        if (s != null && s.startsWith("redirect:showList")) {
            String me = modelIds[0];
            String s1 = s.substring("redirect:showList".length());
            int ptr = s1.indexOf(".do");
            if (ptr > 0 && (s1 = s1.substring(0, ptr)).equals(StringUtil.capFirst((String)me))) {
                s = null;
            }
        }
        return s;
    }

    private String getPreviousActionForward(ActionParameter p, URLMatchPattern pattern) {
        PankuzuManager pkman = (PankuzuManager)this.getApplicationContext().getBean(PankuzuManager.class);
        Pankuzu pankuzu = pkman.getPankuzu();
        int size = pankuzu.sizeItem();
        for (int i = size - 1; i >= 0; --i) {
            jp.jasminesoft.jfc.model.pankuzu.Item item = pankuzu.getItem(i);
            String url = item.getUrl();
            if (StringUtils.isBlank((String)url)) continue;
            String querystr = item.getQuerystring();
            if (pattern.isMatch(url, querystr)) {
                if (url.startsWith("show") && !url.startsWith("showList") && StringUtils.isBlank((String)querystr)) continue;
                if (StringUtils.isNotBlank((String)querystr) && querystr.startsWith("?")) {
                    querystr = querystr.substring(1);
                }
                if (StringUtils.isNotBlank((String)querystr)) {
                    String[] tokens;
                    StringBuilder nqs = new StringBuilder();
                    for (String token : tokens = querystr.split("&")) {
                        int ptr = token.indexOf("=");
                        if (ptr <= 0) continue;
                        String key = token.substring(0, ptr);
                        String value = token.substring(ptr + 1);
                        if (key.startsWith("action%5f")) {
                            String rest = key.substring("action%5f".length());
                            key = "action_" + rest;
                        }
                        p.redirectMap.put(key, value);
                        nqs.append(key).append("=").append(value).append("&");
                    }
                    querystr = nqs.toString();
                    if (querystr.endsWith("&")) {
                        querystr = querystr.substring(0, querystr.length() - 1);
                    }
                }
                String _forward = "redirect:" + url + (StringUtils.isNotBlank((String)querystr) ? "?" + querystr : "");
                return _forward;
            }
            if (i != 0 || !url.startsWith("mainMenu.do") || p.request.getAttribute("__jfc_insertcancel_forward2menu") == null) continue;
            p.request.removeAttribute("__jfc_insertcancel_forward2menu");
            if (DbBaseController.isMobile(p)) {
                return "redirect:mobileMenu.do";
            }
            return "redirect:mainMenu.do";
        }
        return null;
    }

    protected String takeOverHiddenParameter(String redirect, ActionParameter p) {
        StringBuilder sb = null;
        Enumeration em = p.request.getParameterNames();
        block2: while (em.hasMoreElements()) {
            String _name = (String)em.nextElement();
            if (_name.equals("sessionId")) continue;
            String _value = p.request.getParameter(_name);
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (_name.startsWith("action_") && _name.indexOf(":") > 0) {
                int count = 0;
                String action_param = null;
                String action_value = null;
                StringTokenizer st = new StringTokenizer(_name, ":");
                while (st.hasMoreTokens()) {
                    String addparam;
                    String token = st.nextToken();
                    if (++count < 2) continue;
                    if (count % 2 == 0) {
                        action_param = token;
                    } else {
                        action_value = token;
                    }
                    if (action_param == null || action_value == null || !StringUtils.isNotBlank((String)(addparam = JFCUtils.createHTTPGetParameterForPrimaryKey(action_param, action_value)))) continue;
                    sb.append("&").append(addparam);
                    continue block2;
                }
                continue;
            }
            try {
                sb.append("&").append(_name);
                sb.append("=").append(WebStringEncodeUtilities.encodeString((String)_value, (String)"utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("parameter encode error, name=" + _name + ",value=" + _value);
            }
        }
        if (sb != null) {
            redirect = sb.insert(0, redirect).toString();
        }
        return redirect;
    }

    public String convertErrorMessage(Exception e) {
        return this.convertErrorMessage(e, null);
    }

    public String convertErrorMessage(Exception e, String[][] params) {
        ActionParameter p = ((ActionParameterContainer)this.getApplicationContext().getBean("ActionParameterContainer")).get();
        String locale = null;
        if (p != null) {
            locale = p.locale;
        }
        return DbBaseController.convertErrorMessage(e, params, locale);
    }

    public static String convertErrorMessage(Exception e, String[][] params, String locale) {
        JFCErrorMessageConverter errconv = JFCErrorMessageConverter.getInstance();
        if (errconv != null) {
            String errormsg = errconv.get(e, params, locale);
            if (errormsg == null || errormsg.length() == 0) {
                return EMPTY_ERROR_MESSAGE;
            }
            return errormsg;
        }
        return EMPTY_ERROR_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPreserveInitValue(ActionParameter p) {
        Map<String, Object> map = p.appMap;
        synchronized (map) {
            for (String key : new HashSet<String>(p.appMap.keySet())) {
                if (!key.endsWith("_preserve_init")) continue;
                p.appMap.remove(key);
            }
        }
    }

    public void remakeParameterMap(Map _map, Map _typemap, ActionParameter p) {
        p.request.setAttribute("REPLACEMAP", (Object)_map);
        p.request.setAttribute("REPLACETYPEMAP", (Object)_typemap);
        String status = new ScriptCodeRunner(this.getModelId()).process("ReplaceMapHelper", "remake", p);
        if (StringUtils.isNotBlank((String)status)) {
            throw new BusinessLogicException(status);
        }
    }

    public void callScriptUpdateTransactionStart(ActionParameter p, TransactionStatus status) {
        this.callScriptUpdateTransaction(p, status, "preprocess");
    }

    public void callScriptUpdateTransactionEnd(ActionParameter p, TransactionStatus status) {
        this.callScriptUpdateTransaction(p, status, null);
    }

    public void callScriptUpdateTransaction(ActionParameter p, TransactionStatus status, String func) {
        p.request.setAttribute("TransactionStatus", (Object)status);
        String statusPart = ScriptCodeRunner4Controller.getScriptFilenameStatusPart(this.getStatus(), p);
        if (StringUtils.isBlank((String)statusPart)) {
            logger.warn("Controller status " + this.getStatus() + " is illegal for script filename.");
            return;
        }
        String action = "updateTransaction";
        ScriptCodeRunner runner = new ScriptCodeRunner(this.getModelId());
        String errstatus = func == null ? runner.process(statusPart, "updateTransaction", p) : runner.process(statusPart, "updateTransaction", func, p);
        if (StringUtils.isNotBlank((String)errstatus)) {
            throw new BusinessLogicException(errstatus);
        }
    }

    public boolean getUseConditionSetting(ActionParameter p) {
        return false;
    }

    public String getConditionSettingActionstrHeader() {
        return null;
    }

    protected Class<? extends Object> getConditionPModelClass() {
        return null;
    }

    public String getConditionname(ActionParameter p) {
        if (!this.getUseConditionSetting(p)) {
            return null;
        }
        String condname = p.request.getParameter(CONDITION_NAME_PARAM);
        if (StringUtils.isBlank((String)condname)) {
            return null;
        }
        condname = new StringConvKigouZ2HFilter().filter(condname);
        return condname;
    }

    public String getConditionnameAfterProcessing(ActionParameter p) {
        if (!this.getUseConditionSetting(p)) {
            return null;
        }
        String actionstrheader = this.getConditionSettingActionstrHeader();
        if (actionstrheader == null) {
            logger.error("Illegal get condition setting actionstr header " + this.getClass());
            return null;
        }
        if (p.action.startsWith(actionstrheader + LoadConditionSettingActionStr) || p.action.startsWith(actionstrheader + SaveConditionSettingActionStr)) {
            return this.getConditionname(p);
        }
        return null;
    }

    public Object loadConditionSetting(ActionParameter p, String cond_id) {
        if (!this.getUseConditionSetting(p)) {
            return null;
        }
        String actionstrheader = this.getConditionSettingActionstrHeader();
        if (actionstrheader == null) {
            logger.error("Illegal get condition setting actionstr header " + this.getClass());
            return null;
        }
        Class<Object> condclass = this.getConditionPModelClass();
        if (condclass == null) {
            logger.error("Illegal get condition p class in " + this.getClass());
            return null;
        }
        logger.debug("p.action = " + p.action);
        if (p.action == null) {
            return null;
        }
        String condname = this.getConditionname(p);
        if (condname == null) {
            return null;
        }
        if (p.action.startsWith(actionstrheader + LoadConditionSettingActionStr)) {
            String value = null;
            if (condname.startsWith("*")) {
                String condname1 = condname.substring(1);
                String key = COMMON_CONDITION_ATTR_HEADER + cond_id;
                JfccspreferenceitemManager man = (JfccspreferenceitemManager)p.appctx.getBean(JfccspreferenceitemManager.class);
                IJfccspreferenceitem item = man.findById(p, key, condname1);
                value = item.getContent();
            } else {
                String key = USER_CONDITION_ATTR_HEADER + cond_id + "$" + condname;
                Item valueitem = p.user.getPreferenceItem(key);
                if (valueitem != null) {
                    value = valueitem.getContent();
                }
            }
            if (value != null) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    Object cond_p = mapper.readValue(value, condclass);
                    p.request.setAttribute("cond_p", cond_p);
                    p.request.setAttribute("condname", (Object)this.getConditionname(p));
                    String statusPart = "ShowList" + StringUtil.capFirst((String)this.getModelId());
                    String action = LoadConditionSettingActionStr;
                    ScriptCodeRunner runner = new ScriptCodeRunner(this.getModelId());
                    String errstatus = runner.process(statusPart, LoadConditionSettingActionStr, p);
                    if (StringUtils.isNotBlank((String)errstatus)) {
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.DbBaseController.ConditionSetting.load", new Object[]{condname}, p.locale));
                        return null;
                    }
                    logger.debug("cond_p=" + cond_p);
                    p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.DbBaseController.ConditionSetting.load", new Object[]{condname}, p.locale));
                    return cond_p;
                }
                catch (UnrecognizedPropertyException e) {
                    logger.error("unrecognized property error", (Throwable)e);
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.DbBaseController.ConditionSetting.load.UnrecognizedProperty", new Object[]{condname}, p.locale));
                    return null;
                }
                catch (JsonParseException e) {
                    logger.error("json parse error", (Throwable)e);
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.DbBaseController.ConditionSetting.load", new Object[]{condname}, p.locale));
                    return null;
                }
                catch (JsonMappingException e) {
                    logger.error("json mapping error", (Throwable)e);
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.DbBaseController.ConditionSetting.load", new Object[]{condname}, p.locale));
                    return null;
                }
                catch (IOException e) {
                    logger.error("io error", (Throwable)e);
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.DbBaseController.ConditionSetting.load", new Object[]{condname}, p.locale));
                    return null;
                }
            }
        } else if (p.action.startsWith(actionstrheader + DeleteConditionSettingActionStr)) {
            if (condname.startsWith("*")) {
                String condname1 = condname.substring(1);
                String key = COMMON_CONDITION_ATTR_HEADER + cond_id;
                JfccspreferenceitemManager man = (JfccspreferenceitemManager)p.appctx.getBean(JfccspreferenceitemManager.class);
                man.delete(p, key, condname1);
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.DbBaseController.ConditionSetting.delete", new Object[]{condname}, p.locale));
            } else {
                String key = USER_CONDITION_ATTR_HEADER + cond_id + "$" + condname;
                Item valueitem = p.user.getPreferenceItem(key);
                if (valueitem != null) {
                    p.user.removePreferenceItem(valueitem);
                    p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.DbBaseController.ConditionSetting.delete", new Object[]{condname}, p.locale));
                }
            }
        }
        return null;
    }

    public void saveConditionSetting(ActionParameter p, Object cond_p, String cond_id) {
        if (!this.getUseConditionSetting(p)) {
            return;
        }
        String actionstrheader = this.getConditionSettingActionstrHeader();
        if (actionstrheader == null) {
            logger.error("Illegal get condition setting actionstr header " + this.getClass());
            return;
        }
        logger.debug("p.action = " + p.action);
        logger.debug("cond_p = " + cond_p);
        logger.debug("cond_id = " + cond_id);
        String condname = this.getConditionname(p);
        if (condname == null) {
            return;
        }
        if (p.action != null && p.action.startsWith(actionstrheader + SaveConditionSettingActionStr)) {
            String value;
            ObjectMapper mapper = new ObjectMapper();
            try {
                value = mapper.writeValueAsString(cond_p);
            }
            catch (JsonProcessingException e) {
                logger.error("json processing error", (Throwable)e);
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.DbBaseController.ConditionSetting.save", new Object[]{condname}, p.locale));
                return;
            }
            if (condname.startsWith("*")) {
                String condname1 = condname.substring(1);
                String key = COMMON_CONDITION_ATTR_HEADER + cond_id;
                JfccspreferenceitemManager man = (JfccspreferenceitemManager)p.appctx.getBean(JfccspreferenceitemManager.class);
                man.save(p, key, condname1, value);
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.DbBaseController.ConditionSetting.save", new Object[]{condname}, p.locale));
            } else {
                String key = USER_CONDITION_ATTR_HEADER + cond_id + "$" + condname;
                p.user.setPreferenceItem(key, value, "jfcpreferenceitem");
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.DbBaseController.ConditionSetting.save", new Object[]{condname}, p.locale));
            }
        }
    }

    public ConditionSetting getConditionSetting(ActionParameter p, String cond_id) {
        boolean bl;
        String key;
        TreeSet<ConditionSettingItem> list1 = new TreeSet<ConditionSettingItem>();
        ConditionSettingItem map = null;
        String keyheader = USER_CONDITION_ATTR_HEADER + cond_id + "$";
        Item[] items = p.user.getPreference().getItem();
        for (int i = 0; i < items.length; ++i) {
            key = items[i].getKey();
            if (!key.startsWith(keyheader)) continue;
            String condname = key.substring(keyheader.length());
            map = new ConditionSettingItem(condname, condname);
            list1.add(map);
        }
        TreeSet<ConditionSettingItem> list2 = new TreeSet<ConditionSettingItem>();
        key = COMMON_CONDITION_ATTR_HEADER + cond_id;
        JfccspreferenceitemManager man = (JfccspreferenceitemManager)p.appctx.getBean(JfccspreferenceitemManager.class);
        List<? extends IJfccspreferenceitem> csitems = man.find(p, key, cond_id);
        for (IJfccspreferenceitem iJfccspreferenceitem : csitems) {
            String condname = iJfccspreferenceitem.getCsname();
            String key1 = "*" + condname;
            map = new ConditionSettingItem(key1, key1);
            list2.add(map);
        }
        ArrayList<ConditionSettingItem> list = new ArrayList<ConditionSettingItem>();
        list.addAll(list1);
        list.addAll(list2);
        logger.debug("list = " + list);
        boolean bl2 = false;
        CheckPermission checkperm = CheckPermissionFactory.getCheckPermission();
        JFCAppPermission perm = new JFCAppPermission("jfccspreferenceitem", "conditionsetting_update");
        if (checkperm.process(p.user, perm)) {
            bl = true;
        }
        return new ConditionSetting(list, bl);
    }

    public void setConditionSettingRequestAttribute(ActionParameter p, String cond_id) {
        if (!this.getUseConditionSetting(p)) {
            return;
        }
        String actionstrheader = this.getConditionSettingActionstrHeader();
        if (actionstrheader == null) {
            logger.error("Illegal get condition setting actionstr header " + this.getClass());
            return;
        }
        ConditionSetting cs = this.getConditionSetting(p, cond_id);
        cs.conditionname = this.getConditionnameAfterProcessing(p);
        cs.actionstr = "action_" + actionstrheader;
        p.request.setAttribute("jfcConditionSetting", (Object)cs);
        ObjectMapper mapper = new ObjectMapper();
        try {
            String value = mapper.writeValueAsString((Object)cs);
            p.request.setAttribute("jfcConditionSettingStr", (Object)value);
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static class ConditionSettingItem
    implements Comparable<ConditionSettingItem> {
        private String id;
        private String name;

        public ConditionSettingItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(ConditionSettingItem o) {
            return this.id.compareTo(o.id);
        }
    }

    public static class ConditionSetting {
        protected String conditionname;
        protected String actionstr;
        private boolean editableCommonSetting = false;
        private Map<String, Object> comboboxStore = new HashMap<String, Object>();

        public ConditionSetting(List<ConditionSettingItem> items, boolean editableCommonSetting) {
            this.comboboxStore.put("data", items);
            this.editableCommonSetting = editableCommonSetting;
        }

        public String getConditionname() {
            return this.conditionname;
        }

        public String getActionstr() {
            return this.actionstr;
        }

        public boolean isEditableCommonSetting() {
            return this.editableCommonSetting;
        }

        public Map<String, Object> getComboboxStore() {
            return this.comboboxStore;
        }
    }

    private static interface URLMatchPattern {
        public boolean isMatch(String var1, String var2);
    }
}

