/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.controller.SortKeyHolder;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbCursorBaseController<E extends ContainerBase<E>, PK extends Serializable>
extends DbBaseController<E> {
    private static final Logger logger = LogManager.getLogger(DbCursorBaseController.class);
    private JFCEntityService<E, PK> service;
    private final String RESULT_STATUS_REDIRECTMAP_KEY = this.getClass().getName() + "_resultStatus";

    public void setEntityService(JFCEntityService<E, PK> service1) {
        this.service = service1;
    }

    public JFCEntityService<E, PK> getEntityService() {
        return this.service;
    }

    protected List<FinderContext<?>> getFinderContexts() {
        return Collections.emptyList();
    }

    protected FinderContext<?> getFinderContext() {
        List<FinderContext<?>> finderContexts = this.getFinderContexts();
        FinderContext<?> finderContext = null;
        for (FinderContext<?> fc : finderContexts) {
            if (!fc.isProcess()) continue;
            finderContext = fc;
            break;
        }
        return finderContext;
    }

    protected E getEntityInFinderContext(ActionParameter p, String pkey, PositionType postype) {
        return this.getEntityInFinderContext(p, pkey, postype, false);
    }

    protected E getEntityInFinderContextAtUpdate(ActionParameter p, String pkey, PositionType postype) {
        return this.getEntityInFinderContext(p, pkey, postype, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private E getEntityInFinderContext(ActionParameter p, String pkey, PositionType postype, boolean isUpdate) {
        List<PK> coll;
        String sort_key;
        SortKeyHolder sortKeyHolder;
        boolean isShowPrevButton = false;
        boolean isShowNextButton = false;
        int moveresultnum = 0;
        FinderContext<?> finderContext = this.getFinderContext();
        if (finderContext == null || finderContext.getCondition() == null) {
            p.logger.debug("ResultBean not found");
            this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
            return null;
        }
        if (isUpdate) {
            int firstResult = finderContext.getFirstResult();
            finderContext.reset();
            finderContext.setFirstResult(firstResult);
        }
        if ((sortKeyHolder = this.getShowListController(p)) != null && (sort_key = sortKeyHolder.getSortKey(p)) != null) {
            p.request.setAttribute("__jfc_sortkey", (Object)sort_key);
        }
        if ((coll = this.service.findKeys(finderContext, true)) == null || coll.size() == 0) {
            p.logger.debug("CurrentPageItem is null or empty");
            this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
            return null;
        }
        int num = 0;
        Iterator<PK> it = coll.iterator();
        Serializable ret = null;
        Serializable prevobj = null;
        Serializable nowobj = null;
        while (it.hasNext()) {
            Serializable obj = (Serializable)it.next();
            String id = PrimaryKeyUtils.toString(obj);
            if (pkey.equals(id)) {
                nowobj = obj;
                break;
            }
            prevobj = obj;
            ++num;
        }
        int cur = finderContext.getFirstResult() + 1;
        if (nowobj == null) {
            boolean isFind = false;
            if (postype == PositionType.Prev || postype == PositionType.Next) {
                int beforemoveresultnum = (Integer)p.appMap.get("moveresultnum");
                num = 0;
                it = coll.iterator();
                prevobj = null;
                if (cur == beforemoveresultnum) {
                    isFind = true;
                    if (postype == PositionType.Next) {
                        --num;
                    }
                }
                while (!isFind && it.hasNext()) {
                    Serializable obj;
                    prevobj = obj = (Serializable)it.next();
                    if (cur + num + 1 == beforemoveresultnum) {
                        isFind = true;
                        if (postype != PositionType.Prev) break;
                        ++num;
                        break;
                    }
                    ++num;
                }
            }
            if (!isFind) {
                p.logger.debug("No object is found in CurrentPageItem");
                this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
                return null;
            }
        }
        boolean isNowShowPrevButton = false;
        boolean isNowShowNextButton = false;
        int nowmoveresultnum = cur + num;
        if (nowmoveresultnum > 1) {
            isNowShowPrevButton = true;
        }
        if (nowmoveresultnum < finderContext.getRowCount()) {
            isNowShowNextButton = true;
        }
        if (postype == PositionType.Prev) {
            if (prevobj != null) {
                ret = prevobj;
                --num;
            } else {
                if (!isNowShowPrevButton) {
                    p.logger.debug("postype is PositionType_Prev, but isNowShowPrevButton is false");
                    this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
                    return this.service.findById(ret);
                }
                p.logger.debug("go prev page");
                finderContext.prev();
                coll = this.service.findKeys(finderContext);
                if (coll == null || coll.size() == 0) {
                    p.logger.debug("prev CurrentPageItem is null or empty");
                    this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
                    return null;
                }
                ret = (Serializable)coll.get(coll.size() - 1);
                --num;
            }
        } else if (postype == PositionType.Next) {
            if (it.hasNext()) {
                ret = (Serializable)it.next();
                ++num;
            } else {
                if (!isNowShowNextButton) {
                    p.logger.debug("postype is PositionType_Next, but isNowShowNextButton is false");
                    this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
                    return this.service.findById(ret);
                }
                p.logger.debug("go next page");
                finderContext.next();
                coll = this.service.findKeys(finderContext);
                if (coll == null || coll.size() == 0) {
                    p.logger.debug("next CurrentPageItem is null or empty");
                    this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
                    return null;
                }
                ret = (Serializable)coll.get(0);
                ++num;
            }
        } else {
            ret = nowobj;
        }
        moveresultnum = cur + num;
        if (moveresultnum > 1) {
            isShowPrevButton = true;
        }
        if (moveresultnum < finderContext.getRowCount()) {
            isShowNextButton = true;
        }
        p.logger.debug("find object in CurrentPageItem, " + moveresultnum);
        this.setResultStatus(p, isShowPrevButton, isShowNextButton, moveresultnum, finderContext);
        return this.service.findById(ret);
    }

    protected String getShowListControllerAppctxName() {
        return "showList" + StringUtil.capFirst((String)this.getModelId()) + "Controller";
    }

    protected SortKeyHolder getShowListController(ActionParameter p) {
        String showListControllerAppctxName = this.getShowListControllerAppctxName();
        return (SortKeyHolder)p.appctx.getBean(showListControllerAppctxName, SortKeyHolder.class);
    }

    protected String getPrimaryKeyAsString(E entity, ActionParameter p) {
        return null;
    }

    private void setResultStatus(ActionParameter p, boolean isShowPrevButton, boolean isShowNextButton, int moveresultnum, FinderContext<?> finderContext) {
        p.appMap.put("isShowPrevButton", isShowPrevButton);
        p.appMap.put("isShowNextButton", isShowNextButton);
        p.appMap.put("moveresultnum", moveresultnum);
        this.setResultStatus(p, finderContext);
    }

    protected void setResultStatus(ActionParameter p) {
        FinderContext<?> finderContext = this.getFinderContext();
        if (finderContext == null) {
            p.logger.debug("ResultBean not found");
        }
        this.setResultStatus(p, finderContext);
    }

    protected void setResultStatus(ActionParameter p, FinderContext<?> finderContext) {
        p.request.setAttribute("isShowPrevButton", p.appMap.get("isShowPrevButton"));
        p.request.setAttribute("isShowNextButton", p.appMap.get("isShowNextButton"));
        p.request.setAttribute("moveresultnum", p.appMap.get("moveresultnum"));
        if (finderContext != null) {
            p.request.setAttribute("jfc_result", (Object)new FinderContextResultBeanWrapper(finderContext));
        }
    }

    protected void setResultStatusToRedirectMap(ActionParameter p) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isShowPrevButton", p.request.getAttribute("isShowPrevButton"));
        map.put("isShowNextButton", p.request.getAttribute("isShowNextButton"));
        map.put("moveresultnum", p.request.getAttribute("moveresultnum"));
        p.redirectMap.put(this.RESULT_STATUS_REDIRECTMAP_KEY, map);
        logger.debug("return");
    }

    protected boolean restoreResultStatusFromRedirectMap(ActionParameter p) {
        Map map = (Map)p.request.getAttribute(this.RESULT_STATUS_REDIRECTMAP_KEY);
        if (map == null) {
            logger.debug("return false");
            return false;
        }
        p.request.setAttribute("isShowPrevButton", map.get("isShowPrevButton"));
        p.request.setAttribute("isShowNextButton", map.get("isShowNextButton"));
        p.request.setAttribute("moveresultnum", map.get("moveresultnum"));
        FinderContext<?> finderContext = this.getFinderContext();
        p.request.setAttribute("jfc_result", (Object)new FinderContextResultBeanWrapper(finderContext));
        logger.debug("return true");
        return true;
    }

    protected static enum PositionType {
        Current,
        Prev,
        Next;

    }
}

