/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.DbDeleteBaseController;
import jp.jasminesoft.jfc.controller.RetrieveDataSource;
import jp.jasminesoft.jfc.controller.RetrieveDataUtil;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;

public abstract class DbDeleteController<E extends ContainerBase<E>, PK extends Serializable>
extends DbDeleteBaseController<E>
implements RetrieveDataSource<E> {
    private JFCEntityService<E, PK> entityService;
    private EntityHelper<E, PK> entityHelper;
    private static final Logger logger = LogManager.getLogger(DbDeleteController.class);

    public void setEntityService(JFCEntityService<E, PK> service1) {
        this.entityService = service1;
    }

    public JFCEntityService<E, PK> getEntityService() {
        return this.entityService;
    }

    public void setEntityHelper(EntityHelper<E, PK> helper) {
        this.entityHelper = helper;
    }

    public EntityHelper<E, PK> getEntityHelper() {
        return this.entityHelper;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_pankuzu.delete" + this.getModelIdDescriptionResourceKey();
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission(this.getModelIdPermission(), "delete");
    }

    @Override
    public abstract String getModelId();

    public RetrieveDataUtil<E> getRetrieveDataUtil() {
        RetrieveDataUtil util = new RetrieveDataUtil();
        util.setRetrieveDataSource(this);
        return util;
    }

    @Override
    public boolean isSubmenu(ActionParameter p) {
        return false;
    }

    public String getForwardName(String type) {
        if ("normal".equals(type)) {
            return this.getForwardHeader() + ".normal";
        }
        if ("error".equals(type)) {
            return this.getForwardHeader() + ".error";
        }
        if ("cancel".equals(type)) {
            return this.getForwardHeader() + ".cancel";
        }
        if ("lock_error".equals(type)) {
            return this.getForwardHeader() + ".lock_error";
        }
        return null;
    }

    @Override
    public Object retrieveData(ActionParameter p) {
        this.retrieveData_first_hook(p);
        Object ret = this.getRetrieveDataUtil().retrieveData(p);
        this.retrieveData_finish_hook(p);
        return ret;
    }

    @Override
    public String registLockModel(ActionParameter p) {
        this.registLockModel_first_hook(p);
        StringBuilder sb = new StringBuilder(this.getModelId());
        this.registLockModel_finish_hook(sb, p);
        return sb.toString();
    }

    @Override
    public Object registLockPrimaryKey(ActionParameter p) {
        this.registLockPrimaryKey_first_hook(p);
        Object ret = this.retrieveData(p);
        this.registLockPrimaryKey_finish_hook(ret, p);
        return ret;
    }

    @Override
    public String do_delete(ActionParameter p) throws IOException, ServletException {
        return this.getForwardName("normal");
    }

    protected boolean getLogicalDelete() {
        return false;
    }

    @Override
    public String do_lockerror(ActionParameter p) {
        return this.getForwardName("lock_error");
    }

    protected String getModelIdDescriptionResourceKey() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    protected String getModelIdPermission() {
        return this.getModelId();
    }

    protected String getModelIdPankuzu() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    protected String getTablenameDesc() {
        return "__jfc_tablename." + StringUtil.capFirst((String)this.getModelId()) + "ModelId";
    }

    protected PK getPrimarykey(String pkey, ActionParameter p) {
        return this.getEntityHelper().getPrimarykey(pkey);
    }

    @Override
    public abstract String[] getPrimaryKeyModelitemName();

    @Override
    public abstract String[] getPrimaryKeyRefName();

    protected abstract String[] getPrimaryKeyType();

    public ResponseEntity<Map<String, Object>> deleteRest(HttpServletRequest request, HttpServletResponse response, String pkey) throws IOException, ServletException {
        final String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
        if (pkey != null) {
            request.setAttribute("_" + pkeyname, (Object)pkey);
        }
        request.setAttribute("action", (Object)"Send");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new BaseController.CallRestListener(){

            @Override
            public ResponseEntity<Map<String, Object>> afterExecute(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
                map.put("pkey", request.getAttribute(pkeyname));
                return null;
            }
        });
    }
}

