/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.controller.GridSettingController;
import jp.jasminesoft.jfc.controller.GridSettingJsonContent;
import jp.jasminesoft.jfc.job.DownloadJob;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbDownloadBaseController<E>
extends DbBaseController<E> {
    private static final Logger logger = LogManager.getLogger((String)DbDownloadBaseController.class.getName());
    public static final String FileextParameterName = "jfc_fileext";
    public static final String OutputModeParameterName = "jfc_outputmode";
    private static final String CONDITION_SETTING_ACTIONSTR_HEADER = "Condition";

    @Override
    public String getScreenType() {
        return "download";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.referrer == null) {
            return CommandType.InputCondition;
        }
        if (p.action != null && p.action.startsWith("Reset")) {
            return CommandType.InputCondition;
        }
        if (p.action != null && p.action.startsWith(CONDITION_SETTING_ACTIONSTR_HEADER)) {
            return CommandType.InputCondition;
        }
        if (p.action != null && p.action.startsWith("Download")) {
            return CommandType.Download;
        }
        if (p.action != null && p.action.startsWith("Add")) {
            return CommandType.AddItem;
        }
        if (p.action != null && p.action.startsWith("Remove")) {
            return CommandType.RemoveItem;
        }
        if (p.action != null && p.action.startsWith("Zipcode")) {
            return CommandType.Zipcode;
        }
        if (p.action != null && p.action.startsWith("GetXml")) {
            return CommandType.GetXml;
        }
        if (p.action != null && p.action.startsWith("Refresh")) {
            return CommandType.Refresh;
        }
        return CommandType.None;
    }

    public File getFileObject(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        File file = new File(this.getJfcConfig().getDownloadDir(), filename);
        try {
            String filepath = file.getCanonicalPath();
            File downloaddir = new File(this.getJfcConfig().getDownloadDir());
            String downloaddirpath = downloaddir.getCanonicalPath();
            if (!downloaddirpath.endsWith(File.pathSeparator)) {
                downloaddirpath = downloaddirpath + File.pathSeparator;
            }
            if (!filepath.startsWith(downloaddirpath)) {
                return null;
            }
        }
        catch (IOException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00073), LogCodeManager.getMessage(LogCode.JFC00073, filename, e.getMessage()), (Throwable)e);
            return null;
        }
        if (JFCUtils.waitUntilCanRead(file)) {
            return file;
        }
        return null;
    }

    public String getSavefilename(File file, ActionParameter p) {
        if (file == null) {
            return null;
        }
        return WebStringEncodeUtilities.encodeAttachedFileName((String)file.getName(), (String)((String)p.request.getAttribute("__jfc_browser_type")));
    }

    public String getSavefilename(File file, String btype) {
        if (file == null) {
            return null;
        }
        return WebStringEncodeUtilities.encodeAttachedFileName((String)file.getName(), (String)btype);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String endLogMsg;
        String forward;
        block32: {
            forward = null;
            this.setCommandToActionParameter(p);
            String fileext = p.request.getParameter(FileextParameterName);
            if (StringUtils.isBlank((CharSequence)fileext)) {
                fileext = (String)p.appMap.get(FileextParameterName);
                if (StringUtils.isBlank((CharSequence)fileext)) {
                    fileext = "";
                }
            } else {
                p.appMap.put(FileextParameterName, fileext);
            }
            p.request.setAttribute(FileextParameterName, (Object)fileext);
            String outputmode = p.request.getParameter(OutputModeParameterName);
            if (StringUtils.isBlank((CharSequence)outputmode)) {
                outputmode = (String)p.appMap.get(OutputModeParameterName);
                if (StringUtils.isBlank((CharSequence)outputmode)) {
                    outputmode = "";
                }
            } else {
                p.appMap.put(OutputModeParameterName, outputmode);
            }
            p.request.setAttribute(OutputModeParameterName, (Object)outputmode);
            if (p.cmd == CommandType.UserDefined) {
                logger.info(this.getLogHeader(p, p.action));
                p.o = this.retrieveData(p);
                forward = this.do_original(p);
            } else if (p.cmd == CommandType.Masterref) {
                logger.info(this.getLogHeader(p));
                p.o = this.retrieveData(p);
                forward = this.do_masterref(p);
            } else if (p.cmd == CommandType.AddItem) {
                logger.info(this.getLogHeader(p));
                p.o = this.retrieveData(p);
                forward = this.do_addItem(p);
            } else if (p.cmd == CommandType.RemoveItem) {
                logger.info(this.getLogHeader(p));
                p.o = this.retrieveData(p);
                forward = this.do_removeItem(p);
            } else if (p.cmd == CommandType.Zipcode) {
                logger.info(this.getLogHeader(p));
                p.o = this.retrieveData(p);
                forward = this.do_zipCode(p);
            } else if (p.cmd == CommandType.InputCondition || p.cmd == CommandType.ChangeSidebar) {
                logger.info(this.getLogHeader(p));
                this.do_condition(p);
            } else {
                if (p.cmd == CommandType.Download) {
                    logger.info(this.getLogHeader(p));
                    try {
                        this.do_condition(p);
                        if (p.errors.sizeJfcerror() == 0) {
                            forward = this.do_downloadData(p);
                        }
                        if (p.errors.sizeJfcerror() == 0 && forward == null) {
                            p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
                            return null;
                        }
                        break block32;
                    }
                    catch (SecurityException e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                if (p.cmd == CommandType.GetXml) {
                    logger.info(this.getLogHeader(p));
                    forward = this.do_getxml(p);
                } else if (p.cmd == CommandType.Refresh) {
                    logger.info(this.getLogHeader(p));
                    this.do_refresh(p);
                } else {
                    logger.info(this.getLogHeader(p, p.action));
                    String forward1 = this.execExecuteMethod(p, null);
                    if (forward1 != null && forward1.equals("None")) {
                        this.do_default0(p);
                    } else {
                        forward = forward1;
                    }
                }
            }
        }
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (forward != null || isDeniedNullForward.booleanValue()) {
            this.setConditionSettingRequestAttribute(p);
        }
        if ((endLogMsg = this.endLog(p)) != null) {
            logger.info(endLogMsg);
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            logger.debug("forward is null.");
            return this.getInputForward(p);
        }
        return forward;
    }

    public void do_condition(ActionParameter p) throws IOException, ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String do_downloadData(ActionParameter p) throws IOException, ServletException {
        int len;
        File file = null;
        try {
            file = this.do_download(p);
        }
        catch (SecurityException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.download.nodata", p.locale));
        }
        if (!(file != null && file.exists() && file.canRead() && file.isFile())) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.download.nofile", p.locale));
            return null;
        }
        FileInputStream istream = null;
        byte[] b = new byte[1024];
        try {
            istream = new FileInputStream(file);
            len = ((InputStream)istream).read(b);
        }
        catch (IOException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00074), LogCodeManager.getMessage(LogCode.JFC00074, p.user, file.getName(), e.getMessage()), (Throwable)e);
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (IOException ie) {
                    logger.debug(this.getLogHeader(p) + "Failed to close file.", (Throwable)ie);
                }
            }
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.download.nofile", p.locale));
            return null;
        }
        OutputStream ostream = null;
        try {
            p.response.reset();
            logger.debug(this.getLogHeader(p) + "reset.");
            p.response.setContentType("application/octet-stream");
            p.response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)file.getName(), (HttpServletRequest)p.request));
            long filesize = file.length();
            p.response.setContentLength((int)filesize);
            ostream = p.response.getOutputStream();
            p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
            int total = 0;
            do {
                ostream.write(b, 0, len);
                total += len;
                if (!logger.isDebugEnabled()) continue;
                logger.debug(this.getLogHeader(p) + "send " + len + " bytes. total is " + total + "/" + filesize + " bytes.");
            } while ((len = ((InputStream)istream).read(b)) >= 0);
            ostream.flush();
            logger.debug(this.getLogHeader(p) + "flush.");
        }
        catch (IllegalStateException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00075), LogCodeManager.getMessage(LogCode.JFC00075, p.user, e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00076), LogCodeManager.getMessage(LogCode.JFC00076, p.user, e.getMessage()), (Throwable)e);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {
                    logger.debug(this.getLogHeader(p) + "Failed to close file.", (Throwable)e);
                }
            }
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (IOException e) {
                    logger.debug(this.getLogHeader(p) + "Failed to close file.", (Throwable)e);
                }
            }
            logger.debug(this.getLogHeader(p) + "closed");
        }
        return null;
    }

    public File do_download(ActionParameter p) throws IOException, ServletException {
        return null;
    }

    protected void do_default0(ActionParameter p) throws IOException, ServletException {
        this.do_default(p);
    }

    public String do_getxml(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_refresh(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public boolean isRecoverCondition(ActionParameter p) {
        return !"Download".equals(p.action);
    }

    public List<String> getGridSettingTargetitems(ActionParameter p, GridSettingJsonContent content) {
        List<String> defaultTargetitems = this.getDefaultGridSettingTargetitems(p);
        List<String> targetitems = null;
        if (content != null) {
            targetitems = content.getTargetitems();
        }
        if (targetitems == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("targetitems is null, return defaultTargetitems. content=" + content);
            }
            return defaultTargetitems;
        }
        HashSet<String> targetSet = new HashSet<String>(targetitems);
        targetSet.removeAll(defaultTargetitems);
        targetSet.removeIf(item -> StringUtils.startsWith((CharSequence)item, (CharSequence)"jfcButtonField"));
        if (targetSet.size() > 0) {
            logger.warn("Illegal gridsetting name. " + targetSet + ", content=" + content);
            return defaultTargetitems;
        }
        return targetitems;
    }

    public String[] getGridSettingSortkeys(ActionParameter p, GridSettingJsonContent content) {
        if (content == null) {
            return null;
        }
        return content.getSortkeys();
    }

    public GridSettingJsonContent getPreferenceGridSetting(ActionParameter p) {
        return DbDownloadBaseController.getPreferenceGridSetting(this.getModelId(), p);
    }

    public static GridSettingJsonContent getPreferenceGridSetting(String modelid, ActionParameter p) {
        String key = GridSettingController.getPreferenceitemKey(modelid);
        Item item = p.user.getPreferenceItem(key);
        String content = null;
        if (item != null && (content = item.getContent()) != null && (content.equals("") || content.equals("{}"))) {
            content = null;
        }
        if (content != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("preference " + key + " content = " + content);
            }
            ObjectMapper mapper = new ObjectMapper();
            try {
                return (GridSettingJsonContent)mapper.readValue(content, GridSettingJsonContent.class);
            }
            catch (IOException e) {
                logger.warn("Illegal gridsetting json. content=" + content);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("preference " + key + " is empty.");
        }
        return null;
    }

    public List<String> getDefaultGridSettingTargetitems(ActionParameter p) {
        throw new IllegalStateException();
    }

    public File getOutputfile(String outputfilename, String outputdir) throws IOException {
        return DownloadJob.getOutputfile(outputfilename, outputdir);
    }

    public String getOutputfilenametype(String outputfilename, String outputfilenametype) {
        return DownloadJob.getOutputfilenametype(outputfilename, outputfilenametype);
    }

    public File renameDownloadedLocalFile(ActionParameter p, File file, String outputfilenametype) {
        file = DownloadJob.renameDownloadedLocalFile(p, file, outputfilenametype);
        logger.info(JFCUtils.logmsg(p, "finished. outputfilename=" + file));
        return file;
    }

    protected void getCommand_first_hook(ActionParameter p) {
    }

    protected void getCommand_finish_hook(ActionParameter p) {
    }

    protected void retrieveData_first_hook(ActionParameter p) {
    }

    protected void retrieveData_finish_hook(ActionParameter p) {
    }

    protected void do_nodata_first_hook(ActionParameter p) {
    }

    protected void do_nodata_finish_hook(ActionParameter p) {
    }

    protected void do_preprocess_first_hook(ActionParameter p) {
    }

    protected void do_preprocess_finish_hook(ActionParameter p) {
    }

    protected void do_condition_first_hook(ActionParameter p) {
    }

    protected void do_condition_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_condition_before_setcondition_hook(ActionParameter p) {
    }

    protected void do_condition_after_setcondition_hook(ActionParameter p) {
    }

    protected void do_condition_finish_hook(ActionParameter p) {
    }

    protected void do_downloadData_first_hook(ActionParameter p) {
    }

    protected void do_downloadData_ready_pbean_hook(ActionParameter p) {
    }

    protected void do_downloadData_before_do_condition_hook(ActionParameter p) {
    }

    protected void do_downloadData_after_do_condition_hook(ActionParameter p) {
    }

    protected void do_downloadData_before_setparameter_hook(ActionParameter p) {
    }

    protected void do_downloadData_after_setparameter_hook(ActionParameter p) {
    }

    protected void do_downloadData_before_pbean_hook(ProcessBean pbean, ActionParameter p) {
    }

    protected void do_downloadData_after_pbean_hook(ActionParameter p) {
    }

    protected void do_downloadData_finish_pbean_hook(ActionParameter p) {
    }

    protected void do_downloadData_finish_hook(ActionParameter p) {
    }

    protected void do_zipCode_first_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_gettargetobj_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_filtering_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_filtering_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_p2s_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_calc_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_calc_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_inputcheck_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_inputcheck_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_s2p_helper_hook(ActionParameter p) {
    }

    protected void do_zipCode_before_zipsync_hook(ActionParameter p) {
    }

    protected void do_zipCode_after_zipsync_hook(ActionParameter p) {
    }

    protected void do_zipCode_finish_hook(ActionParameter p) {
    }

    protected String getConditionPRequestName() {
        return this.getModelId() + "_cp";
    }

    @Override
    public String getConditionSettingActionstrHeader() {
        return CONDITION_SETTING_ACTIONSTR_HEADER;
    }

    public Object loadConditionSetting(ActionParameter p) {
        return this.loadConditionSetting(p, this.getConditionPRequestName());
    }

    public void saveConditionSetting(ActionParameter p, Object cond_p) {
        this.saveConditionSetting(p, cond_p, this.getConditionPRequestName());
    }

    public DbBaseController.ConditionSetting getConditionSetting(ActionParameter p) {
        return this.getConditionSetting(p, this.getConditionPRequestName());
    }

    public void setConditionSettingRequestAttribute(ActionParameter p) {
        this.setConditionSettingRequestAttribute(p, this.getConditionPRequestName());
    }
}

