/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.DbMasterTable;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.MasterTable;
import jp.jasminesoft.jfc.app.MasterLHelper;
import jp.jasminesoft.jfc.app.MasterLpHelper;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.master.Master;
import jp.jasminesoft.jfc.model.master_l.MasterL;
import jp.jasminesoft.jfc.model.master_lp.Item;
import jp.jasminesoft.jfc.model.master_lp.MasterLp;
import jp.jasminesoft.util.StringFilter;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbMasterBaseController<E, EC>
extends DbBaseController<E> {
    public static final String masterMapPagemapName = "__jfc_masterMap";
    public static final String masterLPagemapName = "master_l";
    public static final String masterLpPagemapName = "master_lp";
    public static final String itemMapPagemapName = "__jfc_itemMap";
    public static final String newIdPagemapName = "__jfc_newId";
    private static final Logger logger = LogManager.getLogger((String)DbMasterBaseController.class.getName());

    public FinderContext<EC> getFinderContext() {
        throw new RuntimeException();
    }

    @Override
    public String getScreenType() {
        return "showListMaster";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    public StringFilter getStringFilter() {
        return null;
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.referrer == null) {
            return CommandType.Search;
        }
        if (p.action != null && p.action.startsWith("Next")) {
            return CommandType.Next;
        }
        if (p.action != null && p.action.startsWith("Prev")) {
            return CommandType.Prev;
        }
        if (p.action != null && p.action.startsWith("First")) {
            return CommandType.First;
        }
        if (p.action != null && p.action.startsWith("Last")) {
            return CommandType.Last;
        }
        if (p.action != null && p.action.startsWith("Update")) {
            return CommandType.DoUpdate;
        }
        return CommandType.None;
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String endLogMsg;
        String err_forward;
        String forward = null;
        String username = "";
        if (p.user != null) {
            username = p.user.getUsername();
        }
        FinderContext<EC> finderContext = this.getFinderContext();
        ActionParameter dp = p;
        this.setCommandToActionParameter(p);
        if (p.cmd == CommandType.UserDefined) {
            logger.info(this.getLogHeader(p, p.action));
            forward = this.do_original(dp);
        } else {
            if (p.cmd == CommandType.Forward) {
                DbMasterBaseController.setAttributeWithAction(p.action, p.request);
                String url = p.request.getParameter("forward");
                if (url == null || url.length() == 0) {
                    url = this.getForwardUrl(p.action);
                }
                logger.info(this.getLogHeader(p, url));
                return url;
            }
            if (p.cmd == CommandType.DoUpdate) {
                logger.info(this.getLogHeader(p));
                if (!super.isClientSessionIdValid(p)) {
                    if (this.isNewLogon(p.request)) {
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.session.expired.update", p.locale));
                        return "logon.afterLogon";
                    }
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00102), LogCodeManager.getMessage(LogCode.JFC00102, p.user, new String[0]));
                    finderContext.reset();
                    throw new SecurityException();
                }
                this.do_request(dp);
                this.do_update(dp);
                if (p.errors.sizeJfcerror() > 0) {
                    forward = this.getInputForward(p);
                }
            } else if (p.cmd == CommandType.Search || p.cmd == CommandType.ChangeSidebar) {
                logger.info(this.getLogHeader(p));
                finderContext.reset();
                try {
                    this.do_search(dp);
                }
                catch (SecurityException e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00101), LogCodeManager.getMessage(LogCode.JFC00101, p.user, e.getMessage()), (Throwable)e);
                    finderContext.reset();
                    throw e;
                }
                catch (Exception e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00100), LogCodeManager.getMessage(LogCode.JFC00100, p.user, e.getMessage()), (Throwable)e);
                    Object[] ep = new Object[]{e.getMessage()};
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
                    finderContext.reset();
                }
            } else if (p.cmd == CommandType.Next) {
                logger.info(this.getLogHeader(p));
                if (finderContext.isNextPage()) {
                    finderContext.next();
                    this.do_request(dp);
                    this.do_next(dp);
                }
            } else if (p.cmd == CommandType.Prev) {
                logger.info(this.getLogHeader(p));
                if (finderContext.isPrevPage()) {
                    finderContext.prev();
                    this.do_request(dp);
                    this.do_prev(dp);
                }
            } else if (p.cmd == CommandType.First) {
                logger.info(this.getLogHeader(p));
                finderContext.first();
                this.do_request(dp);
                this.do_first(dp);
            } else if (p.cmd == CommandType.Last) {
                logger.info(this.getLogHeader(p));
                finderContext.last();
                this.do_request(dp);
                this.do_last(dp);
            } else {
                logger.info(this.getLogHeader(p));
                String forward1 = this.execExecuteMethod(p, null);
                if (forward1 == null || !forward1.equals("None")) {
                    forward = forward1;
                }
            }
        }
        logger.debug(this.getLogHeader(p) + "rbean.getSizePerPage() is " + finderContext.getPageSize());
        logger.debug(this.getLogHeader(p) + "rbean.getSize() is " + finderContext.getRowCount());
        logger.debug(this.getLogHeader(p) + "rbean.getCurrent() is " + finderContext.getFirstResult());
        List<Master> coll = this.do_setData(dp);
        Master newobj = new Master();
        newobj.setId(-1);
        coll.add(newobj);
        Master[] array = coll.toArray(new Master[0]);
        Map masterMap = (Map)p.pageMap.get(masterMapPagemapName);
        if (masterMap != null) {
            logger.debug(this.getLogHeader(p) + "masterMap is " + masterMap);
            for (int i = 0; i < array.length; ++i) {
                Master master = array[i];
                logger.debug(this.getLogHeader(p) + "original:" + master);
                Master tmpmaster = (Master)masterMap.get(Integer.toString(master.getId()));
                if (tmpmaster == null) continue;
                master.setContent(tmpmaster.getContent());
                master.setPriority(tmpmaster.getPriority());
                master.setValid(tmpmaster.getValid());
                logger.debug(this.getLogHeader(p) + "changed:" + master);
            }
        }
        MasterL _list = MasterLHelper.s2l(array, p);
        MasterLp _listp = MasterLpHelper.l2lp(_list, p);
        logger.debug(this.getLogHeader(p) + "coll is " + coll);
        logger.debug(this.getLogHeader(p) + "_list is " + _list);
        logger.debug(this.getLogHeader(p) + "_listp is " + _listp);
        p.pageMap.put(masterLPagemapName, _list);
        p.request.setAttribute(masterLpPagemapName, (Object)_listp);
        int size = finderContext.getRowCount() == 0 ? 1 : finderContext.getRowCount();
        final int size1 = size;
        p.request.setAttribute("jfc_result", (Object)new FinderContextResultBeanWrapper(finderContext){

            @Override
            public int getSize() {
                return size1;
            }
        });
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if ((endLogMsg = this.endLog(p)) != null) {
            logger.info(endLogMsg);
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            logger.debug("forward is null.");
            return this.getInputForward(p);
        }
        return forward;
    }

    public void do_search(ActionParameter p) throws IOException, ServletException {
    }

    public List<Master> do_setData(ActionParameter p) throws IOException, ServletException {
        return new ArrayList<Master>();
    }

    /*
     * WARNING - void declaration
     */
    public void do_request(ActionParameter p) throws IOException, ServletException {
        void var11_14;
        Item item_p;
        Integer newId;
        String prefix = "master_lp$item[";
        HashMap<String, Item> itemMap = (HashMap<String, Item>)p.pageMap.get(itemMapPagemapName);
        if (itemMap == null) {
            itemMap = new HashMap<String, Item>();
            p.pageMap.put(itemMapPagemapName, itemMap);
        }
        if ((newId = (Integer)p.pageMap.get(newIdPagemapName)) == null) {
            newId = -1;
            p.pageMap.put(newIdPagemapName, newId);
        }
        int newid = newId;
        StringFilter masterfilter = this.getStringFilter();
        TreeSet<Object> keySet = new TreeSet<Object>();
        boolean createNewItemFlag = false;
        Enumeration enu = p.request.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            keySet.add(key);
        }
        for (String string : keySet) {
            block18: {
                logger.debug(this.getLogHeader(p) + string);
                String value = p.request.getParameter(string).toString();
                if (!string.startsWith(prefix)) continue;
                if (masterfilter != null) {
                    value = masterfilter.filter(value);
                }
                String _id = string.substring(prefix.length());
                if ("-1".equals(_id = _id.substring(0, _id.indexOf("]")))) {
                    _id = Integer.toString(newid);
                }
                String restkey = string.substring(string.indexOf("]") + 2);
                logger.debug(this.getLogHeader(p) + "_id:" + _id + ",restkey:" + restkey);
                item_p = (Item)itemMap.get(_id);
                if (item_p == null) {
                    item_p = new Item();
                    item_p.setId(_id);
                    itemMap.put(_id, item_p);
                }
                try {
                    if (!restkey.equals("id")) {
                        if (string.endsWith("content_en") && StringUtils.isNotBlank((CharSequence)value)) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("{ \"ja\":\"");
                            sb.append(item_p.getContent());
                            sb.append("\", \"en\":\"");
                            sb.append(value);
                            sb.append("\" }");
                            item_p.setContent(sb.toString());
                        } else {
                            item_p.plSetByString(restkey, value);
                        }
                        logger.debug(this.getLogHeader(p) + " Setting..." + restkey + ":" + value);
                    }
                }
                catch (Exception e) {
                    logger.debug(this.getLogHeader(p) + "Failed to retrieve item.", (Throwable)e);
                    if (!logger.isDebugEnabled()) break block18;
                    e.printStackTrace();
                }
            }
            if (StringUtil.intValue((String)item_p.getId()) >= 0 || item_p.getContent() == null || item_p.getContent().length() <= 0 || item_p.getValid() == null || item_p.getContent().length() <= 0) continue;
            createNewItemFlag = true;
        }
        if (createNewItemFlag) {
            p.pageMap.put(newIdPagemapName, newid--);
        }
        logger.debug(this.getLogHeader(p) + " Return:" + itemMap);
        MasterL master_l = (MasterL)p.pageMap.get(masterLPagemapName);
        if (master_l == null) {
            logger.debug(this.getLogHeader(p) + "master_l object is null.");
            return;
        }
        Map map = (Map)p.pageMap.get(masterMapPagemapName);
        if (map == null) {
            HashMap hashMap = new HashMap();
            p.pageMap.put(masterMapPagemapName, hashMap);
        }
        jp.jasminesoft.jfc.model.master_l.Item[] litems = master_l.getItem();
        for (int i = 0; i < litems.length; ++i) {
            String _id = Integer.toString(litems[i].getId());
            if (_id.equals("-1")) continue;
            item_p = (Item)itemMap.get(_id);
            if (!(item_p == null || item_p.getContent() != null && item_p.getContent().equals(litems[i].getContent()) && item_p.getValid() != null && item_p.getValid().equals(litems[i].getValid()) && item_p.getPriority() != null && StringUtil.intValue((String)item_p.getPriority()) == litems[i].getPriority())) {
                var11_14.put(item_p.getId(), MasterLpHelper.createMasterObject(item_p));
            }
            itemMap.remove(_id);
        }
        logger.debug(this.getLogHeader(p) + " processed map:" + var11_14);
        logger.debug(this.getLogHeader(p) + " rest size:" + itemMap.size());
        Iterator iterator = itemMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            Item item_p2 = (Item)entry.getValue();
            logger.debug(this.getLogHeader(p) + " create:" + item_p2);
            if (!(item_p2.getContent() != null && item_p2.getContent().length() != 0 || item_p2.getValid() != null && item_p2.getValid().length() != 0)) continue;
            var11_14.put(item_p2.getId(), MasterLpHelper.createMasterObject(item_p2));
        }
        logger.debug(this.getLogHeader(p) + " last:" + var11_14);
        p.pageMap.put(masterMapPagemapName, var11_14);
    }

    public void do_update(ActionParameter p) throws IOException, ServletException {
        ArrayList<Master> list = new ArrayList<Master>();
        Map masterMap = (Map)p.pageMap.get(masterMapPagemapName);
        Iterator iterator = masterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            Master master = (Master)entry.getValue();
            this.input_check(master, p);
            list.add(master);
        }
        if (p.errors.sizeJfcerror() > 0) {
            return;
        }
        this.do_update0(p, list);
        MasterTable mtable = this.getMasterTable(p);
        if (mtable == null) {
            mtable = this.getDbMasterTable(p);
        }
        if (mtable instanceof DbMasterTable) {
            ((DbMasterTable)mtable).init(p);
        }
        masterMap.clear();
        Map itemMap = (Map)p.pageMap.get(itemMapPagemapName);
        itemMap.clear();
        this.do_search(p);
    }

    public void input_check(Master master, ActionParameter p) {
        if (StringUtils.isEmpty((CharSequence)master.getContent())) {
            logger.debug("master data is null. master id : " + master.getId());
            Object[] o = new Object[]{master.getId()};
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.input.master.no_input", o, p.locale));
        }
    }

    public MasterTable getMasterTable(ActionParameter p) {
        return null;
    }

    public DbMasterTable getDbMasterTable(ActionParameter p) {
        return null;
    }

    public void do_update0(ActionParameter p, List list) throws IOException, ServletException {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                logger.info(this.getLogHeader(p) + list.get(i));
            }
        }
    }

    public void do_next(ActionParameter p) throws IOException, ServletException {
    }

    public void do_prev(ActionParameter p) throws IOException, ServletException {
    }

    public void do_last(ActionParameter p) throws IOException, ServletException {
    }

    public void do_first(ActionParameter p) throws IOException, ServletException {
    }

    @Override
    public String do_original(ActionParameter p) throws IOException, ServletException {
        return super.do_original(p);
    }
}

