/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.DbShowBaseController;
import jp.jasminesoft.jfc.controller.DbShowControllerDataitem;
import jp.jasminesoft.jfc.controller.RetrieveDataSource;
import jp.jasminesoft.jfc.controller.RetrieveDataUtil;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class DbShowController<E extends ContainerBase<E>, Ep, PK extends Serializable>
extends DbShowBaseController<E, PK>
implements RetrieveDataSource<E> {
    @Autowired
    @Qualifier(value="DownloadFileObjectFactory")
    private DownloadFileObjectFactory dfofactory;
    private EntityHelper<E, PK> entityHelper;
    private PresentationPHelper<E, Ep> pHelper;
    private List<DbShowControllerDataitem<E>> dataitemList = Collections.emptyList();
    private static final Logger logger = LogManager.getLogger(DbShowController.class);

    public void setEntityHelper(EntityHelper<E, PK> helper) {
        this.entityHelper = helper;
    }

    public EntityHelper<E, PK> getEntityHelper() {
        return this.entityHelper;
    }

    public void setPHelper(PresentationPHelper<E, Ep> helper) {
        this.pHelper = helper;
    }

    public PresentationPHelper<E, Ep> getPHelper() {
        return this.pHelper;
    }

    public void setDbShowControllerDataitem(List<DbShowControllerDataitem<E>> dataitemList1) {
        this.dataitemList = dataitemList1;
    }

    public List<DbShowControllerDataitem<E>> getDbShowControllerDataitem() {
        return this.dataitemList;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_pankuzu.show" + this.getModelIdDescriptionResourceKey();
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission(this.getModelIdPermission(), "select");
    }

    @Override
    public abstract String getModelId();

    public RetrieveDataUtil<E> getRetrieveDataUtil() {
        RetrieveDataUtil util = new RetrieveDataUtil();
        util.setRetrieveDataSource(this);
        return util;
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        String[] pkeynames = this.getPrimaryKeyModelitemName();
        String[] pkeyrefnames = this.getPrimaryKeyRefName();
        String[] pkeytypes = this.getPrimaryKeyType();
        if (pkeynames.length == 1) {
            return this.getPankuzuNode(p, pkeynames[0], pkeyrefnames[0], pkeytypes[0]);
        }
        return this.getPankuzuNode(p, pkeynames, pkeyrefnames, pkeytypes);
    }

    public PankuzuNode getPankuzuNode(ActionParameter p, String[] pkeynames, String[] pkeyrefnames, String[] pkeytypes) {
        String conname = this.getRetrieveDataUtil().createPrimaryKeyName(pkeynames, pkeyrefnames);
        String[] conname1s = new String[pkeynames.length];
        for (int i = 0; i < pkeynames.length; ++i) {
            String conname1;
            conname1s[i] = conname1 = this.getRetrieveDataUtil().createFullPrimaryKeyName(pkeynames[i], pkeyrefnames[i]);
        }
        PankuzuNode pnode = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String name = null;
        String value = null;
        Enumeration e = p.request.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            boolean isset = false;
            if (conname.equals(name)) {
                value = p.request.getParameter(name);
                for (String conname1 : conname1s) {
                    paramMap.put(conname1, value.substring(0, value.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR())));
                    value = value.substring(value.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) + 1);
                }
                isset = true;
            }
            if (!isset) {
                for (String conname1 : conname1s) {
                    if (!conname1.equals(name)) continue;
                    value = p.request.getParameter(name);
                    paramMap.put(name, value);
                    isset = true;
                }
            }
            if (!isset && name.indexOf(":" + conname + ":") > 0) {
                String pkeyidx = ":" + conname + ":";
                int ptr = name.indexOf(pkeyidx);
                value = name.substring(ptr + pkeyidx.length());
                for (String conname1 : conname1s) {
                    paramMap.put(conname1, value.substring(0, value.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR())));
                    value = value.substring(value.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) + 1);
                }
                isset = true;
            }
            if (!isset) {
                for (String conname1 : conname1s) {
                    if (!name.equals(this.getModelId() + StringUtil.convertHtmlIdString((String)"/") + conname1)) continue;
                    value = p.request.getParameter(name);
                    paramMap.put(conname1, value);
                }
            }
            if (!name.startsWith("action_ShowPrev") && !name.startsWith("action_ShowNext")) continue;
            paramMap.put(name, "g");
        }
        for (int i = 0; i < pkeynames.length; ++i) {
            String conname1 = conname1s[i];
            if (paramMap.containsKey(conname1)) continue;
            Object o = p.request.getAttribute(conname1);
            if (o != null) {
                paramMap.put(conname1, o);
                continue;
            }
            o = p.appMap.get(this.getStatus() + "_" + conname1);
            if (o == null) continue;
            paramMap.put(conname1, o);
        }
        boolean _validFlag = true;
        ArrayList<String> conname1sList = new ArrayList<String>(Arrays.asList(conname1s));
        conname1sList.removeAll(paramMap.keySet());
        if (conname1sList.size() == 0) {
            for (int i = 0; i < pkeynames.length; ++i) {
                String pkeyname = pkeynames[i];
                String pkeytype = pkeytypes[i];
                String _value = (String)paramMap.get(pkeyname);
                if (SourceGeneratorUtil.isBasicType((String)pkeytype)) {
                    if (!StringUtil.value((String)pkeytype, (String)_value).equals(SourceGeneratorUtil.getNanValue((String)pkeytype))) continue;
                    _validFlag = false;
                    break;
                }
                if (!StringUtils.isEmpty((String)_value)) continue;
                _validFlag = false;
                break;
            }
            if (_validFlag) {
                String url = "show" + this.getModelIdPankuzu();
                if (this.getWizardTargetitems() != null) {
                    url = url + "1";
                }
                pnode = new PankuzuNode(this.getDescription(p), url, paramMap);
            } else {
                pnode = null;
            }
        } else {
            pnode = new PankuzuNode(this.getDescription(p), null);
        }
        return pnode;
    }

    public PankuzuNode getPankuzuNode(ActionParameter p, String pkeyname, String pkeyrefname, String pkeytype) {
        String conname1 = this.getRetrieveDataUtil().createFullPrimaryKeyName(pkeyname, pkeyrefname);
        PankuzuNode pnode = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String name = null;
        String value = null;
        Enumeration e = p.request.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            if (conname1.equals(name)) {
                value = p.request.getParameter(name);
                paramMap.put(name, value);
            } else if (name.indexOf(":" + conname1 + ":") > 0) {
                String pkeyidx = ":" + conname1 + ":";
                int ptr = name.indexOf(pkeyidx);
                value = name.substring(ptr + pkeyidx.length());
                paramMap.put(conname1, value);
            } else if (name.equals(this.getModelId() + StringUtil.convertHtmlIdString((String)"/") + conname1)) {
                value = p.request.getParameter(name);
                paramMap.put(conname1, value);
            }
            if (!name.startsWith("action_ShowPrev") && !name.startsWith("action_ShowNext")) continue;
            paramMap.put(name, "g");
        }
        if (!paramMap.containsKey(conname1)) {
            Object o = p.request.getAttribute(conname1);
            if (o != null) {
                paramMap.put(conname1, o);
            } else {
                o = p.appMap.get(this.getStatus() + "_" + conname1);
                if (o != null) {
                    paramMap.put(conname1, o);
                }
            }
        }
        boolean _validFlag = true;
        if (paramMap.containsKey(conname1)) {
            String _value = (String)paramMap.get(conname1);
            if (SourceGeneratorUtil.isBasicType((String)pkeytype)) {
                if (StringUtil.value((String)pkeytype, (String)_value).equals(SourceGeneratorUtil.getNanValue((String)pkeytype))) {
                    _validFlag = false;
                }
            } else if (StringUtils.isEmpty((String)_value)) {
                _validFlag = false;
            }
            if (_validFlag) {
                String url = "show" + this.getModelIdPankuzu();
                if (this.getWizardTargetitems() != null) {
                    url = url + "1";
                }
                pnode = new PankuzuNode(this.getDescription(p), url, paramMap);
            } else {
                pnode = null;
            }
        } else {
            pnode = new PankuzuNode(this.getDescription(p), null);
        }
        return pnode;
    }

    @Override
    public String getForwardName(String type) {
        if ("no_data".equals(type)) {
            return "noData";
        }
        return null;
    }

    @Override
    public Object retrieveData(ActionParameter p) {
        this.retrieveData_first_hook(p);
        Object ret = this.getRetrieveDataUtil().retrieveData(p);
        this.retrieveData_finish_hook(p);
        return ret;
    }

    @Override
    public String do_show(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    protected void do_show_child(ActionParameter p, DbShowControllerDataitem<E> dataitem, E entity) {
        dataitem.do_show(p, entity);
    }

    @Override
    protected String getPrimaryKeyAsString(E entity, ActionParameter p) {
        return this.getEntityHelper().getPrimarykeyAsString(entity, p);
    }

    protected PK getPrimarykey(String pkey, ActionParameter p) {
        return this.getEntityHelper().getPrimarykey(pkey);
    }

    protected String getModelIdDescriptionResourceKey() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    protected String getModelIdPermission() {
        return this.getModelId();
    }

    protected String getModelIdPankuzu() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    public String getSkipBeforeShowRequestName(String _ret) {
        String base = "__jfc_control.skipBeforeShow_" + this.getModelId();
        if (StringUtils.isBlank((String)_ret)) {
            return base;
        }
        return base + "_" + _ret;
    }

    public String getEntityRequestName() {
        return this.getModelId();
    }

    protected String getPRequestName() {
        return this.getModelId() + "_p";
    }

    @Override
    public abstract String[] getPrimaryKeyModelitemName();

    @Override
    public abstract String[] getPrimaryKeyRefName();

    protected abstract String[] getPrimaryKeyType();

    protected String[][] getWizardTargetitems() {
        return null;
    }

    public ResponseEntity<Map<String, Object>> getRest(String pkey, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        final String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
        if (pkey != null) {
            request.setAttribute("_" + pkeyname, (Object)pkey);
        }
        return this.callRest(request, response, new BaseController.CallRestListener(){

            @Override
            public ResponseEntity<Map<String, Object>> afterExecute(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
                map.put("entity", request.getAttribute(DbShowController.this.getEntityRequestName()));
                map.put("entityp", request.getAttribute(DbShowController.this.getPRequestName()));
                map.put("pkey", request.getAttribute(pkeyname));
                return null;
            }
        });
    }

    public void getFileRest(HttpServletRequest request, HttpServletResponse response, String pkey, String pmodelitem, int cnum, String modelitem) throws IOException, ServletException {
        ResponseEntity<Map<String, Object>> res = this.getRest(pkey, request, response);
        Map map = (Map)res.getBody();
        ContainerBase entity = (ContainerBase)map.get("entity");
        Object entityp = map.get("entityp");
        if (entity == null || entityp == null) {
            HttpStatus status = (HttpStatus)request.getAttribute("jfcErrorHttpStatus");
            if (status != null) {
                response.sendError(status.value());
            } else {
                response.sendError(400);
            }
            return;
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        String localfilename = phelper.getLocalFilename(entity, entityp, pmodelitem, cnum, modelitem);
        String filename = phelper.getFilename(entity, entityp, pmodelitem, cnum, modelitem);
        try (DownloadFileObject dfo = this.dfofactory.create(localfilename, request);){
            String msg = this.checkFile(request, response, dfo, filename, pkey, modelitem);
            if (msg != null && msg.length() > 0) {
                response.sendError(500, msg);
                return;
            }
            this.getFileRest(request, response, dfo, filename);
        }
        logger.debug("localfilename = " + localfilename);
        logger.debug("filename = " + filename);
    }

    public void getFileRest(HttpServletRequest request, HttpServletResponse response, String pkey, String modelitem) throws IOException, ServletException {
        ResponseEntity<Map<String, Object>> res = this.getRest(pkey, request, response);
        Map map = (Map)res.getBody();
        ContainerBase entity = (ContainerBase)map.get("entity");
        Object entityp = map.get("entityp");
        if (entity == null || entityp == null) {
            HttpStatus status = (HttpStatus)request.getAttribute("jfcErrorHttpStatus");
            if (status != null) {
                response.sendError(status.value());
            } else {
                response.sendError(400);
            }
            return;
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        String localfilename = phelper.getLocalFilename(entity, entityp, modelitem);
        String filename = phelper.getFilename(entity, entityp, modelitem);
        try (DownloadFileObject dfo = this.dfofactory.create(localfilename, request);){
            if (dfo == null || !dfo.canRead()) {
                throw new FileNotFoundException("File " + dfo.getDescription() + " is can't read.");
            }
            String msg = this.checkFile(request, response, dfo, filename, pkey, modelitem);
            if (msg != null && msg.length() > 0) {
                response.sendError(500, msg);
                return;
            }
            this.getFileRest(request, response, dfo, filename);
        }
        logger.debug("localfilename = " + localfilename);
        logger.debug("filename = " + filename);
    }

    private String checkFile(HttpServletRequest request, HttpServletResponse response, DownloadFileObject dfo, String filename, String pkey, String modelitem) throws IOException {
        return dfo.checkFile(request, response, filename, this.getModelId(), pkey, modelitem);
    }

    private void getFileRest(HttpServletRequest request, HttpServletResponse response, DownloadFileObject dfo, String filename) throws IOException {
        URL redirecturl;
        if (dfo == null || !dfo.canRead()) {
            throw new FileNotFoundException("File " + dfo.getDescription() + " is can't read.");
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)filename, (HttpServletRequest)request, (String)"inline"));
        String cacheControl = dfo.getKeySetting().getRestCacheControl();
        if (cacheControl != null) {
            response.setHeader("Cache-Control", cacheControl);
        }
        if ((redirecturl = dfo.getRedirectUrl()) != null) {
            response.sendRedirect(redirecturl.toString());
            return;
        }
        try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            dfo.write(output);
        }
    }
}

