/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.controller.DbShowListBaseController;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.commons.lang3.StringUtils;

public abstract class DbShowListSelectableAllBaseController<E extends ContainerBase<E>, EC, PK extends Serializable>
extends DbShowListBaseController<E, EC, PK> {
    public static final String selectIdSetAppmapName = "__jfc_selectIdSet";
    public static final String unselectIdSetAppmapName = "__jfc_unselectIdSet";
    public static final String selectModeAppmapName = "jfc_selectMode";
    public static final String SELECTMODE_UNSELECT = "UNSELECT";
    public static final String SELECTMODE_SELECT = "SELECT";

    public String getSelectModeKeyName() {
        return this.getStatus() + "_selectMode";
    }

    public String getActionSelectIdSetKeyName() {
        return this.getStatus() + "_selectIdSet";
    }

    public String getActionUnselectIdSetKeyName() {
        return this.getStatus() + "_unselectIdSet";
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        if (p.action != null && p.action.startsWith("CheckToggle")) {
            return CommandType.CheckToggle;
        }
        return super.getCommand(p);
    }

    protected void updateIdSet(ActionParameter p) {
        String selectMode;
        boolean useCheckboxMode = false;
        if (p.request != null && StringUtils.isNotEmpty((CharSequence)p.request.getParameter("jfc_use_cb"))) {
            useCheckboxMode = true;
        }
        if ((selectMode = (String)p.appMap.get(this.getSelectModeKeyName())) == null) {
            selectMode = useCheckboxMode ? SELECTMODE_SELECT : SELECTMODE_UNSELECT;
            p.appMap.put(this.getSelectModeKeyName(), selectMode);
        }
        String actionIdSetAppmapName = null;
        actionIdSetAppmapName = selectMode.equals(SELECTMODE_SELECT) ? this.getActionSelectIdSetKeyName() : this.getActionUnselectIdSetKeyName();
        LinkedHashSet<String> idSet = (LinkedHashSet<String>)p.appMap.get(actionIdSetAppmapName);
        if (idSet == null) {
            idSet = new LinkedHashSet<String>();
        }
        HashSet<String> tmpSet = null;
        Enumeration em = p.request.getParameterNames();
        while (em.hasMoreElements()) {
            String[] values;
            String key = (String)em.nextElement();
            if (key.startsWith("SELECTLIST")) {
                values = p.request.getParameterValues(key);
                String name = key.substring("SELECTLIST_".length());
                name = JFCUtils.decodePrimaryKey(name);
                for (int i = 0; i < values.length; ++i) {
                    String value = JFCUtils.decodePrimaryKey(values[i]);
                    if (idSet.contains(name)) {
                        if (value.length() != 0) continue;
                        idSet.remove(name);
                        continue;
                    }
                    if (value.length() == 0) continue;
                    idSet.add(name);
                }
                continue;
            }
            if (!useCheckboxMode || !key.endsWith("_jsh_cb")) continue;
            if (tmpSet == null) {
                tmpSet = new HashSet<String>();
            }
            values = p.request.getParameterValues(key);
            for (int i = 0; i < values.length; ++i) {
                String value = JFCUtils.decodePrimaryKey(values[i]);
                if (value.length() == 0) continue;
                tmpSet.add(value);
            }
        }
        if (useCheckboxMode) {
            if (tmpSet == null || tmpSet.size() == 0) {
                idSet = new LinkedHashSet();
                selectMode = SELECTMODE_SELECT;
                p.appMap.put(this.getSelectModeKeyName(), selectMode);
            } else {
                idSet.addAll(tmpSet);
                HashSet<String> unused = new HashSet<String>();
                for (String s : idSet) {
                    if (tmpSet.contains(s)) continue;
                    unused.add(s);
                }
                idSet.removeAll(unused);
            }
        } else if (tmpSet != null && tmpSet.size() > 0) {
            idSet.addAll(tmpSet);
        }
        p.appMap.put(actionIdSetAppmapName, idSet);
        if (selectMode.equals(SELECTMODE_SELECT)) {
            p.appMap.put(selectIdSetAppmapName, idSet);
        } else {
            p.appMap.put(unselectIdSetAppmapName, idSet);
        }
    }

    @Deprecated
    protected boolean isUnselectId(String id, ActionParameter p) {
        return this.isContainsId(id, p);
    }

    protected boolean isContainsId(String id, ActionParameter p) {
        String selectMode = (String)p.appMap.get(this.getSelectModeKeyName());
        Set<String> idSet = this.getIdSet(selectMode, p);
        if (idSet == null) {
            return false;
        }
        boolean ret = idSet.contains(id);
        if (selectMode.equals(SELECTMODE_UNSELECT)) {
            ret = !ret;
        }
        return ret;
    }

    protected Set<String> getIdSet(ActionParameter p) {
        String selectMode = (String)p.appMap.get(this.getSelectModeKeyName());
        return this.getIdSet(selectMode, p);
    }

    protected Set<String> getIdSet(String selectMode, ActionParameter p) {
        String actionIdSetAppmapName = null;
        actionIdSetAppmapName = selectMode.equals(SELECTMODE_SELECT) ? this.getActionSelectIdSetKeyName() : this.getActionUnselectIdSetKeyName();
        return (Set)p.appMap.get(actionIdSetAppmapName);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        this.setCommandToActionParameter(p);
        this.updateIdSet(p);
        String selectMode = (String)p.appMap.get(this.getSelectModeKeyName());
        if (p.cmd == CommandType.CheckToggle) {
            Set idSet;
            if (selectMode.equals(SELECTMODE_UNSELECT)) {
                selectMode = SELECTMODE_SELECT;
                idSet = (Set)p.appMap.get(this.getActionUnselectIdSetKeyName());
                if (idSet != null) {
                    idSet.clear();
                }
            } else {
                selectMode = SELECTMODE_UNSELECT;
                idSet = (Set)p.appMap.get(this.getActionSelectIdSetKeyName());
                if (idSet != null) {
                    idSet.clear();
                }
            }
            p.appMap.put(this.getSelectModeKeyName(), selectMode);
        }
        p.request.setAttribute(selectModeAppmapName, (Object)selectMode);
        if (p.request != null && StringUtils.isNotEmpty((CharSequence)p.request.getParameter("jfc_use_cb"))) {
            String actionIdSetAppmapName = null;
            actionIdSetAppmapName = selectMode.equals(SELECTMODE_SELECT) ? this.getActionSelectIdSetKeyName() : this.getActionUnselectIdSetKeyName();
            Set idSet = (Set)p.appMap.get(actionIdSetAppmapName);
            p.request.setAttribute(actionIdSetAppmapName, (Object)idSet);
        }
        return super.perform_db(p);
    }
}

