/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.FilenameList;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.CreateObjectHelper;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.FilterHelper;
import jp.jasminesoft.jfc.app.IInputCheckHelper;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.ContainerMeta;
import jp.jasminesoft.jfc.controller.DbUpdateBaseController;
import jp.jasminesoft.jfc.controller.RetrieveDataSource;
import jp.jasminesoft.jfc.controller.RetrieveDataUtil;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.util.MultiPartForm;
import jp.jasminesoft.util.MultiPartFormBase;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class DbUpdateController<E extends ContainerBase<E>, Ep, PK extends Serializable>
extends DbUpdateBaseController<E, PK>
implements RetrieveDataSource<E> {
    @Autowired
    @Qualifier(value="DownloadFileObjectFactory")
    private DownloadFileObjectFactory dfofactory;
    private EntityHelper<E, PK> entityHelper;
    private PresentationPHelper<E, Ep> pHelper;
    private FilterHelper<Ep> filterHelper;
    private IInputCheckHelper<E, Ep> inputCheckHelper;
    private CreateObjectHelper<Ep> createObjectHelper;
    private static final Logger logger = LogManager.getLogger(DbUpdateController.class);

    public void setEntityHelper(EntityHelper<E, PK> helper) {
        this.entityHelper = helper;
    }

    public EntityHelper<E, PK> getEntityHelper() {
        return this.entityHelper;
    }

    public void setPHelper(PresentationPHelper<E, Ep> helper) {
        this.pHelper = helper;
    }

    public PresentationPHelper<E, Ep> getPHelper() {
        return this.pHelper;
    }

    public void setFilterHelper(FilterHelper<Ep> helper) {
        this.filterHelper = helper;
    }

    public FilterHelper<Ep> getFilterHelper() {
        return this.filterHelper;
    }

    public void setInputCheckHelper(IInputCheckHelper<E, Ep> helper) {
        this.inputCheckHelper = helper;
    }

    public IInputCheckHelper<E, Ep> getInputCheckHelper() {
        return this.inputCheckHelper;
    }

    public void setCreateObjectHelper(CreateObjectHelper<Ep> helper) {
        this.createObjectHelper = helper;
    }

    public CreateObjectHelper<Ep> getCreateObjectHelper() {
        return this.createObjectHelper;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        if (p.cmd == CommandType.Confirm) {
            return "__jfc_pankuzu.update" + this.getModelIdDescriptionResourceKey() + ".confirm";
        }
        return "__jfc_pankuzu.update" + this.getModelIdDescriptionResourceKey();
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission(this.getModelIdPermission(), "update");
    }

    @Override
    public abstract String getModelId();

    public RetrieveDataUtil<E> getRetrieveDataUtil() {
        RetrieveDataUtil util = new RetrieveDataUtil();
        util.setRetrieveDataSource(this);
        return util;
    }

    @Override
    public String getForwardName(String type) {
        if ("normal".equals(type)) {
            return "redirect:show" + this.getModelIdForwardUrl() + ".do";
        }
        if ("cancel".equals(type)) {
            return this.getForwardHeader() + ".cancel";
        }
        if ("lock_error".equals(type)) {
            return this.getForwardHeader() + ".lock_error";
        }
        if ("no_data".equals(type)) {
            return "noData";
        }
        if ("confirm".equals(type)) {
            return this.getForwardHeader() + ".confirm";
        }
        return null;
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        this.getCommand_first_hook(p);
        if (!(cmd != CommandType.None || p.referrer != null && p.referrer.length() != 0 && p.referrer.equals(this.getStatus()))) {
            cmd = CommandType.BeginUpdate;
        }
        this.getCommand_finish_hook(p);
        return cmd;
    }

    @Override
    public Object retrieveKey(ActionParameter p) {
        this.retrieveKey_first_hook(p);
        Object ret = this.getRetrieveDataUtil().retrieveDataAtUpdate(p);
        this.retrieveKey_finish_hook(p);
        return ret;
    }

    @Override
    public Object retrieveData(ActionParameter p) {
        this.retrieveData_first_hook(p);
        Object entityp = p.request.getAttribute("__jfc_retrieveData_entityp");
        if (entityp == null) {
            ContainerBase entity = (ContainerBase)p.request.getAttribute("__jfc_retrieveData_entity");
            entityp = entity == null ? this.getCreateObjectHelper().createObject(p) : this.getPHelper().s2p(entity, p, 2);
        }
        this.retrieveData_finish_hook(p);
        return entityp;
    }

    @Override
    public String registLockModel(ActionParameter p) {
        this.registLockModel_first_hook(p);
        StringBuilder sb = new StringBuilder(this.getModelId());
        this.registLockModel_finish_hook(sb, p);
        return sb.toString();
    }

    @Override
    public Object registLockPrimaryKey(ActionParameter p) {
        this.registLockPrimaryKey_first_hook(p);
        Object ret = this.retrieveKey(p);
        this.registLockPrimaryKey_finish_hook(ret, p);
        return ret;
    }

    @Override
    public String do_read(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_update(ActionParameter p) throws IOException, ServletException {
        String _redirect = null;
        return _redirect;
    }

    @Override
    public String do_cancel(ActionParameter p) throws IOException, ServletException {
        return this.getForwardName("cancel");
    }

    @Override
    public String do_addItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_removeItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_moveUpItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_moveDownItem(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_sortItem0(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_default(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    @Override
    public String do_getxml(ActionParameter p) throws IOException, ServletException {
        return null;
    }

    @Override
    public String do_lockerror(ActionParameter p) {
        return this.getForwardName("lock_error");
    }

    @Override
    public MultiPartForm createMultiPartForm(ActionParameter p) {
        MultiPartForm multi = MultiPartFormBase.create();
        if (!multi.isMultipartContent(p.request)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ResourceManager savedirresman = new ResourceManager("savedir");
        String savedir = savedirresman.getValue("savedir." + this.getModelId());
        savedir = StringUtil.replace((String)savedir, (String)"${catalina.home}", (String)System.getProperty("catalina.home"));
        sb.append(savedir);
        File dir = new File(sb.toString());
        File catalinahome_bin_dir = new File(System.getProperty("catalina.home"), "bin");
        multi.setCurrentDirectory(catalinahome_bin_dir);
        multi.setSaveDirectory(dir);
        multi.setFilenameIgnoreCase(true);
        multi.setMaxFileNum(-1);
        multi.setMaxTextNum(-1);
        multi.setMaxFileSize(-1L);
        multi.setUseTempFile(true);
        multi.setDefaultCharEncoding(this.getJfcConfig().getJspEncoding());
        return multi;
    }

    @Override
    protected String getPrimaryKeyAsString(E entity, ActionParameter p) {
        return this.getEntityHelper().getPrimarykeyAsString(entity, p);
    }

    protected PK getPrimarykey(String pkey, ActionParameter p) {
        return this.getEntityHelper().getPrimarykey(pkey);
    }

    protected String getModelIdDescriptionResourceKey() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    protected String getModelIdPermission() {
        return this.getModelId();
    }

    protected String getModelIdPankuzu() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    protected String getModelIdForwardUrl() {
        return StringUtil.capFirst((String)this.getModelId());
    }

    protected String getModelIdFilenameList() {
        return this.getModelId();
    }

    protected String getPId() {
        return this.getModelId() + "_p";
    }

    protected String getUpdateModeRequestName() {
        return "__jfc_control.update_mode." + this.getModelId();
    }

    protected String getRecalcModeRequestName() {
        return "__jfc_control.recalc_mode." + this.getModelId();
    }

    protected String getTablenameDesc() {
        return "__jfc_tablename." + StringUtil.capFirst((String)this.getModelId()) + "ModelId";
    }

    public String getSkipBeforeShowRequestName() {
        return "__jfc_control.skipBeforeShow_" + this.getModelId();
    }

    public String getEntityRequestName() {
        return this.getModelId();
    }

    protected String getPRequestName() {
        return this.getModelId() + "_p";
    }

    protected String getEntityAppMapName() {
        return this.getModelId() + "_preserve";
    }

    protected String getPAppMapName() {
        return this.getModelId() + "_p_preserve";
    }

    @Override
    public abstract String[] getPrimaryKeyModelitemName();

    @Override
    public abstract String[] getPrimaryKeyRefName();

    protected abstract String[] getPrimaryKeyType();

    public abstract E newEntityModel();

    public abstract Ep newPModel();

    public abstract String[] getTargetitems();

    public Set<String> getTargetSet() {
        String[] targetitems = this.getTargetitems();
        HashSet<String> targetSet = targetitems != null ? new HashSet<String>(Arrays.asList(targetitems)) : new HashSet();
        return targetSet;
    }

    protected abstract String getPClassname();

    protected String[] getMultipleModelitemName() {
        return new String[0];
    }

    protected ContainerMeta[] getContainerMeta() {
        return new ContainerMeta[0];
    }

    public ResponseEntity<Map<String, Object>> beginUpdateRest(HttpServletRequest request, HttpServletResponse response, String pkey) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Update");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
        }
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> cancelRest(HttpServletRequest request, HttpServletResponse response, String pkey) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Cancel");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
        }
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> refreshRest(HttpServletRequest request, HttpServletResponse response, String pkey, Ep entityp) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        Object entityp2 = appMap.get(this.getPAppMapName());
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        phelper.setJshfilenameForRest(entityp, entityp2);
        request.setAttribute("action", (Object)"");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
        }
        request.setAttribute("__jfc_retrieveData_entityp", entityp);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> refreshRest(HttpServletRequest request, HttpServletResponse response, String pkey) throws IOException, ServletException {
        request.setAttribute("action", (Object)"");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
        }
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> updateRest(HttpServletRequest request, HttpServletResponse response, String pkey, Ep entityp) throws IOException, ServletException {
        request.setAttribute("callUpdateJsonRest", (Object)Boolean.TRUE);
        request.setAttribute("action", (Object)"Send");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
            request.setAttribute("__jfc_is_simple_update", (Object)Boolean.TRUE);
        }
        request.setAttribute("__jfc_retrieveData_entityp", entityp);
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> updateRest(HttpServletRequest request, HttpServletResponse response, String pkey, E entity) throws IOException, ServletException {
        request.setAttribute("callUpdateJsonRest", (Object)Boolean.TRUE);
        request.setAttribute("action", (Object)"Send");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
            request.setAttribute("__jfc_is_simple_update", (Object)Boolean.TRUE);
        }
        request.setAttribute("__jfc_retrieveData_entity", entity);
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> updateRest(HttpServletRequest request, HttpServletResponse response, String pkey, MultiValueMap<String, String> params) throws IOException, ServletException {
        request.setAttribute("callUpdateRest", (Object)Boolean.TRUE);
        request.setAttribute("createObject_multiValueMap", params);
        request.setAttribute("action", (Object)"Send");
        if (pkey != null) {
            String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
            request.setAttribute("_" + pkeyname, (Object)pkey);
            request.setAttribute("__jfc_is_simple_update", (Object)Boolean.TRUE);
        }
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    @Override
    protected String setAppMapEntity(ActionParameter p) throws IOException, ServletException {
        Object entity;
        String pkeyname = this.getRetrieveDataUtil().createPrimaryKeyName();
        String pkey = (String)p.request.getAttribute("_" + pkeyname);
        if (pkey == null) {
            return null;
        }
        p.request.setAttribute(pkeyname, (Object)JFCUtils.decodePrimaryKey(pkey));
        try {
            entity = this.getEntityService().findById(this.getPrimarykey(pkey, p));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            Object[] ep = new Object[]{e.getMessage()};
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess", ep, p.locale));
            return this.getInputForward(p);
        }
        if (entity == null) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.nodata", p.locale));
            p.request.setAttribute("jfcErrorHttpStatus", (Object)HttpStatus.NOT_FOUND);
            return this.getForwardName("no_data");
        }
        p.appMap.put(this.getEntityAppMapName(), entity);
        FilenameList filenamelist = (FilenameList)p.pageMap.get("__jfc_filenamelist");
        if (filenamelist == null) {
            filenamelist = FilenameList.create(this.getModelId());
            p.pageMap.put("__jfc_filenamelist", filenamelist);
        }
        List<String> filelist = this.getEntityHelper().getFileList(entity, p);
        filenamelist.addSrcFilenameList(filelist);
        this.setSessionEntityFilename(entity, p);
        return null;
    }

    protected void setSessionEntityFilename(E entity, ActionParameter p) {
        HashSet<String> jshfilenameitemSet = new HashSet<String>();
        HttpSession session = p.request.getSession();
        Class<?> entityclass = entity.getClass();
        String[] targetitems = this.getTargetitems();
        for (String targetitem : targetitems) {
            if (!targetitem.endsWith("_jshfilename")) continue;
            String targetitem1 = targetitem.substring(0, targetitem.length() - "_jshfilename".length());
            String methodname = "get" + StringUtil.capFirst((String)targetitem);
            String method1name = "get" + StringUtil.capFirst((String)targetitem1);
            try {
                Method method = entityclass.getMethod(methodname, new Class[0]);
                Method method1 = entityclass.getMethod(method1name, new Class[0]);
                Object ret = method.invoke(entity, new Object[0]);
                Object ret1 = method1.invoke(entity, new Object[0]);
                session.setAttribute(this.getPId() + StringUtil.convertHtmlIdString((String)"/") + targetitem, ret);
                session.setAttribute(this.getPId() + StringUtil.convertHtmlIdString((String)"/") + targetitem1, ret1);
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchMethodException e) {
                jshfilenameitemSet.add(targetitem);
            }
        }
        for (ContainerMeta contmeta : this.getContainerMeta()) {
            String methodname = "get" + StringUtil.capFirst((String)contmeta.getName());
            try {
                Method method = entityclass.getMethod(methodname, new Class[0]);
                Object cont = method.invoke(entity, new Object[0]);
                if (cont == null || !cont.getClass().isArray()) continue;
                this.setSessionContainerFilename(contmeta, cont, session, jshfilenameitemSet);
            }
            catch (InvocationTargetException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (jshfilenameitemSet.size() == 0) break;
        }
    }

    protected void setSessionContainerFilename(ContainerMeta contmeta, Object conts, HttpSession session, Set<String> jshfilenameitemSet) {
        ArrayList<String> processeditemList = new ArrayList<String>();
        Class<?> contaclass = conts.getClass();
        Class<?> contclass = contaclass.getComponentType();
        for (String targetitem : jshfilenameitemSet) {
            String targetitem1 = targetitem.substring(0, targetitem.length() - "_jshfilename".length());
            String methodname = "get" + StringUtil.capFirst((String)targetitem);
            String method1name = "get" + StringUtil.capFirst((String)targetitem1);
            try {
                Method method = contclass.getMethod(methodname, new Class[0]);
                Method method1 = contclass.getMethod(method1name, new Class[0]);
                int len = Array.getLength(conts);
                for (int num = 0; num < len; ++num) {
                    Object cont = Array.get(conts, num);
                    Object ret = method.invoke(cont, new Object[0]);
                    Object ret1 = method1.invoke(cont, new Object[0]);
                    String contmitemheader = this.getPId() + StringUtil.convertHtmlIdString((String)"/") + contmeta.getName() + StringUtil.convertHtmlIdString((String)"[") + (num + 1) + StringUtil.convertHtmlIdString((String)"]/");
                    session.setAttribute(contmitemheader + targetitem, ret);
                    session.setAttribute(contmitemheader + targetitem1, ret1);
                }
                processeditemList.add(targetitem);
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchMethodException e) {}
        }
        jshfilenameitemSet.removeAll(processeditemList);
    }

    @Override
    protected void setJshfilenameForRest(ActionParameter p) {
        Object entityp2 = p.appMap.get(this.getPAppMapName());
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        phelper.setJshfilenameForRest(p.o, entityp2);
    }

    public ResponseEntity<?> putFileRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"FileUpload");
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        Object jsonret = request.getAttribute(this.getClass() + "_jsonret");
        if (jsonret != null) {
            return new ResponseEntity(jsonret, (MultiValueMap)ret.getHeaders(), ret.getStatusCode());
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> putFileRest(HttpServletRequest request, HttpServletResponse response, HttpSession session, String pmodelitem, int pnum, String modelitem) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        ContainerBase entity = (ContainerBase)appMap.get(this.getEntityAppMapName());
        Object entityp = appMap.get(this.getPAppMapName());
        if (entity == null || entityp == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        MultiPartForm multi = null;
        try {
            multi = this.getMultiPartForm(request);
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
        if (multi == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        String FILE_KEY = "file";
        String filename = multi.getSrcFilename("file");
        File file = multi.getFileContents("file");
        if (file == null || filename == null) {
            multi.deleteAllFiles();
            multi.clear();
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        phelper.setFile(entity, entityp, pmodelitem, pnum, modelitem, file.toString(), filename);
        return this.refreshRest(request, response, null, entityp);
    }

    public ResponseEntity<Map<String, Object>> putFileRest(HttpServletRequest request, HttpServletResponse response, HttpSession session, String modelitem) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        ContainerBase entity = (ContainerBase)appMap.get(this.getEntityAppMapName());
        Object entityp = appMap.get(this.getPAppMapName());
        if (entity == null || entityp == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        MultiPartForm multi = null;
        try {
            multi = this.getMultiPartForm(request);
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
        if (multi == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        String FILE_KEY = "file";
        String filename = multi.getSrcFilename("file");
        File file = multi.getFileContents("file");
        if (file == null || filename == null) {
            multi.deleteAllFiles();
            multi.clear();
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        phelper.setFile(entity, entityp, modelitem, file.toString(), filename);
        return this.refreshRest(request, response, null, entityp);
    }

    public ResponseEntity<Map<String, Object>> deleteFileRest(HttpServletRequest request, HttpServletResponse response, HttpSession session, String pmodelitem, int cnum, String modelitem) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        ContainerBase entity = (ContainerBase)appMap.get(this.getEntityAppMapName());
        Object entityp = appMap.get(this.getPAppMapName());
        if (entity == null || entityp == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        phelper.deleteFile(entity, entityp, pmodelitem, cnum, modelitem);
        return this.refreshRest(request, response, null, entityp);
    }

    public ResponseEntity<Map<String, Object>> deleteFileRest(HttpServletRequest request, HttpServletResponse response, HttpSession session, String modelitem) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        ContainerBase entity = (ContainerBase)appMap.get(this.getEntityAppMapName());
        Object entityp = appMap.get(this.getPAppMapName());
        if (entity == null || entityp == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        phelper.deleteFile(entity, entityp, modelitem);
        return this.refreshRest(request, response, null, entityp);
    }

    public void getFileRest(HttpServletRequest request, HttpServletResponse response, HttpSession session, String pmodelitem, int cnum, String modelitem) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        ContainerBase entity = (ContainerBase)appMap.get(this.getEntityAppMapName());
        Object entityp = appMap.get(this.getPAppMapName());
        if (entity == null || entityp == null) {
            response.sendError(400);
            return;
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        String localfilename = phelper.getLocalFilename(entity, entityp, modelitem);
        String filename = phelper.getFilename(entity, entityp, pmodelitem, cnum, modelitem);
        try (DownloadFileObject dfo = this.dfofactory.create(localfilename, request);){
            this.getFileRest(request, response, dfo, filename);
        }
        logger.debug("localfilename = " + localfilename);
        logger.debug("filename = " + filename);
    }

    public void getFileRest(HttpServletRequest request, HttpServletResponse response, HttpSession session, String modelitem) throws IOException, ServletException {
        Map<String, Object> appMap = this.getAppMap(request);
        ContainerBase entity = (ContainerBase)appMap.get(this.getEntityAppMapName());
        Object entityp = appMap.get(this.getPAppMapName());
        if (entity == null || entityp == null) {
            response.sendError(400);
            return;
        }
        PresentationPHelper<E, Ep> phelper = this.getPHelper();
        String localfilename = phelper.getLocalFilename(entity, entityp, modelitem);
        String filename = phelper.getFilename(entity, entityp, modelitem);
        try (DownloadFileObject dfo = this.dfofactory.create(localfilename, request);){
            this.getFileRest(request, response, dfo, filename);
        }
        logger.debug("localfilename = " + localfilename);
        logger.debug("filename = " + filename);
    }

    private void getFileRest(HttpServletRequest request, HttpServletResponse response, DownloadFileObject dfo, String filename) throws IOException {
        URL redirecturl;
        if (dfo == null || !dfo.canRead()) {
            throw new FileNotFoundException("File " + dfo.getDescription() + " is can't read.");
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)filename, (HttpServletRequest)request, (String)"inline"));
        String cacheControl = dfo.getKeySetting().getRestCacheControl();
        if (cacheControl != null) {
            response.setHeader("Cache-Control", cacheControl);
        }
        if ((redirecturl = dfo.getRedirectUrl()) != null) {
            response.sendRedirect(redirecturl.toString());
            return;
        }
        try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            dfo.write(output);
        }
    }

    private E reloadEntity(ActionParameter p, String pkey) {
        E op = null;
        try {
            op = this.getEntityService().findById(this.getPrimarykey(pkey, p));
        }
        catch (Exception e) {
            String errmsg = this.convertErrorMessage(e, new String[][]{{"pkey", JFCUtils.getRValue("model4.pkey", p.locale)}});
            if (errmsg == null) {
                errmsg = "";
            }
            Object[] ep = new Object[]{errmsg};
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("model4.error.dbaccess", ep, p.locale));
            p.request.setAttribute("pkey", (Object)JFCUtils.decodePrimaryKey(pkey));
            p.request.setAttribute("jfcErrorHttpStatus", (Object)HttpStatus.NOT_FOUND);
            return null;
        }
        if (op == null) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("model4.error.dbaccess.nodata", p.locale));
            p.request.setAttribute("pkey", (Object)JFCUtils.decodePrimaryKey(pkey));
            p.request.setAttribute("jfcErrorHttpStatus", (Object)HttpStatus.NOT_FOUND);
            return null;
        }
        E entity = op;
        Ep entityp = this.getPHelper().s2p(entity, p, 2);
        p.request.setAttribute(this.getEntityRequestName(), entity);
        p.request.setAttribute(this.getPRequestName(), entityp);
        return entity;
    }

    private boolean isReloadEntity(ActionParameter p) {
        if (p.errors.sizeJfcerror() > 0) {
            return false;
        }
        if (p.action == null || !p.action.equals("Send")) {
            return false;
        }
        String reloadEntity = p.request.getHeader("x-wagby-reload-entity");
        return Boolean.parseBoolean(reloadEntity);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        Boolean use = (Boolean)p.request.getAttribute("__jfcrelation_use");
        if (use == null || !use.booleanValue()) {
            return super.perform_db(p);
        }
        Map<String, Object> srcmap = this.getPHelper().getParameterMap(p);
        String forward = super.perform_db(p);
        Map<String, Object> dstmap = this.getPHelper().getParameterMap(p);
        Map<String, Object> diffmap = this.getPHelper().diffMap(srcmap, dstmap);
        p.request.setAttribute("__jfcrelation_diffmap", diffmap);
        return forward;
    }

    private class AppendResponseEntityMapCallRestListener
    implements BaseController.CallRestListener {
        private AppendResponseEntityMapCallRestListener() {
        }

        @Override
        public ResponseEntity<Map<String, Object>> afterExecute(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
            ContainerBase entity1;
            ContainerBase entity = (ContainerBase)request.getAttribute(DbUpdateController.this.getEntityRequestName());
            ActionParameter p = ((ActionParameterContainer)DbUpdateController.this.getApplicationContext().getBean("ActionParameterContainer")).get();
            String pkey = DbUpdateController.this.getPrimaryKeyAsString(entity, p);
            if (DbUpdateController.this.isReloadEntity(p) && (entity1 = DbUpdateController.this.reloadEntity(p, pkey)) != null) {
                entity = entity1;
            }
            map.put("entity", entity);
            map.put("entityp", request.getAttribute(DbUpdateController.this.getPRequestName()));
            map.put("pkey", pkey);
            return null;
        }
    }
}

