/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.FilenameList;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.controller.DbShowListBaseController;
import jp.jasminesoft.jfc.core.util.PageLockUtils;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.error.Jfcinfo;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.PresentationBase;
import jp.jasminesoft.util.MultiPartForm;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class DbUpdateListBaseController<T extends ContainerBase<T>, EC, PK extends Serializable>
extends DbShowListBaseController<T, EC, PK> {
    public static final String LockobjlistAppmapKeyHeader = "__jfc_lockobjectlist_";
    private static final Logger logger = LogManager.getLogger(DbUpdateListBaseController.class);

    @Override
    public String getScreenType() {
        return "updateList";
    }

    @Override
    public boolean isReleasePageLock(ActionParameter p) {
        return false;
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        if (p.action == null || p.action.length() == 0) {
            FinderContext finderContext = this.getFinderContext();
            if (finderContext.isProcess()) {
                return CommandType.Refresh;
            }
        } else {
            if (p.action != null && p.action.startsWith("ULExecute")) {
                return CommandType.UpdateListExecute;
            }
            if (p.action != null && p.action.startsWith("ULCancel")) {
                return CommandType.UpdateListCancel;
            }
            if (p.action != null && p.action.startsWith("ULInsert")) {
                return CommandType.UpdateListInsert;
            }
            if (p.action != null && p.action.startsWith("ULCopy")) {
                return CommandType.UpdateListCopy;
            }
            if (p.action != null && p.action.startsWith("FileUpload")) {
                return CommandType.FileUpload;
            }
        }
        return super.getCommand(p);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String appmapkey = this.getLockObjectListWrapperAppmapName();
        this.appendReleaseAppMapKey(p.request, appmapkey);
        return super.perform_db(p);
    }

    @Override
    protected void callDoSearch(ActionParameter dp, int current, String sort_key) throws SecurityException {
        if (sort_key == null) {
            this.setSortKey(this.getFinderContext(), sort_key);
        }
        super.callDoSearch(dp, current, sort_key);
    }

    @Override
    protected String callDoSetData(ActionParameter p, boolean isSkipDoSetData, String forward, FinderContext<EC> finderContext) throws IOException, ServletException {
        if (p.errors.sizeJfcerror() == 0 || this.forceToSetData(p)) {
            return super.callDoSetData(p, isSkipDoSetData, forward, finderContext);
        }
        if (!finderContext.isProcess()) {
            finderContext.reset();
        }
        return forward;
    }

    @Override
    protected String do_others(ActionParameter p, String forward) throws IOException, ServletException {
        if (!super.isClientSessionIdValid(p)) {
            if (this.isNewLogon(p.request)) {
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.session.expired.update", p.locale));
                return "logon.afterLogon";
            }
            logger.log(LogCodeManager.getPriority(LogCode.JFC00102), LogCodeManager.getMessage(LogCode.JFC00102, p.user, new String[0]));
            throw new SecurityException();
        }
        if (p.cmd == CommandType.UpdateListExecute) {
            forward = this.do_update(p);
        } else if (p.cmd == CommandType.UpdateListCancel) {
            forward = this.do_cancel(p);
        } else if (p.cmd == CommandType.UpdateListInsert) {
            this.do_insert(p);
        } else if (p.cmd == CommandType.UpdateListCopy) {
            this.do_copy(p);
        } else {
            forward = super.do_others(p, forward);
        }
        return forward;
    }

    public String do_update(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public String do_cancel(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    public void do_insert(ActionParameter p) throws IOException, ServletException {
    }

    public void do_copy(ActionParameter p) throws IOException, ServletException {
    }

    @Override
    public String do_fileUpload(ActionParameter p) throws IOException {
        FilenameList filenamelist;
        MultiPartForm multi = (MultiPartForm)p.request.getAttribute("__jfc_multi");
        if (multi != null && multi.isMultipartContent(p.request)) {
            filenamelist = (FilenameList)p.pageMap.get("__jfc_filenamelist");
            if (filenamelist == null) {
                filenamelist = FilenameList.create(this.getModelId());
                p.pageMap.put("__jfc_filenamelist", filenamelist);
            }
        } else {
            return null;
        }
        Map<String, Object[]> srcfilenamemap = filenamelist.addSendFilename(p, multi);
        p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
        if (p.errors.sizeJfcerror() > 0) {
            String msg = p.errors.getJfcerror(0).getContent();
            if (this.isRest(p.request)) {
                p.request.setAttribute("jfcErrorHttpStatus", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("message", msg);
                p.request.setAttribute(this.getClass() + "_jsonret", map);
            } else {
                p.response.sendError(500, msg);
            }
            return null;
        }
        if (this.isRest(p.request)) {
            p.request.setAttribute(this.getClass() + "_jsonret", filenamelist.getSrcFilenameJsonObj(srcfilenamemap.keySet()));
            return null;
        }
        p.response.setContentType("application/json");
        p.response.setCharacterEncoding("UTF-8");
        String jsonstr = filenamelist.getSrcFilenameJson(srcfilenamemap.keySet());
        p.response.getOutputStream().write(jsonstr.getBytes("UTF-8"));
        return null;
    }

    protected LockObject lock(ActionParameter p, Object primarykey) {
        LockManager lman = LockManagerFactory.getLockManager(p);
        LockObject lo = this.createLockObject(p, lman, primarykey);
        LockObjectListWrapper wrapper = this.getLockObjectListWrapper(p);
        LockObject _lo = lman.addLockObject(lo);
        if (_lo == null) {
            logger.debug(this.getLogHeader(p) + lo + " LockManager locks the object successfully.");
            wrapper.add(lo);
        } else if (_lo.equals(lo)) {
            logger.debug(this.getLogHeader(p) + lo + " LockManager has already locked the same key.");
        } else {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00069), LogCodeManager.getMessage(LogCode.JFC00069, p.user, lo.toString()));
            logger.debug("_lo (locked object) is " + _lo);
            return null;
        }
        return lo;
    }

    private String getLockObjectListWrapperAppmapName() {
        return LockobjlistAppmapKeyHeader + this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockObjectListWrapper getLockObjectListWrapper(ActionParameter p) {
        LockObjectListWrapper wrapper;
        String lockobjectlist_key = this.getLockObjectListWrapperAppmapName();
        Map<String, Object> map = p.appMap;
        synchronized (map) {
            wrapper = (LockObjectListWrapper)p.appMap.get(lockobjectlist_key);
            if (wrapper == null) {
                wrapper = new LockObjectListWrapper(p);
                p.appMap.put(lockobjectlist_key, wrapper);
            }
        }
        return wrapper;
    }

    protected void addLockObjectList(ActionParameter p, List<LockObject> list) {
        LockObjectListWrapper wrapper = this.getLockObjectListWrapper(p);
        wrapper.addAll(list);
    }

    protected void releaseLockOne(ActionParameter p, LockObject lo) {
        String lockobjectlist_key = this.getLockObjectListWrapperAppmapName();
        LockObjectListWrapper wrapper = (LockObjectListWrapper)p.appMap.get(lockobjectlist_key);
        if (wrapper != null) {
            wrapper.releaseOne(lo);
        }
    }

    protected void releaseLockAll(ActionParameter p) {
        String lockobjectlist_key = LockobjlistAppmapKeyHeader + this.getStatus();
        LockObjectListWrapper wrapper = (LockObjectListWrapper)p.appMap.remove(lockobjectlist_key);
        if (wrapper != null) {
            wrapper.release();
        }
        PageLockUtils.releaseAll(p);
    }

    public LockObject createLockObject(ActionParameter p, LockManager lman, Object primarykey) {
        String modelname = this.registLockModel(p);
        if (modelname != null && primarykey != null) {
            String sessionid = p.request.getSession().getId();
            LockObject lo = lman.createLockObject(modelname, primarykey, sessionid, p);
            logger.debug(this.getLogHeader(p) + "lo is " + lo);
            return lo;
        }
        String username = "";
        if (p.user != null) {
            username = p.user.getUsername();
        }
        Object[] ep = new Object[]{username};
        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
        return null;
    }

    public String registLockModel(ActionParameter p) {
        return null;
    }

    protected void putDoUpdateStatus(ActionParameter p, DoUpdateStatus status) {
        p.request.setAttribute(this.getStatus() + "_DoUpdateStatus", (Object)status);
    }

    public void successTransaction(ActionParameter p) {
        this.releaseLockAll(p);
        DoUpdateStatus status = (DoUpdateStatus)p.request.getAttribute(this.getStatus() + "_DoUpdateStatus");
        Object[] o = status.getMessageOptions();
        Jfcinfo info = this.getJFCErrorManager().getJfcinfo("info.updatelist.execute_message", o, p.locale);
        p.errors.addJfcinfo(info);
    }

    protected DoUpdateStatus updateTransaction(final ActionParameter p) {
        TransactionTemplate requiredTransactionTemplate = this.getRequiredTransactionTemplate();
        if (requiredTransactionTemplate == null) {
            return this.updateInTransaction(p);
        }
        return (DoUpdateStatus)requiredTransactionTemplate.execute((TransactionCallback)new TransactionCallback<DoUpdateStatus>(){

            public DoUpdateStatus doInTransaction(TransactionStatus status) {
                DbUpdateListBaseController.this.callScriptUpdateTransactionStart(p, status);
                DoUpdateStatus dustatus = DbUpdateListBaseController.this.updateInTransaction(p);
                DbUpdateListBaseController.this.putDoUpdateStatus(p, dustatus);
                DbUpdateListBaseController.this.callScriptUpdateTransactionEnd(p, status);
                if (p.errors.sizeJfcerror() > 0) {
                    status.setRollbackOnly();
                }
                if (dustatus.getAllerrordatanum() > 0) {
                    status.setRollbackOnly();
                }
                return dustatus;
            }
        });
    }

    protected TransactionTemplate getRequiredTransactionTemplate() {
        return null;
    }

    protected DoUpdateStatus updateInTransaction(ActionParameter p) {
        return new DoUpdateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ULP extends PresentationBase<ULP>> ULP callScriptSetUpdateUlp(ActionParameter p, T[] array, List<T> datas, List<T> datasrc, ULP _listp) {
        try {
            p.request.setAttribute("__script_setUpdateUlp_Ulp", _listp);
            p.request.setAttribute("__script_setUpdateUlp_EntityArray", array);
            p.request.setAttribute("__script_setUpdateUlp_EntityDataArray", datas);
            p.request.setAttribute("__script_setUpdateUlp_EntityDataArraySource", datasrc);
            ScriptCodeRunner runner = new ScriptCodeRunner(this.getModelId());
            String _status = this.getScriptStatus(this.getModelId());
            _status = StringUtil.capFirst((String)_status);
            runner.process(_status, "SetUpdateUlp", p);
            PresentationBase _listp2 = (PresentationBase)p.request.getAttribute("__script_setUpdateUlp_Ulp");
            _listp = _listp2;
        }
        finally {
            p.request.removeAttribute("__script_setUpdateUlp_Ulp");
            p.request.removeAttribute("__script_setUpdateUlp_EntityArray");
            p.request.removeAttribute("__script_setUpdateUlp_EntityDataArray");
            p.request.removeAttribute("__script_setUpdateUlp_EntityDataArraySource");
        }
        return _listp;
    }

    public abstract int getUpdateListDatas(ActionParameter var1, List<T> var2);

    public static class DoUpdateStatus {
        public int lockerrordatanum = 0;
        public int inputerrordatanum = 0;
        public int dberrordatanum = 0;
        public int updatedatanum = 0;
        public int insertdatanum = 0;
        public int copydatanum = 0;
        public int deletedatanum = 0;
        public String desc;

        public int getAllupdatedatanum() {
            int allupdatedatanum = this.updatedatanum + this.insertdatanum + this.copydatanum + this.deletedatanum;
            return allupdatedatanum;
        }

        public int getAllerrordatanum() {
            int allerrordatanum = this.lockerrordatanum + this.inputerrordatanum + this.dberrordatanum;
            return allerrordatanum;
        }

        public boolean isError() {
            boolean isError = this.getAllerrordatanum() > 0;
            return isError;
        }

        public Object[] getMessageOptions() {
            Object[] o = new Object[]{this.updatedatanum, this.insertdatanum, this.copydatanum, this.deletedatanum, this.lockerrordatanum, this.inputerrordatanum, this.dberrordatanum, this.getAllupdatedatanum(), this.getAllerrordatanum(), this.desc};
            return o;
        }
    }

    private static class LockObjectListWrapper
    implements Releasable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Logger logger = LogManager.getLogger(LockObjectListWrapper.class);
        private LockManager lman;
        private Set<LockObject> set;

        LockObjectListWrapper(ActionParameter p) {
            this.lman = LockManagerFactory.getLockManager(p);
            this.set = new HashSet<LockObject>();
        }

        public synchronized void add(LockObject lo) {
            this.set.add(lo);
        }

        public synchronized void addAll(List<LockObject> lolist) {
            this.set.addAll(lolist);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseOne(LockObject lo) {
            LockObjectListWrapper lockObjectListWrapper = this;
            synchronized (lockObjectListWrapper) {
                this.set.remove(lo);
            }
            this.lman.releaseLockObject(lo);
        }

        @Override
        public synchronized void release() {
            Iterator<LockObject> it = this.set.iterator();
            while (it.hasNext()) {
                LockObject lo = it.next();
                it.remove();
                boolean b = this.lman.releaseLockObject(lo);
                logger.debug(lo + " release lock. " + b);
            }
        }
    }
}

