/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.ConditionHelper;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.DbUpdateListBaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.controller.ResultBeanWrapper;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ConditionPresentationBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.UpdateListPresentation;
import jp.jasminesoft.jfc.model.UpdateListPresentationItem;
import jp.jasminesoft.util.MultiPartForm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class DbUpdateListController<E extends ContainerBase<E>, EC, ECp extends ConditionPresentationBase<ECp>, PK extends Serializable>
extends DbUpdateListBaseController<E, EC, PK> {
    private static final Logger logger = LogManager.getLogger(DbUpdateListController.class);
    protected static final String UpdateListModeAttrName = "__jfc_updateList_mode";
    private EntityHelper<E, PK> entityHelper;
    private ConditionHelper<EC> condHelper;
    private PresentationPHelper<E, ?> ulpHelper;

    public void setEntityHelper(EntityHelper<E, PK> helper) {
        this.entityHelper = helper;
    }

    public EntityHelper<E, PK> getEntityHelper() {
        return this.entityHelper;
    }

    public void setConditionHelper(ConditionHelper<EC> helper) {
        this.condHelper = helper;
    }

    public ConditionHelper<EC> getConditionHelper() {
        return this.condHelper;
    }

    public void setUpdateListPHelper(PresentationPHelper<E, ?> ulpHelper) {
        this.ulpHelper = ulpHelper;
    }

    public PresentationPHelper<E, ?> getUpdateListPHelper() {
        return this.ulpHelper;
    }

    @Override
    protected String getConditionPRequestName() {
        return this.getModelId() + "_cp";
    }

    protected String getUlpRequestName() {
        return this.getModelId() + "_ulp";
    }

    protected String getDatasUlpRequestName() {
        return "datas_" + this.getModelId() + "_ulp";
    }

    public abstract EC newConditionModel();

    public abstract EC newConditionModel(EC var1);

    public void checkConditionForUpdateList(FinderContext<EC> finderContext, ActionParameter p) throws IllegalStateException {
        EC cond = finderContext.getCondition();
        if (cond == null) {
            throw new IllegalStateException("Child model condition is null");
        }
        if (finderContext.isBlankCondition()) {
            throw new IllegalStateException("Child model condition is empty. cond:" + cond);
        }
    }

    public List<E> find(FinderContext<EC> finderContext, ActionParameter p) {
        if (p.request.getAttribute(UpdateListModeAttrName) != null) {
            try {
                this.checkConditionForUpdateList(finderContext, p);
            }
            catch (IllegalStateException e) {
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.updatelist.child_model_condition_empty", p.locale));
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        finderContext.absorb(this.getDataBindingContext(p));
        return this.getEntityService().find(finderContext);
    }

    public PK getPrimarykey(String pkey, ActionParameter p) {
        return this.getEntityHelper().getPrimarykey(pkey);
    }

    public String getJfcdelete(String key, ActionParameter p) {
        MultiPartForm multi = (MultiPartForm)p.pageMap.get("__jfc_multi");
        if (multi != null) {
            Object[] oa = multi.getContentsList(key);
            if (oa == null || oa.length == 0) {
                return null;
            }
            Object o = oa[0];
            if (!(o instanceof String)) {
                return null;
            }
            String s = (String)o;
            if (s.equals("")) {
                return null;
            }
            return s;
        }
        Map mvmap = (Map)p.request.getAttribute("createObject_multiValueMap");
        if (mvmap != null) {
            List oa = (List)mvmap.get(key);
            if (oa == null || oa.size() == 0) {
                return null;
            }
            Object o = oa.get(0);
            if (!(o instanceof String)) {
                return null;
            }
            String s = (String)o;
            if (s.equals("")) {
                return null;
            }
            return s;
        }
        return p.request.getParameter(key);
    }

    public ResponseEntity<Map<String, Object>> beginUpdateRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Search");
        this.checkParameterInListRest(request);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> executeRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"ULExecute");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
        if (ret.getStatusCode() == HttpStatus.OK) {
            this.clearPageMap(request);
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> executeRest(HttpServletRequest request, HttpServletResponse response, MultiValueMap<String, String> params) throws IOException, ServletException {
        request.setAttribute("createObject_multiValueMap", params);
        request.setAttribute("action", (Object)"ULExecute");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
        if (ret.getStatusCode() == HttpStatus.OK) {
            this.clearPageMap(request);
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> cancelRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"ULCancel");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
        if (ret.getStatusCode() == HttpStatus.OK) {
            this.clearPageMap(request);
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> refreshRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Refresh");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> insertRest(int index, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String actionname = "ULInsert_";
        if (index != 0) {
            actionname = actionname + index;
        }
        request.setAttribute("action", (Object)actionname);
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> copyRest(int index, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)("ULCopy_" + index));
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> nextRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Next");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> prevRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Prev");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> firstRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"First");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> lastRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Last");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> jumpRest(int page, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)("Jump_" + page));
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<?> putFileRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"FileUpload");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        Object jsonret = request.getAttribute(this.getClass() + "_jsonret");
        if (jsonret != null) {
            return new ResponseEntity(jsonret, (MultiValueMap)ret.getHeaders(), ret.getStatusCode());
        }
        return ret;
    }

    public List<Map<String, Object>> getGridColumns(HttpServletRequest request, Map<String, Object> map) {
        return this.ulpHelper.getGridColumns(request, map);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        Boolean use = (Boolean)p.request.getAttribute("__jfcrelation_use");
        if (use == null || !use.booleanValue()) {
            return super.perform_db(p);
        }
        Map<String, Object> srcmap = this.getUpdateListPHelper().getParameterMap(p);
        String forward = super.perform_db(p);
        Map<String, Object> dstmap = this.getUpdateListPHelper().getParameterMap(p);
        Map<String, Object> diffmap = this.getUpdateListPHelper().diffMap(srcmap, dstmap);
        p.request.setAttribute("__jfcrelation_diffmap", diffmap);
        return forward;
    }

    @Override
    public int getUpdateListDatas(ActionParameter p, List<E> entityary) {
        FinderContext finderContext = this.getFinderContext();
        if (!finderContext.isNextPage() && !finderContext.isPrevPage()) {
            return this.getUpdateListDatas1(p, entityary);
        }
        return this.getUpdateListDatas2(p, entityary);
    }

    private int getUpdateListDatas1(ActionParameter p, List<E> entityary) {
        logger.debug("getUpdateListDatas1");
        int cmodelerrorcnt = 0;
        List _datas = (List)p.request.getAttribute(this.getDatasUlpRequestName());
        if (_datas == null) {
            return cmodelerrorcnt;
        }
        UpdateListPresentation _listp = (UpdateListPresentation)p.request.getAttribute(this.getUlpRequestName());
        for (int i = 0; i < _listp.sizeItem(); ++i) {
            Object updateitem = _listp.getItem(i);
            if (updateitem.getJfcdelete()) continue;
            if (updateitem.sizeJfcerror() == 0) {
                entityary.add(_datas.get(i));
                continue;
            }
            ++cmodelerrorcnt;
        }
        return cmodelerrorcnt;
    }

    protected E newEntityInstance(E entity) {
        try {
            Constructor<?> constructor = entity.getClass().getConstructor(entity.getClass());
            ContainerBase newentity = (ContainerBase)constructor.newInstance(entity);
            return (E)newentity;
        }
        catch (NoSuchMethodException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private int getUpdateListDatas2(ActionParameter p, List<E> entityary) {
        HashMap deleteMap;
        HashMap insertSrcMap;
        HashMap insertMap;
        HashMap updateSrcMap;
        logger.debug("getUpdateListDatas2");
        FinderContext finderContext2 = new FinderContext(this.getFinderContext());
        finderContext2.setPageSize(Integer.MAX_VALUE);
        finderContext2.setFirstResult(0);
        List<E> coll = this.find(finderContext2, p);
        HashMap updateMap = (HashMap)p.pageMap.get("update_" + this.getUlpRequestName());
        if (updateMap == null) {
            updateMap = new HashMap();
        }
        if ((updateSrcMap = (HashMap)p.pageMap.get("update_src_" + this.getUlpRequestName())) == null) {
            updateSrcMap = new HashMap();
        }
        if ((insertMap = (HashMap)p.pageMap.get("insert_" + this.getUlpRequestName())) == null) {
            insertMap = new HashMap();
        }
        if ((insertSrcMap = (HashMap)p.pageMap.get("insert_src_" + this.getUlpRequestName())) == null) {
            insertSrcMap = new HashMap();
        }
        if ((deleteMap = (HashMap)p.pageMap.get("delete_" + this.getUlpRequestName())) == null) {
            deleteMap = new HashMap();
        }
        EntityHelper<ContainerBase, PK> shelper = this.getEntityHelper();
        Set<String> _targetItemSet = null;
        int cmodelerrorcnt = 0;
        HashSet insertPkeySet = new HashSet(insertMap.keySet());
        List items = (List)insertMap.get(null);
        if (items != null) {
            Object pkey = null;
            List insertsrclist = (List)insertSrcMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist);
            insertPkeySet.remove(pkey);
        }
        for (ContainerBase entity : coll) {
            String pkey = shelper.getPrimarykeyAsString(entity, p);
            if (!deleteMap.containsKey(pkey)) {
                UpdateListPresentationItem updateitem = (UpdateListPresentationItem)updateMap.get(pkey);
                if (updateitem != null) {
                    ContainerBase entity2 = (ContainerBase)updateSrcMap.get(pkey);
                    cmodelerrorcnt += this.addEntityForUpdate(p, entityary, _targetItemSet, updateitem, entity2);
                } else {
                    entityary.add(this.newEntityInstance(entity));
                }
            }
            if ((items = (List)insertMap.get(pkey)) == null) continue;
            List insertsrclist = (List)insertSrcMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist);
            insertPkeySet.remove(pkey);
        }
        for (String pkey : insertPkeySet) {
            List insertsrclist = (List)insertSrcMap.get(pkey);
            items = (List)insertMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist);
        }
        return cmodelerrorcnt;
    }

    protected int addEntityForUpdate(ActionParameter p, List<E> entityary, Set<String> _targetItemSet, UpdateListPresentationItem updateitem, E entity) {
        if (updateitem.sizeJfcerror() != 0) {
            return 1;
        }
        if (updateitem.getJfcdelete()) {
            logger.warn("nothing deleteMap, but jfcdelete is true. " + updateitem);
            return 0;
        }
        PresentationPHelper<E, ?> ulphelper = this.getUpdateListPHelper();
        E newobj = this.newEntityInstance(entity);
        ulphelper.p2s(updateitem, p, newobj, _targetItemSet);
        entityary.add(newobj);
        return 0;
    }

    protected int addEntityForInsert(ActionParameter p, List<E> entityary, Set<String> _targetItemSet, List<UpdateListPresentationItem> items, List<E> insertsrclist) {
        PresentationPHelper<E, ?> ulphelper = this.getUpdateListPHelper();
        int cmodelerrorcnt = 0;
        for (int i = 0; i < items.size(); ++i) {
            UpdateListPresentationItem updateitem = items.get(i);
            if (updateitem.sizeJfcerror() != 0) {
                ++cmodelerrorcnt;
                continue;
            }
            if (updateitem.getJfcdelete()) continue;
            ContainerBase entity = (ContainerBase)insertsrclist.get(i);
            ContainerBase newobj = this.newEntityInstance(entity);
            ulphelper.p2s(updateitem, p, newobj, _targetItemSet);
            entityary.add(newobj);
        }
        return cmodelerrorcnt;
    }

    private class AppendResponseEntityMapCallRestListener
    implements BaseController.CallRestListener {
        private AppendResponseEntityMapCallRestListener() {
        }

        @Override
        public ResponseEntity<Map<String, Object>> afterExecute(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
            ConditionPresentationBase condp = (ConditionPresentationBase)request.getAttribute(DbUpdateListController.this.getConditionPRequestName());
            if (condp != null) {
                FinderContext finderContext = DbUpdateListController.this.getFinderContext();
                int pagesize = finderContext.getPageSize();
                condp.setPagesizejshparam(pagesize);
                int firstresult = finderContext.getFirstResult();
                condp.setFirstresultjshparam(firstresult);
                String sortkey = (String)request.getAttribute("__jfc_rest_sortkey");
                if (sortkey == null) {
                    HttpSession session = request.getSession();
                    sortkey = (String)session.getAttribute(DbUpdateListController.this.getSortKeyName());
                }
                condp.setSortkeyjshparam(sortkey);
            }
            map.put("conditionp", condp);
            map.put("listulp", request.getAttribute(DbUpdateListController.this.getUlpRequestName()));
            map.put("entity", request.getAttribute(DbUpdateListController.this.getDatasUlpRequestName()));
            FinderContextResultBeanWrapper rbean = DbUpdateListController.this.getFinderContextResultBeanWrapper(request);
            map.put("result", new ResultBeanWrapper(rbean));
            map.put("total", rbean.getSize());
            List<Map<String, Object>> gridColumns = DbUpdateListController.this.getGridColumns(request, map);
            if (gridColumns != null) {
                map.put("gridColumns", gridColumns);
            }
            return null;
        }
    }
}

