/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.error.Jfcerrors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbUploadUpdateBaseController<E>
extends DbBaseController<E> {
    private static final Logger logger = LogManager.getLogger((String)DbUploadUpdateBaseController.class.getName());
    public static final String LockStatusAttribute = "__jfc_DbUploadUpdateAction_lock_status";
    public static final String ProcessStatusAttribute = "jfc_DbUploadUpdateAction_process_status";
    public static final String ProcessMonitorAttribute = "jfc_DbUploadUpdateAction_process_monitor";
    public static final String ProcessJfcerrorsAttribute = "__jfc_DbUploadUpdateAction_process_jfcerrors";

    @Override
    public String getScreenType() {
        return "uploadUpdate";
    }

    private DbUploadUpdateRunnableMonitor getDbUploadUpdateRunnableMonitor(ActionParameter p) {
        DbUploadUpdateRunnableMonitorManager manager = DbUploadUpdateRunnableMonitorManager.getInstance();
        DbUploadUpdateRunnableMonitor monitor = manager.getMonitor(p, this.getStatus());
        return monitor;
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.referrer == null) {
            return CommandType.ShowStatus;
        }
        if (p.action != null && p.action.startsWith("Status")) {
            return CommandType.ShowStatus;
        }
        if (p.action != null && p.action.startsWith("Upload")) {
            return CommandType.Upload;
        }
        if (p.action != null && p.action.startsWith("Stop")) {
            return CommandType.Stop;
        }
        if (p.action != null && p.action.startsWith("RemoveStatus")) {
            return CommandType.RemoveStatus;
        }
        if (this.getExecuteMethod(p.action) != null) {
            return CommandType.None;
        }
        return CommandType.ShowStatus;
    }

    @Override
    public void after_perform_db(ActionParameter p) throws IOException, ServletException {
        HttpServletRequest request = p.request;
        HttpSession session = request.getSession();
        String locale = (String)session.getAttribute("__jfc_locale");
        request.setAttribute("process_status_message", (Object)"");
        request.setAttribute("process_status_message1", (Object)"");
        session.removeAttribute("processFilePath");
        session.removeAttribute("processFileName");
        session.removeAttribute("errorFilePath");
        session.removeAttribute("errorFileName");
        DbUploadUpdateRunnableMonitor monitor = (DbUploadUpdateRunnableMonitor)request.getAttribute(ProcessMonitorAttribute);
        if (monitor != null) {
            int status = monitor.getStatus();
            Object[] ep = new Object[]{monitor.getProcessCount(), monitor.getInsertProcessCount(), monitor.getUpdateProcessCount(), monitor.getDeleteProcessCount(), monitor.getFailedProcessCount(), monitor.getStartDate(), monitor.getEndDate(), monitor.getUploadFilename()};
            if (status == 0) {
                request.setAttribute("process_status_message", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.ready", locale));
                request.setAttribute("process_status_message1", (Object)"");
            } else if (status == 3) {
                request.setAttribute("process_status_message", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.running", ep, locale));
                request.setAttribute("process_status_message1", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.startmsg", ep, locale));
            } else if (status == 2) {
                request.setAttribute("process_status_message", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.stopping", ep, locale));
                request.setAttribute("process_status_message1", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.startmsg", ep, locale));
            } else if (status == 4) {
                request.setAttribute("process_status_message", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.stop", ep, locale));
                request.setAttribute("process_status_message1", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.endmsg", ep, locale));
            } else if (status == 1) {
                request.setAttribute("process_status_message", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.finish", ep, locale));
                request.setAttribute("process_status_message1", (Object)JFCUtils.getRValue("__jfc_common.uploadupdate.endmsg", ep, locale));
            }
            File file = monitor.getProcessFile();
            if (file != null) {
                session.setAttribute("processFilePath", (Object)file.toString());
                session.setAttribute("processFileName", (Object)file.getName());
                session.setAttribute("__jfc_DownloadFileController_disableCheckFile_processFileName", (Object)Boolean.TRUE);
            }
            if ((file = monitor.getErrorFile()) != null) {
                session.setAttribute("errorFilePath", (Object)file.toString());
                session.setAttribute("errorFileName", (Object)file.getName());
                session.setAttribute("__jfc_DownloadFileController_disableCheckFile_errorFileName", (Object)Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        DbUploadUpdateRunnableMonitor monitor;
        boolean beginUpload;
        String forward;
        LockObject lo;
        LockManager lman;
        boolean isLockModel;
        block51: {
            isLockModel = this.isLockModel(p);
            lman = LockManagerFactory.getLockManager(p);
            lo = null;
            if (isLockModel) {
                lo = this.createLockObject(p, lman);
            }
            forward = null;
            this.setCommandToActionParameter(p);
            boolean defaultIsReleaseLock = false;
            beginUpload = false;
            try {
                DbUploadUpdateRunnableMonitorManager manager;
                p.request.removeAttribute("isReleaseLock");
                if (p.cmd == CommandType.UserDefined) {
                    logger.info(this.getLogHeader(p, p.action));
                    p.o = this.retrieveData(p);
                    forward = this.do_original(p);
                    break block51;
                }
                if (p.cmd == CommandType.ShowStatus || p.cmd == CommandType.ChangeSidebar) {
                    logger.info(this.getLogHeader(p));
                    LogonStatusManager lsman = (LogonStatusManager)this.getApplicationContext().getBean("LogonStatusManager", LogonStatusManager.class);
                    if ("juser".equals(this.getModelId()) && !lsman.checkMaxAccount(p.user)) {
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.logon.license.max_account.over", p.locale));
                    }
                    break block51;
                }
                if (p.cmd == CommandType.Upload) {
                    logger.info(this.getLogHeader(p));
                    if (lo != null) {
                        LockObject _lo = lman.addLockObject(lo);
                        if (_lo == null) {
                            logger.debug(this.getLogHeader(p) + lo + " LockManager locks the object successfully.");
                        } else {
                            logger.log(LogCodeManager.getPriority(LogCode.JFC00069), LogCodeManager.getMessage(LogCode.JFC00069, p.user, lo.toString()));
                            logger.debug("_lo (locked object) is " + _lo);
                            Object[] ep = new Object[]{_lo.getUsername()};
                            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.lock", ep, p.locale));
                            forward = this.do_lockerror(p);
                            lo = null;
                        }
                    } else {
                        logger.debug("locked object is null.");
                    }
                    logger.debug(this.getLogHeader(p) + "lman is " + lman);
                    if (isLockModel && lo == null) break block51;
                    defaultIsReleaseLock = true;
                    manager = DbUploadUpdateRunnableMonitorManager.getInstance();
                    if (!manager.checkMonitor(p, this.getStatus())) {
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.running", p.locale));
                        break block51;
                    }
                    try {
                        DbUploadUpdateRunnableMonitor monitor2 = this.do_uploadData(p);
                        manager.addMonitor(p, this.getStatus(), this.registLockModel(p), isLockModel, monitor2);
                        if (p.errors.sizeJfcerror() == 0) {
                            beginUpload = true;
                            defaultIsReleaseLock = false;
                        }
                        break block51;
                    }
                    catch (SecurityException e) {
                        logger.warn(this.getLogHeader(p) + e.getMessage());
                        throw e;
                    }
                    finally {
                        manager.uncheckMonitor(p, this.getStatus());
                    }
                }
                if (p.cmd == CommandType.Stop) {
                    logger.info(this.getLogHeader(p));
                    this.do_stop(p);
                } else if (p.cmd == CommandType.RemoveStatus) {
                    logger.info(this.getLogHeader(p));
                    manager = DbUploadUpdateRunnableMonitorManager.getInstance();
                    try {
                        manager.removeMonitor(p, this.getStatus());
                    }
                    catch (IllegalStateException e) {
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.dbaccess.running", p.locale));
                    }
                } else {
                    logger.info(this.getLogHeader(p, p.action));
                    String forward1 = this.execExecuteMethod(p, null);
                    if (forward1 != null && forward1.equals("None")) {
                        String url = p.request.getParameter("forward");
                        if (url != null && url.length() > 0) {
                            forward = url;
                        }
                    } else {
                        forward = forward1;
                    }
                }
            }
            finally {
                Boolean isReleaseLock = (Boolean)p.request.getAttribute("isReleaseLock");
                if (lo != null) {
                    if (isReleaseLock != null) {
                        if (isReleaseLock.booleanValue()) {
                            lman.releaseLockObject(lo);
                            logger.debug(this.getLogHeader(p) + lo + " release lock.");
                        }
                    } else if (defaultIsReleaseLock) {
                        lman.releaseLockObject(lo);
                        logger.debug(this.getLogHeader(p) + lo + " release lock.");
                    }
                }
            }
        }
        this.do_status(p);
        if (!isLockModel) {
            if (beginUpload) {
                p.request.setAttribute(LockStatusAttribute, (Object)"LockedBegin");
            } else {
                monitor = this.getDbUploadUpdateRunnableMonitor(p);
                if (monitor == null) {
                    p.request.setAttribute(LockStatusAttribute, (Object)"Wait");
                } else if (monitor.getStatus() == 4 || monitor.getStatus() == 1) {
                    p.request.setAttribute(LockStatusAttribute, (Object)"Wait");
                } else {
                    p.request.setAttribute(LockStatusAttribute, (Object)"LockedOwn");
                }
            }
        } else if (lo != null && !lman.contains(lo)) {
            p.request.setAttribute(LockStatusAttribute, (Object)"Wait");
        } else if (beginUpload) {
            p.request.setAttribute(LockStatusAttribute, (Object)"LockedBegin");
        } else {
            monitor = this.getDbUploadUpdateRunnableMonitor(p);
            if (monitor == null) {
                p.request.setAttribute(LockStatusAttribute, (Object)"LockedOther");
            } else if (monitor.getStatus() == 4 || monitor.getStatus() == 1) {
                p.request.setAttribute(LockStatusAttribute, (Object)"LockedOther");
            } else {
                p.request.setAttribute(LockStatusAttribute, (Object)"LockedOwn");
            }
        }
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        String endLogMsg = this.endLog(p);
        if (endLogMsg != null) {
            logger.info(endLogMsg);
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            logger.debug("forward is null.");
            return this.getInputForward(p);
        }
        return forward;
    }

    public DbUploadUpdateRunnableMonitor do_uploadData(ActionParameter p) throws IOException, ServletException {
        return null;
    }

    public LockObject createLockObject(ActionParameter p, LockManager lman) {
        String modelname = this.registLockModel(p);
        if (modelname != null) {
            HttpSession session_ = p.request.getSession();
            String sessionid = session_.getId();
            LockObject lo = lman.createLockObjectForAll(modelname, sessionid, p.user);
            logger.debug(this.getLogHeader(p) + "lo is " + lo);
            return lo;
        }
        String username = "";
        if (p.user != null) {
            username = p.user.getUsername();
        }
        Object[] ep = new Object[]{username};
        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.parameter.invalid", ep, p.locale));
        return null;
    }

    public String registLockModel(ActionParameter p) {
        return "";
    }

    public boolean isLockModel(ActionParameter p) {
        return true;
    }

    public String do_lockerror(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }

    protected void do_stop(ActionParameter p) {
        DbUploadUpdateRunnableMonitor monitor = this.getDbUploadUpdateRunnableMonitor(p);
        if (monitor != null) {
            monitor.stop();
        }
    }

    protected void do_status(ActionParameter p) {
        DbUploadUpdateRunnableMonitor monitor = this.getDbUploadUpdateRunnableMonitor(p);
        p.request.setAttribute(ProcessMonitorAttribute, (Object)monitor);
        String status = monitor != null ? monitor.getStatusString() : "Nothing";
        p.request.setAttribute(ProcessStatusAttribute, (Object)status);
        Jfcerrors errors = monitor != null && this.isShowMonitorErrorMessage(p, monitor) ? monitor.getJfcerrors() : new Jfcerrors();
        p.request.setAttribute(ProcessJfcerrorsAttribute, (Object)errors);
    }

    protected boolean isShowMonitorErrorMessage(ActionParameter p, DbUploadUpdateRunnableMonitor monitor) {
        return true;
    }

    public static String getStatusString(int status) {
        if (status == 0) {
            return "NotExecute";
        }
        if (status == 1) {
            return "End";
        }
        if (status == 2) {
            return "Stopping";
        }
        if (status == 3) {
            return "Processing";
        }
        if (status == 4) {
            return "Aborted";
        }
        return "Unknown";
    }

    protected void getCommand_first_hook(ActionParameter p) {
    }

    protected void getCommand_finish_hook(ActionParameter p) {
    }

    protected void registLockModel_first_hook(ActionParameter p) {
    }

    protected void registLockModel_finish_hook(ActionParameter p) {
    }

    protected void do_preprocess_first_hook(ActionParameter p) {
    }

    protected void do_preprocess_finish_hook(ActionParameter p) {
    }

    protected void do_uploadData_first_hook(ActionParameter p) {
    }

    protected void do_uploadData_after_preprocess_hook(ActionParameter p) {
    }

    protected void do_uploadData_before_getMultiPartForm_hook(ActionParameter p) {
    }

    protected void do_uploadData_after_getMultiPartForm_hook(ActionParameter p) {
    }

    protected void do_uploadData_before_getFile_hook(ActionParameter p) {
    }

    protected void do_uploadData_after_getFile_hook(File file, ActionParameter p) {
    }

    protected void do_uploadData_before_createLockObject_hook(ActionParameter p) {
    }

    protected void do_uploadData_after_createLockObject_hook(ActionParameter p) {
    }

    protected void do_uploadData_before_duplicatecheck_hook(ActionParameter p) {
    }

    protected void do_uploadData_after_duplicatecheck_hook(ActionParameter p) {
    }

    protected void do_uploadData_before_setattribute_isMultiPartFormDeleteAllFiles_hook(ActionParameter p) {
    }

    protected void do_uploadData_after_setattribute_isMultiPartFormDeleteAllFiles_hook(ActionParameter p) {
    }

    protected void do_uploadData_ready_pbean_hook(ActionParameter p) {
    }

    protected void do_uploadData_before_pbean_hook(ProcessBean pbean, ActionParameter p) {
    }

    protected void do_uploadData_after_pbean_hook(ActionParameter p) {
    }

    protected void do_uploadData_finish_pbean_hook(ActionParameter p) {
    }

    protected void do_uploadData_finish_hook(ActionParameter p) {
    }

    protected void do_status_first_hook(ActionParameter p) {
    }

    protected void do_status_do_preprocess_hook(ActionParameter p) {
    }

    protected void do_status_finish_hook(ActionParameter p) {
    }

    protected void isShowMonitorErrorMessage_first_hook(ActionParameter p) {
    }

    protected void do_lockerror_first_hook(ActionParameter p) {
    }

    protected void do_lockerror_finish_hook(ActionParameter p) {
    }
}

