/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DownloadFileController {
    private static final Logger logger = LogManager.getLogger(DownloadFileController.class);
    public static final String FILE_NOT_FOUND_URL = "fileNotFound.jsp";
    public static final String DISABLECHECKFILE_HEADER = "__jfc_DownloadFileController_disableCheckFile_";
    public static final String MODELID_HEADER = "__jfc_DownloadFileController_modelId_";
    public static final String PKEY_HEADER = "__jfc_DownloadFileController_pkey_";
    public static final String MODELITEMNAME_HEADER = "__jfc_DownloadFileController_modelitemName_";
    public static final String SCRIPTERRORMESSAGE_KEY = "__jfc_DownloadFileController_scriptErrorMessage";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="DownloadFileObjectFactory")
    private DownloadFileObjectFactory dfofactory;
    @Autowired
    private ServletContext servletContext;
    private MimetypesFileTypeMap mimetypes;
    protected static String[] PICTURE_FILE_SUFFIX_BASE = new String[]{"jpg", "jpeg", "png", "gif", "mp4"};
    protected static final Set<String> PICTURE_FILE_SUFFIX = new HashSet<String>(Arrays.asList(PICTURE_FILE_SUFFIX_BASE));
    protected static final Set<String> PICTURE_SWF_FILE_SUFFIX = new HashSet<String>(PICTURE_FILE_SUFFIX);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimetypesFileTypeMap getMimetypesFileTypeMap() {
        if (this.mimetypes != null) {
            return this.mimetypes;
        }
        InputStream istream = this.servletContext.getResourceAsStream("/WEB-INF/mime.types");
        try {
            MimetypesFileTypeMap mimetypes;
            this.mimetypes = mimetypes = new MimetypesFileTypeMap(istream);
            MimetypesFileTypeMap mimetypesFileTypeMap = mimetypes;
            return mimetypesFileTypeMap;
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                logger.debug("io exception", (Throwable)e);
            }
        }
    }

    private String getContentType(String fname) {
        MimetypesFileTypeMap mimetypes = this.getMimetypesFileTypeMap();
        String mimetype = mimetypes.getContentType(fname.toLowerCase());
        if (this.isIncludeSuffix(fname, PICTURE_SWF_FILE_SUFFIX)) {
            return mimetype;
        }
        Charset download_charset = JFCUtils.getDownloadCharset(mimetype);
        return mimetype + "; charset=" + download_charset.toString();
    }

    protected boolean isIncludeSuffix(String fname, Set<String> suffixSet) {
        int idx = fname.lastIndexOf(".");
        if (idx < 0) {
            return false;
        }
        String suffix = fname.substring(idx + 1).toLowerCase();
        return suffixSet.contains(suffix);
    }

    protected String encodeUrl(HttpServletRequest request, String url) {
        return url;
    }

    @RequestMapping(value={"/wagbyDownload"})
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        if (session == null) {
            logger.info("not logged on.");
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        String xpath = request.getParameter("path");
        if (xpath == null || xpath.length() == 0) {
            logger.info("path is null or zero.");
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        String localfilename = this.getLocalFilename(request, response, session, xpath);
        if (localfilename == null) {
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        String fnameParamValue = request.getParameter("fname");
        String fname = this.getFname(session, localfilename, fnameParamValue);
        if (request.getHeader("user-agent").indexOf("Biz/Browser") >= 0) {
            this.get2(request, response, session, xpath, localfilename, fnameParamValue, fname);
            return;
        }
        if (this.isIncludeSuffix(fname, PICTURE_SWF_FILE_SUFFIX)) {
            this.get2(request, response, session, xpath, localfilename, fnameParamValue, fname);
            return;
        }
        String encode_fname = URLEncoder.encode(fname, "UTF-8");
        request.setAttribute("encode_fname", (Object)encode_fname);
        request.setAttribute("sessionid", (Object)session.getId());
        StringBuilder params = new StringBuilder();
        params.append("?path=" + xpath);
        if (fnameParamValue != null) {
            params.append("&fname=" + fnameParamValue);
        }
        params.append("&fn=" + encode_fname);
        response.sendRedirect(this.encodeUrl(request, "wagbyDownload2.do" + params));
    }

    @RequestMapping(value={"/wagbyDownload2"})
    public void get(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        if (session == null) {
            logger.info("not logged on.");
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        String xpath = request.getParameter("path");
        if (xpath == null || xpath.length() == 0) {
            logger.info("path is null or zero.");
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        String localfilename = this.getLocalFilename(request, response, session, xpath);
        if (localfilename == null) {
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        String fnameParamValue = request.getParameter("fname");
        String fname = this.getFname(session, localfilename, fnameParamValue);
        this.get2(request, response, session, xpath, localfilename, fnameParamValue, fname);
    }

    protected void get2(HttpServletRequest request, HttpServletResponse response, HttpSession session, String xpath, String localfilename, String fnameParamValue, String fname) throws IOException, FileNotFoundException {
        long time3;
        long time2;
        if (logger.isDebugEnabled()) {
            logger.debug("localfilename=" + localfilename);
            logger.debug("dfofactory=" + this.dfofactory);
        }
        long time = System.currentTimeMillis();
        try (DownloadFileObject st = this.dfofactory.create(localfilename, request);){
            time2 = System.currentTimeMillis();
            this.get2(request, response, session, xpath, st, fnameParamValue, fname);
            time3 = System.currentTimeMillis();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("time2=" + (time2 - time) + ", time3=" + (time3 - time2) + " localfilename=" + localfilename);
        }
    }

    protected void get2(HttpServletRequest request, HttpServletResponse response, HttpSession session, String xpath, DownloadFileObject st, String fnameParamValue, String fname) throws IOException, FileNotFoundException {
        if (st == null) {
            logger.info("target file is null. path:" + xpath);
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        if (!st.canRead()) {
            logger.info("target file " + st.getDescription() + " can not read. path:" + xpath);
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        if (!this.callCheckFileScript(request, response, session, xpath, st, fnameParamValue, fname)) {
            return;
        }
        response.setHeader("Expires", this.getHTTPDate());
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, private");
        URL redirecturl = st.getRedirectUrl();
        if (redirecturl != null) {
            logger.debug("redirect download " + fname);
            response.sendRedirect(redirecturl.toString());
            return;
        }
        response.setContentLengthLong(st.length());
        response.setContentType(this.getContentType(fname));
        response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)fname, (HttpServletRequest)request, (String)"inline"));
        logger.debug("Start download " + fname);
        try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            st.write(output);
        }
        catch (ClientAbortException e) {
            logger.info("client aborted " + fname);
            if (logger.isDebugEnabled()) {
                logger.debug("client aborted " + fname, (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Failed download " + fname, (Throwable)e);
            throw e;
        }
        logger.debug("Finished download " + fname);
        if (fname != null && fname.indexOf(".") > 0 && !this.isIncludeSuffix(fname, PICTURE_FILE_SUFFIX)) {
            String userid = null;
            User user = JFCUtils.getUserInSession(session, this.applicationContext);
            if (user != null) {
                userid = user.getUsername();
            }
            if (userid == null) {
                userid = "Unknown";
            }
            logger.info("(" + userid + ") Download " + fname);
        }
    }

    protected String getLocalFilename(HttpServletRequest request, HttpServletResponse response, HttpSession session, String xpath) throws IOException {
        String filename = (String)session.getAttribute(xpath);
        if (filename == null || filename.length() == 0) {
            logger.info("filename is null or zero. path:" + xpath);
            return null;
        }
        if (File.separatorChar != '\\') {
            filename = filename.replace('\\', '/');
        }
        return filename;
    }

    protected String getFname(HttpSession session, String filename, String fnameParamValue) {
        int index2;
        String fname;
        int index1;
        String savefilename = null;
        if (fnameParamValue != null && fnameParamValue.length() > 0) {
            savefilename = (String)session.getAttribute(fnameParamValue);
        }
        if ((index1 = (fname = savefilename != null && savefilename.length() > 0 ? savefilename : new File(filename).getName()).lastIndexOf(92)) > (index2 = fname.lastIndexOf(47))) {
            if (index1 >= 0 && index1 + 1 < fname.length()) {
                fname = fname.substring(index1 + 1);
            }
        } else if (index1 < index2 && index2 >= 0 && index2 + 1 < fname.length()) {
            fname = fname.substring(index2 + 1);
        }
        return fname;
    }

    @RequestMapping(value={"/wagbyDownloadError.*"})
    public String error(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return "forward:/system/error_DownloadScript.jsp";
    }

    protected void sendRedirectScriptError(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        request.getSession().setAttribute(SCRIPTERRORMESSAGE_KEY, (Object)msg);
        response.sendRedirect(this.encodeUrl(request, "wagbyDownloadError.do"));
    }

    protected void sendRedirectFileNotFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.encodeUrl(request, FILE_NOT_FOUND_URL));
    }

    protected boolean callCheckFileScript(HttpServletRequest request, HttpServletResponse response, HttpSession session, String xpath, DownloadFileObject st, String fnameParamValue, String fname) throws IOException {
        Object disableCheckFile;
        if (fnameParamValue == null || fnameParamValue.length() == 0) {
            fnameParamValue = xpath;
        }
        if ((disableCheckFile = session.getAttribute(DISABLECHECKFILE_HEADER + fnameParamValue)) != null && ((Boolean)disableCheckFile).booleanValue()) {
            return true;
        }
        String modelId = (String)session.getAttribute(MODELID_HEADER + fnameParamValue);
        String pkey = (String)session.getAttribute(PKEY_HEADER + fnameParamValue);
        String modelitemName = (String)session.getAttribute(MODELITEMNAME_HEADER + fnameParamValue);
        if (modelId == null || pkey == null || modelitemName == null) {
            logger.info("nothing check file parameter. path:" + xpath);
            this.sendRedirectFileNotFound(request, response);
            return false;
        }
        String msg = st.checkFile(request, response, fname, modelId, pkey, modelitemName);
        if (msg != null && msg.length() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("script check error. path:" + xpath + " msg:" + msg);
            }
            this.sendRedirectScriptError(request, response, msg);
            return false;
        }
        return true;
    }

    private String getHTTPDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(new Date());
    }

    static {
        PICTURE_SWF_FILE_SUFFIX.add("swf");
    }
}

