/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GridSettingJsonContent {
    private static final Logger logger = LogManager.getLogger(GridSettingJsonContent.class);
    private JsonContentSort[] sort = null;
    private JsonContentItem[] columns = null;

    public void setSort(JsonContentSort[] sort) {
        this.sort = sort;
    }

    public JsonContentSort[] getSort() {
        return this.sort;
    }

    public void setColumns(JsonContentItem[] columns) {
        this.columns = columns;
    }

    public JsonContentItem[] getColumns() {
        return this.columns;
    }

    public List<String> getTargetitems() {
        if (this.getColumns() == null || this.getColumns().length == 0) {
            return null;
        }
        ArrayList<String> targetitems = new ArrayList<String>();
        for (JsonContentItem cmap : this.getColumns()) {
            String id = cmap.getId();
            if (id.equals("selectorField") || id.equals("buttonField")) continue;
            Boolean hidden = cmap.getHidden();
            if (logger.isDebugEnabled()) {
                logger.debug("hidden " + hidden + " id:" + id);
            }
            if (hidden != null && hidden.booleanValue()) continue;
            targetitems.add(id);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("add id " + id);
        }
        if (targetitems.size() == 0) {
            return null;
        }
        return targetitems;
    }

    public String[] getSortkeys() {
        List<String> list = this.getSortkeyList();
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public List<String> getSortkeyList() {
        if (this.sort == null || this.sort.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonContentSort s : this.sort) {
            if (StringUtils.isBlank((CharSequence)s.getProperty())) continue;
            Boolean desc = s.getDescending();
            if (desc != null && desc.booleanValue()) {
                list.add(s.getProperty() + ":DESC");
                continue;
            }
            list.add(s.getProperty());
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonContentItem {
        private String id;
        private Boolean hidden;

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setHidden(Boolean hidden) {
            this.hidden = hidden;
        }

        public Boolean getHidden() {
            return this.hidden;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonContentSort {
        private String property;
        private Boolean descending;

        public void setProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public void setDescending(Boolean descending) {
            this.descending = descending;
        }

        public Boolean getDescending() {
            return this.descending;
        }
    }
}

