/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.KickLicenseUpdator;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbFreeController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public final class LicenseUpdatorConfigController
extends DbFreeController {
    private static final String ACTION_SAVE_AND_UPDATE = "action_SaveAndUpdate";
    private static final String ACTION_SAVE = "action_Save";
    private static final Logger logger = LogManager.getLogger(LicenseUpdatorConfigController.class);

    @Override
    public String getForwardHeader() {
        return "licenseUpdatorConfig";
    }

    @Override
    @RequestMapping(value={"/licenseUpdatorConfig.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("admin", "all");
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.licenseUpdatorConfig";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), null);
    }

    private String getParameter(ActionParameter p, String name) {
        String value = p.request.getParameter(name);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public String do_free(ActionParameter p) throws IOException, ServletException, SecurityException {
        final ActionParameter dp = p;
        KickLicenseUpdator kick = new KickLicenseUpdator(new KickLicenseUpdator.PathProvider(){

            @Override
            public String getPath(String org) {
                return dp.request.getServletContext().getRealPath(org);
            }
        });
        Map<String, String> param = this.prepareParameter(p);
        p.request.setAttribute("__jfc_locale", (Object)"*");
        String foward = this.getInputForward(p);
        if (p.request.getParameter(ACTION_SAVE_AND_UPDATE) != null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90012), LogCodeManager.getMessage(LogCode.JFC90012, p.user, new String[0]));
            String result = kick.kickUpdateProcess(param, p.locale);
            if (result == null) {
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.licenseUpdator.suceededUpdatingLicensefile", (Object[])null, p));
                foward = "mainMenu";
            } else {
                logger.log(LogCodeManager.getPriority(LogCode.JFC90011), LogCodeManager.getMessage(LogCode.JFC90011, p.user, new String[0]));
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.licenseUpdator.failedUpdatingLicensefile", new Object[]{result}, p));
            }
        } else if (p.request.getParameter(ACTION_SAVE) != null) {
            String result = kick.kickSaveProcess(param, p.locale);
            if (result == null) {
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.licenseUpdator.suceededUpdatingLicensefile", (Object[])null, p));
                foward = "mainMenu";
            } else {
                logger.log(LogCodeManager.getPriority(LogCode.JFC90011), LogCodeManager.getMessage(LogCode.JFC90011, p.user, new String[0]));
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.licenseUpdator.failedUpdatingLicensefile", new Object[]{result}, p));
            }
        }
        return foward;
    }

    private Map<String, String> prepareParameter(ActionParameter p) {
        HashMap<String, String> param = new HashMap<String, String>();
        String account = this.getParameter(p, "account").trim();
        String password = this.getParameter(p, "password");
        String passwordchk = this.getParameter(p, "passwordchk");
        String licenseid = this.getParameter(p, "licenseid").trim();
        String proxyurl = this.getParameter(p, "proxyurl").trim();
        String proxyport = this.getParameter(p, "proxyport").trim();
        String proxyuser = this.getParameter(p, "proxyuser").trim();
        String proxypass = this.getParameter(p, "proxypass").trim();
        if (account.trim().length() > 0) {
            param.put("account", account);
        }
        if (this.checkPassword(p, password, passwordchk)) {
            param.put("password", password);
        }
        if (licenseid.trim().length() > 0) {
            param.put("licenseid", licenseid);
        }
        if (proxyurl.length() > 0 || param.size() > 0) {
            param.put("proxyurl", proxyurl);
        }
        if (proxyport.length() > 0 || param.size() > 0) {
            param.put("proxyport", proxyport);
        }
        if (proxyuser.length() > 0 || param.size() > 0) {
            param.put("proxyuser", proxyuser);
        }
        if (proxypass.length() > 0 || param.size() > 0) {
            param.put("proxypass", proxypass);
        }
        return param;
    }

    private boolean checkPassword(ActionParameter p, String password, String passwordchk) {
        if (password.trim().length() > 0 && password.equals(passwordchk)) {
            return true;
        }
        if (password.trim().length() > 0 && !password.equals(passwordchk)) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.licenseUpdator.notMatchPassword", (Object[])null, p));
            return false;
        }
        return false;
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }
}

