/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.JFCAppModeManager;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MaintenanceAppController
extends DbBaseController<Object> {
    private static final Logger logger = LogManager.getLogger(MaintenanceAppController.class);
    @Autowired
    private JFCAppModeManager appModeManager;

    @Override
    @RequestMapping(value={"/maintenanceApp.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.maintenance.App";
    }

    @Override
    public String getStatus() {
        return "maintenanceApp";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "maintenanceApp");
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("maintenance", "all");
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String app_mode_str = p.request.getParameter("__jfc_app_mode");
        JFCAppMode mode = JFCAppMode.valueOfIgnoreCase(app_mode_str);
        if (mode == JFCAppMode.Normal) {
            this.changeNormalMode(mode, p);
        } else if (mode != null) {
            String condition = p.request.getParameter("__condition");
            if (StringUtils.isBlank((CharSequence)condition)) {
                condition = "keep";
            }
            this.changeMode(mode, condition, p);
        }
        JFCAppMode now_mode = this.getApplicationMode();
        p.request.setAttribute("now_mode", (Object)now_mode);
        LogonStatusManager LSMAN = (LogonStatusManager)p.appctx.getBean(LogonStatusManager.class);
        p.request.setAttribute("logon_count", (Object)(LSMAN.getCount() - 1));
        return this.getInputForward(p);
    }

    private void changeMode(JFCAppMode mode, String condition, ActionParameter p) {
        boolean isEnable = true;
        if ("failed".equals(condition)) {
            int count = this.appModeManager.checkLogon(p.user.getUsername());
            if (count > 0) {
                Object[] o = new Object[]{count};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.maintenance.failed", o, p.locale));
                isEnable = false;
            }
        } else if ("logout".equals(condition)) {
            try {
                StringBuilder sb = new StringBuilder();
                this.appModeManager.logoffAll(p.user.getUsername(), sb);
                Object[] o = new Object[]{sb.toString()};
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.maintenance.forcelogout", o, p.locale));
            }
            catch (IllegalStateException e) {
                Object[] o2 = new Object[]{e.getMessage()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.maintenance.forcelogout", o2, p.locale));
                isEnable = false;
            }
        }
        if (isEnable) {
            this.appModeManager.setMode(mode, p.user.getUsername());
            logger.log(LogCodeManager.getPriority(LogCode.JFC90013), LogCodeManager.getMessage(LogCode.JFC90013, p.user, mode.toString()));
            if (mode == JFCAppMode.Maintenance) {
                p.request.setAttribute("__jfc_maintenanceMode", (Object)Boolean.TRUE);
            } else if (mode == JFCAppMode.LimitBackgroundProcessStart) {
                p.request.removeAttribute("__jfc_maintenanceMode");
            }
            p.request.setAttribute("__jfc_applicationMode", (Object)mode.toString());
        }
    }

    private void changeNormalMode(JFCAppMode mode, ActionParameter p) {
        this.appModeManager.setMode(mode, p.user.getUsername());
        logger.log(LogCodeManager.getPriority(LogCode.JFC90014), LogCodeManager.getMessage(LogCode.JFC90014, p.user, mode.toString()));
        p.request.removeAttribute("__jfc_maintenanceMode");
        p.request.setAttribute("__jfc_applicationMode", (Object)mode);
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }
}

