/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.controller.ReactAdminRestBaseController;
import jp.jasminesoft.jfc.core.util.IOUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCAbstractEntityService;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

public abstract class ReactAdminRestFileBaseController<E extends ContainerBase<E>, PK extends Serializable, RB extends FileRequestBodyBase<E>>
extends ReactAdminRestBaseController<E, PK, RB> {
    private static final Logger logger = LogManager.getLogger(ReactAdminRestFileBaseController.class);
    protected static final String FILEITEM_SUFFIX = "_jshfilename";
    @Autowired
    private ServletContext servletContext;
    @Autowired
    @Qualifier(value="DownloadFileObjectFactory")
    private DownloadFileObjectFactory dfofactory;
    private MimetypesFileTypeMap mimetypes;

    public ReactAdminRestFileBaseController(EntityMeta<E> entityMeta, EntityHelper<E, PK> entityHelper, JFCEntityService<E, PK> entityService) {
        super(entityMeta, entityHelper, entityService);
    }

    @Override
    public E detachEntity(RB requestBody, HttpServletRequest request) {
        ContainerBase entity = (ContainerBase)((FileRequestBodyBase)requestBody).getEntity();
        HashMap<String, Object> fileDataMap = new HashMap<String, Object>();
        if (((FileRequestBodyBase)requestBody).getJfcfilenames() != null) {
            for (FileData fileData : ((FileRequestBodyBase)requestBody).getJfcfilenames()) {
                fileDataMap.put(fileData.getSrc(), fileData);
            }
        }
        for (String itemname : this.getFileModelitems()) {
            FileData fileData;
            Object obj = ((FileRequestBodyBase)requestBody).getEntries().get((String)itemname + FILEITEM_SUFFIX);
            if (obj == null) continue;
            if (obj instanceof String) {
                this.keepPreviousFile(entity, itemname);
                continue;
            }
            if (!(obj instanceof Map)) {
                logger.error("Unexpected Object : " + obj);
                throw new IllegalStateException();
            }
            Map fileInfo = (Map)obj;
            String src = (String)fileInfo.get("src");
            String title = (String)fileInfo.get("title");
            if (StringUtils.isBlank((String)src) || StringUtils.isBlank((String)title) || (fileData = (FileData)fileDataMap.get(src)) == null) continue;
            try {
                String jshfilenameid = this.storeUploadedFile(src, itemname, title, fileData.data, request);
                this.writeField(entity, itemname, title);
                this.writeField(entity, (String)itemname + FILEITEM_SUFFIX, jshfilenameid);
            }
            catch (IOException ex) {
                logger.error("save file failed", (Throwable)ex);
            }
        }
        return (E)entity;
    }

    protected void keepPreviousFile(E entity, String itemname) {
        ActionParameter p = ((ActionParameterContainer)this.applicationContext.getBean("ActionParameterContainer", ActionParameterContainer.class)).get();
        JFCAbstractEntityService entityService = (JFCAbstractEntityService)StoreModelUtils.entityService(this.modelId, p);
        Object old = entityService.findById(this.entityHelper.getPrimarykey(entity));
        this.writeField(entity, itemname, this.getFileName(old, itemname));
        String jshfilename = itemname + FILEITEM_SUFFIX;
        this.writeField(entity, jshfilename, this.getFileName(old, jshfilename));
    }

    public abstract String[] getFileModelitems();

    @Override
    public Object responseEntity(HttpServletRequest request, E entity) {
        ActionParameter p = ((ActionParameterContainer)this.applicationContext.getBean("ActionParameterContainer", ActionParameterContainer.class)).get();
        String pkey = this.entityHelper.getPrimarykeyAsString(entity, p);
        entity = this.replaceJshfilenameValue(request, entity, pkey);
        return super.responseEntity(request, entity);
    }

    public E replaceJshfilenameValue(HttpServletRequest request, E entity, String id) {
        String requestUrl = request.getRequestURL().toString();
        String requestUri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String header = StringUtils.removeEnd((String)requestUrl, (String)requestUri) + contextPath + "/v3/" + this.entityMeta.table() + "/" + id + "/file/";
        for (String itemname : this.getFileModelitems()) {
            String fileName = this.getFileName(entity, itemname);
            if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)this.getFilePath(entity, itemname))) continue;
            this.writeField(entity, itemname + FILEITEM_SUFFIX, header + itemname + "/" + fileName);
        }
        return entity;
    }

    private MimetypesFileTypeMap getMimetypesFileTypeMap() {
        MimetypesFileTypeMap mimetypesFileTypeMap;
        if (this.mimetypes != null) {
            return this.mimetypes;
        }
        InputStream istream = null;
        try {
            istream = this.servletContext.getResourceAsStream("/WEB-INF/mime.types");
            mimetypesFileTypeMap = this.mimetypes = new MimetypesFileTypeMap(istream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(istream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)istream);
        return mimetypesFileTypeMap;
    }

    private String getContentType(String fname) {
        String mimetype = this.getMimetypesFileTypeMap().getContentType(fname.toLowerCase());
        return mimetype;
    }

    @GetMapping(value={"/{id}/file/{itemname}/{filename}"})
    public HttpEntity<?> getFile(@PathVariable(value="id") String id, @PathVariable(value="itemname") String itemname, @PathVariable(value="filename") String filename, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResponseEntity<Map<String, Object>> re = this.show(id, request, response);
        if (this.isErrorResponse(re)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("message", this.getErrorMessage(re));
            return new ResponseEntity(map, re.getStatusCode());
        }
        ContainerBase entity = (ContainerBase)((Map)re.getBody()).get("entity");
        if (entity == null) {
            logger.info("nothing entity " + id);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("nothing entity " + id));
        }
        String path = this.getFilePath(entity, itemname);
        if (path == null) {
            logger.info("nothing item " + itemname);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("nothing item " + itemname));
        }
        String fname = this.getFileName(entity, itemname);
        try (DownloadFileObject dfo = this.getDownloadFileObject(path, request);){
            URL redirecturl;
            response.setContentType(this.getContentType(fname));
            response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)fname, (HttpServletRequest)request, (String)"inline"));
            String cacheControl = dfo.getKeySetting().getRaCacheControl();
            if (cacheControl != null) {
                response.setHeader("Cache-Control", cacheControl);
            }
            if ((redirecturl = dfo.getRedirectUrl()) != null) {
                logger.debug("redirect download " + fname);
                response.sendRedirect(redirecturl.toString());
            } else {
                dfo.write((OutputStream)response.getOutputStream());
            }
        }
        catch (FileNotFoundException e) {
            logger.info("nothing file item " + itemname + " path " + path);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("nothing file item " + itemname + " path " + path));
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        return ResponseEntity.ok().body(null);
    }

    protected String getFilePath(E entity, String itemName) {
        PropertyMeta fieldMeta = (PropertyMeta)this.entityMeta.propertyMeta(itemName + FILEITEM_SUFFIX);
        return (String)StoreModelUtils.getSingleValue(entity, fieldMeta, null);
    }

    protected String getFileName(E entity, String itemName) {
        PropertyMeta fieldMeta = (PropertyMeta)this.entityMeta.propertyMeta(itemName);
        return (String)StoreModelUtils.getSingleValue(entity, fieldMeta, null);
    }

    protected String storeUploadedFile(String src, String itemName, String title, byte[] data, HttpServletRequest request) throws IOException {
        String modelid = this.entityMeta.table();
        return this.dfofactory.putJshfilename(modelid, itemName, title, data, request);
    }

    protected DownloadFileObject getDownloadFileObject(String src, HttpServletRequest request) throws IOException {
        DownloadFileObject dfo = this.dfofactory.create(src, request);
        if (dfo == null || !dfo.canRead()) {
            throw new FileNotFoundException();
        }
        return dfo;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FileData {
        private String title;
        private String src;
        private String contentType;
        protected byte[] data;

        @JsonCreator
        public FileData(@JsonProperty(value="title") String title, @JsonProperty(value="src") String src, @JsonProperty(value="data") String data) {
            this.title = title;
            this.src = src;
            if (data == null) {
                return;
            }
            if (StringUtils.containsNone((String)data, (String)",")) {
                return;
            }
            this.contentType = StringUtils.substringBefore((String)data, (String)",");
            this.data = Base64.getDecoder().decode(StringUtils.substringAfter((String)data, (String)","));
        }

        public FileData() {
        }

        @JsonProperty(value="title")
        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="src")
        public String getSrc() {
            return this.src;
        }

        public String toString() {
            return "title=" + this.title + " src=" + this.src + " contentType=" + this.contentType + " data.length=" + (this.data != null ? Integer.valueOf(this.data.length) : "none");
        }
    }

    public static class FileRequestBodyBase<E> {
        private E entity;
        private FileData[] jfcfilenames;
        private Map<String, Object> kvs = new HashMap<String, Object>();

        @JsonUnwrapped
        public void setEntity(E entity) {
            this.entity = entity;
        }

        @JsonUnwrapped
        public E getEntity() {
            return this.entity;
        }

        @JsonAnySetter
        public void put(String key, Object value) {
            this.kvs.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, Object> getEntries() {
            return this.kvs;
        }

        @JsonProperty(value="jfcfilenames")
        public FileData[] getJfcfilenames() {
            return this.jfcfilenames;
        }

        @JsonProperty(value="jfcfilenames")
        public void setJfcfilenames(FileData[] jfcfilenames) {
            this.jfcfilenames = jfcfilenames;
        }
    }
}

