/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.UserInfoBase;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.app.MailMessageManager;
import jp.jasminesoft.jfc.controller.ReminderUtils;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.model.jfcreminder.Jfcreminder;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.model.mailmessage.Mailmessage;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.model.preference.Preference;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.MimeMailUtilities;
import jp.jasminesoft.util.RandomString;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class RemindPasswordController {
    private static final Logger logger = LogManager.getLogger((String)RemindPasswordController.class.getName());
    protected static final int RANDOM_STRING_LENGTH = 48;
    protected static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private ServletConfig servletConfig;
    @Autowired
    private ApplicationContext applicationContext;
    private JFCErrorManager errorManager;
    private MailMessageManager mailman;
    @Autowired
    @Qualifier(value="NewTransactionTemplate")
    protected TransactionTemplate newTransactionTemplate;
    @Autowired
    @Qualifier(value="sessionFactory")
    protected SessionFactory sessionFactory;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setJFCErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    @Autowired
    public void setMailMessageManager(MailMessageManager mailman) {
        this.mailman = mailman;
    }

    public MailMessageManager getMailMessageManager() {
        return this.mailman;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/remindPassword.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.clearJfcerrors(request.getSession());
        ActionParameter p = this.createActionParameter(request, response);
        Mailmessage mm = this.getMailmessage(p);
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String passwordReminder = context.getInitParameter("passwordReminder");
        if (!"USE".equals(passwordReminder) && !"USESQL".equals(passwordReminder) || !this.isPaswordReminderSelectable(context) && !this.getPaswordReminderDefalutValue(context) || mm == null) {
            p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.cannotuse", p.locale));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00249), LogCodeManager.getMessage(LogCode.JFC00249, new String[0]));
            return "remindPassword.input";
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("userid"))) {
            return "remindPassword.input";
        }
        UserInfoBase userinfo = (UserInfoBase)UserInfoFactory.getUserInfo();
        IJuser juser = null;
        String email = null;
        try {
            juser = this.getJuser(p, userinfo);
            if (juser == null) {
                p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.donotuse", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00046), LogCodeManager.getMessage(LogCode.JFC00046, p.request.getParameter("userid")));
                String string = "remindPassword.input";
                return string;
            }
            Preference pref = userinfo.loadPreference(juser);
            if (!this.usePasswordReminder(juser, pref, p)) {
                p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.donotuse", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00047), LogCodeManager.getMessage(LogCode.JFC00047, p.request.getParameter("userid")));
                String string = "remindPassword.input";
                return string;
            }
            email = this.getEmail(juser, pref, userinfo, p);
            if (StringUtils.isBlank((CharSequence)email)) {
                p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.donotuse", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00038), LogCodeManager.getMessage(LogCode.JFC00038, p.request.getParameter("userid")));
                String string = "remindPassword.input";
                return string;
            }
            if (!MimeMailUtilities.isValidInternetAddress((String)email)) {
                p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.donotuse", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00039), LogCodeManager.getMessage(LogCode.JFC00039, p.request.getParameter("userid"), email));
                String string = "remindPassword.input";
                return string;
            }
            if (!this.checkPrincipal(juser, userinfo, p)) {
                p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.donotuse", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00045), LogCodeManager.getMessage(LogCode.JFC00045, p.request.getParameter("userid")));
                String string = "remindPassword.input";
                return string;
            }
            if (StringUtils.isEmpty((CharSequence)juser.getPasswd())) {
                p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.donotuse", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00047), LogCodeManager.getMessage(LogCode.JFC00047, p.request.getParameter("userid")));
                String string = "remindPassword.input";
                return string;
            }
        }
        finally {
            userinfo.close();
        }
        if (!this.sendMail(juser, email, mm, p)) {
            Object[] o = new Object[]{juser.getUserid()};
            p.errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.sendmail", o, p.locale));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00037), LogCodeManager.getMessage(LogCode.JFC00037, email));
            return "remindPassword.input";
        }
        request.setAttribute("email", (Object)email);
        return "remindPassword.success";
    }

    protected boolean sendMail(IJuser juser, String email, Mailmessage mm, ActionParameter p) {
        Calendar cal = Calendar.getInstance();
        cal.add(10, 1);
        String randomString = this.storeReminderData(cal.getTime(), juser);
        String path = "setNewPassword.do?id=" + randomString;
        String requestUrl = p.request.getRequestURL().toString();
        int ptr = requestUrl.lastIndexOf("/");
        String host = requestUrl.substring(0, ptr + 1);
        String url = host + path;
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("${username}", juser.getName());
        replaceMap.put("${userid}", juser.getUserid());
        replaceMap.put("${to}", email);
        replaceMap.put("${host}", host);
        replaceMap.put("${path}", path);
        replaceMap.put("${url}", url);
        replaceMap.put("${limitdate}", new SimpleDateFormat(JFCUtils.getRValue("__jfc_common.datetimeformat.output", p.locale)).format(cal.getTime()));
        mm = this.mailman.replace(mm, replaceMap);
        return this.mailman.send(mm, null, this.errorManager, null, p);
    }

    private String storeReminderData(Date date, final IJuser juser) {
        String randomString = RandomString.createRandomString((int)48);
        if (ReminderUtils.isRAMStore(this.applicationContext)) {
            String limitdate = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
            String value = limitdate + ":" + juser.getUserid();
            this.getServletContext().setAttribute(randomString, (Object)value);
            return randomString;
        }
        ReminderUtils.removeExpiredReminderData(this.newTransactionTemplate, this.sessionFactory);
        final Jfcreminder jfcreminder = new Jfcreminder();
        jfcreminder.setId(randomString);
        jfcreminder.setLimitdate(DateTimeUtil.getSQLTimestamp((Date)date));
        jfcreminder.setUserid(juser.getUserid());
        this.newTransactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                RemindPasswordController.this.sessionFactory.getCurrentSession().createQuery("delete Jfcreminder where userid = :uid").setString("uid", juser.getUserid()).executeUpdate();
                RemindPasswordController.this.sessionFactory.getCurrentSession().save((Object)jfcreminder);
            }
        });
        return randomString;
    }

    protected boolean checkPrincipal(IJuser juser, UserInfoBase userinfo, ActionParameter p) {
        for (Principal principal : userinfo.getPrincipals(juser.getUserid())) {
            if (!"default".equals(principal.getName()) && !"all".equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private String getPreferenceValue(Preference pref, String key) {
        for (Item preference : pref.getItem()) {
            if (!preference.getKey().equals(key)) continue;
            return preference.getContent();
        }
        return null;
    }

    protected String getEmail(IJuser juser, Preference preference, UserInfoBase userinfo, ActionParameter p) {
        String email;
        if (juser == null) {
            return null;
        }
        String content = this.getPreferenceValue(preference, "__jfc_passwordReminderEMailAddress");
        if (content != null && StringUtils.isNotBlank((CharSequence)(email = StringUtil.getValueAsNormalizedAlphabet((String)content)))) {
            return email;
        }
        if (!"USESQL".equals(this.getServletConfig().getServletContext().getInitParameter("passwordReminder"))) {
            return null;
        }
        return StringUtil.getValueAsNormalizedAlphabet((String)userinfo.getEmailByUserid(juser.getUserid()));
    }

    protected ActionParameter createActionParameter(HttpServletRequest request, HttpServletResponse response) {
        ActionParameter p = JFCUtils.createActionParameter(request, response, null, new Jfcerrors(), this.getApplicationContext());
        p.locale = JFCUtils.getLocaleString(request);
        request.setAttribute("__jfc_jfcerrors", (Object)p.errors);
        return p;
    }

    protected Mailmessage getMailmessage(ActionParameter p) {
        Mailmessage mm = this.mailman.getMailmessage("remindPwdMail", p);
        if (mm == null) {
            mm = this.mailman.getMailmessage("remindPassword.xml", p);
        }
        if (mm == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00210), LogCodeManager.getMessage(LogCode.JFC00210, "remindPassword.xml"));
        }
        return mm;
    }

    protected IJuser getJuser(ActionParameter p, UserInfoBase userinfo) {
        String userid = p.request.getParameter("userid");
        if (StringUtils.isBlank((CharSequence)userid)) {
            return null;
        }
        return userinfo.getJuser(userid.trim());
    }

    protected boolean isPaswordReminderSelectable(ServletContext context) {
        return this.parseBoolean(context.getInitParameter("display_passwordReminder_selectable"), true);
    }

    protected boolean getPaswordReminderDefalutValue(ServletContext context) {
        return this.parseBoolean(context.getInitParameter("display_passwordReminder"), true);
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    protected boolean usePasswordReminder(IJuser juser, Preference pref, ActionParameter p) {
        if (juser == null) {
            return false;
        }
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        if (!this.isPaswordReminderSelectable(context)) {
            return this.getPaswordReminderDefalutValue(context);
        }
        return this.getPasswordReminderPreferenceValue(juser, pref);
    }

    protected boolean getPasswordReminderPreferenceValue(IJuser juser, Preference preference) {
        if (juser == null) {
            return false;
        }
        String content = this.getPreferenceValue(preference, "__jfc_passwordReminder");
        if (content != null) {
            return Boolean.parseBoolean(content);
        }
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        return this.getPaswordReminderDefalutValue(context);
    }

    private void clearJfcerrors(HttpSession session) {
        session.removeAttribute("__jfc_jfcerrors");
        session.removeAttribute("__jfc_jfcwarn");
        session.removeAttribute("__jfc_jfcinfo");
    }
}

