/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.Permission;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.script.ScriptEngineManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShowAboutAppController
extends DbBaseController<Object> {
    private static final Logger LOGGER = LogManager.getLogger(ShowAboutAppController.class);
    public static final String javaVersionInfo = "javaVersion";
    public static final String javaHomeInfo = "javaHome";
    public static final String javaClassPathInfo = "javaClassPath";
    public static final String javaLibraryPathInfo = "javaLibraryPath";
    public static final String osNameInfo = "osName";
    public static final String osVersionInfo = "osVersion";
    public static final String wagbyVersionInfo = "wagbyVersion";
    public static final String buildTimestampInfo = "buildTimestamp";

    @Override
    public String getForwardHeader() {
        return "showAboutApp";
    }

    @Override
    @RequestMapping(value={"/showAboutApp.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.showAboutApp";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "showAboutApp");
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("sysinfo", "show");
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        this.setLicenseInfo(p);
        this.setJavaInfo(p);
        this.setOSInfo(p);
        this.setMemoryInfo(p);
        this.setDiskInfo(p);
        this.setNetworkInfo(p);
        this.setBuildInfo(p);
        return this.getInputForward(p);
    }

    private void setLicenseInfo(ActionParameter p) {
        Long limitDate;
        String value = "-";
        ServletContext sc = p.request.getServletContext();
        if (sc != null && (limitDate = (Long)sc.getAttribute("__jfc_licenseinfo_use_limit_date")) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            value = sdf.format(new Date(limitDate - 86400000L));
        }
        this.setRequestValue("jfc_licenseinfo_use_limit_date", value, p);
    }

    private void setJavaInfo(ActionParameter p) {
        this.setRequestValue(javaVersionInfo, System.getProperty("java.version"), p);
        this.setRequestValue(javaHomeInfo, System.getProperty("java.home"), p);
        this.setRequestValue(javaClassPathInfo, System.getProperty("java.class.path"), p);
        this.setRequestValue(javaLibraryPathInfo, System.getProperty("java.library.path"), p);
        this.setRequestValue(osNameInfo, System.getProperty("os.name"), p);
        this.setRequestValue(osVersionInfo, System.getProperty("os.version"), p);
        RuntimeMXBean rmbean = ManagementFactory.getRuntimeMXBean();
        p.request.setAttribute("runtimeBean", (Object)rmbean);
        long upTime = rmbean.getUptime();
        long upTime_sec = upTime / 1000L;
        long upTime_min = upTime_sec / 60L;
        long upTime_hour = upTime_min / 60L;
        long upTime_day = upTime_hour / 24L;
        long upTime_milisec = upTime % 1000L;
        this.setRequestValue("upTime_day", String.valueOf(upTime_day), p);
        this.setRequestValue("upTime_hour", String.valueOf(upTime_hour %= 24L), p);
        this.setRequestValue("upTime_min", String.valueOf(upTime_min %= 60L), p);
        this.setRequestValue("upTime_sec", String.valueOf(upTime_sec %= 60L), p);
        this.setRequestValue("upTime_milisec", String.valueOf(upTime_milisec), p);
        ScriptEngineManager manager = new ScriptEngineManager();
        p.request.setAttribute("scriptEngineManager", manager.getEngineFactories());
    }

    private void setOSInfo(ActionParameter p) {
        OperatingSystemMXBean osbean = ManagementFactory.getOperatingSystemMXBean();
        p.request.setAttribute("osBean", (Object)osbean);
    }

    private void setMemoryInfo(ActionParameter p) {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        this.setHeapMemoryInfo(mbean, p);
        this.setNonHeapMemoryInfo(mbean, p);
    }

    private void setHeapMemoryInfo(MemoryMXBean mbean, ActionParameter p) {
        MemoryProps memoryProps = this.getMemoryProps(mbean.getHeapMemoryUsage());
        double usedPercent = (double)memoryProps.getUsed() / (double)memoryProps.getMax();
        DecimalFormat percentFormat = new DecimalFormat("###.##%");
        String usedHeapMemeory = this.getNumberMByte(memoryProps.getUsedMB()) + this.encloseBrackets(this.getNumberByte(memoryProps.getUsed(), p) + ", " + percentFormat.format(usedPercent));
        this.setRequestValue("usedHeapMemory", usedHeapMemeory, p);
        String maxHeapMemory = this.getNumberMByte(memoryProps.getMaxMB()) + this.encloseBrackets(this.getNumberByte(memoryProps.getMax(), p));
        this.setRequestValue("maxHeapMemory", maxHeapMemory, p);
        String initHeapMemory = this.getNumberMByte(memoryProps.getInitMB()) + this.encloseBrackets(this.getNumberByte(memoryProps.getInit(), p));
        this.setRequestValue("initHeapMemory", initHeapMemory, p);
        p.request.setAttribute("heapMpbeans", this.getMpbeanByType(MemoryType.HEAP));
    }

    private void setNonHeapMemoryInfo(MemoryMXBean mbean, ActionParameter p) {
        MemoryProps memoryProps = this.getMemoryProps(mbean.getNonHeapMemoryUsage());
        String usedNonHeapMemory = this.getNumberMByte(memoryProps.getUsedMB()) + this.encloseBrackets(this.getNumberByte(memoryProps.getUsed(), p));
        this.setRequestValue("usedNonHeapMemory", usedNonHeapMemory, p);
        String maxNonHeapMemory = memoryProps.getMaxMB() > 0.0 ? this.getNumberMByte(memoryProps.getMaxMB()) + this.encloseBrackets(this.getNumberByte(memoryProps.getMax(), p)) : JFCUtils.getRValue("__jfc_common.text.about.memory.undefined", p.locale);
        this.setRequestValue("maxNonHeapMemory", maxNonHeapMemory, p);
        String initNonHeapMemory = this.getNumberMByte(memoryProps.getInitMB()) + this.encloseBrackets(this.getNumberByte(memoryProps.getInit(), p));
        this.setRequestValue("initNonHeapMemory", initNonHeapMemory, p);
        p.request.setAttribute("nonHeapMpbeans", this.getMpbeanByType(MemoryType.NON_HEAP));
    }

    private MemoryProps getMemoryProps(MemoryUsage usage) {
        MemoryProps memoryProps = new MemoryProps();
        memoryProps.setUsed(usage.getUsed());
        memoryProps.setMax(usage.getMax());
        memoryProps.setInit(usage.getInit());
        memoryProps.setUsedMB((double)usage.getUsed() / 1000000.0);
        memoryProps.setMaxMB((double)usage.getMax() / 1000000.0);
        memoryProps.setInitMB((double)usage.getInit() / 1000000.0);
        return memoryProps;
    }

    private List<MemoryPoolMXBean> getMpbeanByType(MemoryType type) {
        ArrayList<MemoryPoolMXBean> mpbeans = new ArrayList<MemoryPoolMXBean>();
        for (MemoryPoolMXBean mpbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (mpbean.getType() != type) continue;
            mpbeans.add(mpbean);
        }
        return mpbeans;
    }

    private String getNumberMByte(double value) {
        return this.getNumberWithUnit(value, "MB");
    }

    private String getNumberGByte(double value) {
        return this.getNumberWithUnit(value, "GB");
    }

    private String getNumberWithUnit(double value, String unit) {
        DecimalFormat dblFormat = new DecimalFormat("#,###.##");
        return dblFormat.format(value) + " " + unit;
    }

    private String getNumberByte(long value, ActionParameter p) {
        NumberFormat intFormat = NumberFormat.getNumberInstance();
        return intFormat.format(value) + JFCUtils.getRValue("__jfc_common.text.about.disk.unit", p.locale);
    }

    private String encloseBrackets(String value) {
        return " (" + value + ")";
    }

    private void setDiskInfo(ActionParameter p) {
        File file = new File(".");
        try {
            Class<File> clazz = File.class;
            Method method = clazz.getMethod("getTotalSpace", new Class[0]);
            Object result = method.invoke((Object)file, new Object[0]);
            long total_space = (Long)result;
            method = clazz.getMethod("getFreeSpace", new Class[0]);
            result = method.invoke((Object)file, new Object[0]);
            long free_space = (Long)result;
            method = clazz.getMethod("getUsableSpace", new Class[0]);
            result = method.invoke((Object)file, new Object[0]);
            long usable_space = (Long)result;
            double total_space_gb = (double)total_space / 1.0E9;
            double free_space_gb = (double)free_space / 1.0E9;
            double usable_space_gb = (double)usable_space / 1.0E9;
            p.request.setAttribute("totalDiskSpace", (Object)(this.getNumberGByte(total_space_gb) + this.encloseBrackets(this.getNumberByte(total_space, p))));
            p.request.setAttribute("freeDiskSpace", (Object)(this.getNumberGByte(free_space_gb) + this.encloseBrackets(this.getNumberByte(free_space, p))));
            p.request.setAttribute("usableDiskSpace", (Object)(this.getNumberGByte(usable_space_gb) + this.encloseBrackets(this.getNumberByte(usable_space, p))));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void setNetworkInfo(ActionParameter p) {
        TreeMap nwMap = new TreeMap();
        try {
            Class<NetworkInterface> clazz = NetworkInterface.class;
            Enumeration<NetworkInterface> nic = NetworkInterface.getNetworkInterfaces();
            while (nic.hasMoreElements()) {
                NetworkInterface n = nic.nextElement();
                Method method = clazz.getMethod("isLoopback", new Class[0]);
                Object result = method.invoke((Object)n, new Object[0]);
                boolean isLoopback = (Boolean)result;
                method = clazz.getMethod("isVirtual", new Class[0]);
                result = method.invoke((Object)n, new Object[0]);
                boolean isVirtual = (Boolean)result;
                method = clazz.getMethod("isUp", new Class[0]);
                result = method.invoke((Object)n, new Object[0]);
                boolean isUp = (Boolean)result;
                if (!isUp || isVirtual || isLoopback) continue;
                Enumeration<InetAddress> ipAddrs = n.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    Inet6Address in6;
                    String in6adrs;
                    InetAddress in = ipAddrs.nextElement();
                    String hostname = in.getHostName();
                    HashMap<String, String> map = (HashMap<String, String>)nwMap.get(hostname);
                    if (map == null) {
                        map = new HashMap<String, String>();
                        nwMap.put(hostname, map);
                    }
                    if (in instanceof Inet4Address) {
                        Inet4Address in4 = (Inet4Address)in;
                        String in4adrs = in4.getHostAddress();
                        if (in4adrs == null || in4adrs.equals(hostname)) continue;
                        map.put("v4", in4adrs);
                        continue;
                    }
                    if (!(in instanceof Inet6Address) || (in6adrs = (in6 = (Inet6Address)in).getHostAddress()) == null || in6adrs.equals(hostname)) continue;
                    map.put("v6", in6adrs);
                }
            }
            p.request.setAttribute("nwMap", nwMap);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void setBuildInfo(ActionParameter p) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle("buildlog");
            if (rb != null) {
                Enumeration<String> e = rb.getKeys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    if ("wagby.version".equals(key)) {
                        p.request.setAttribute(wagbyVersionInfo, (Object)rb.getString(key));
                        continue;
                    }
                    if (!"build.timestamp".equals(key)) continue;
                    p.request.setAttribute(buildTimestampInfo, (Object)rb.getString(key));
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void setRequestValue(String key, String value, ActionParameter p) {
        p.request.setAttribute(key, (Object)value);
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        return true;
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }

    private class MemoryProps {
        private long used;
        private long max;
        private long init;
        private double usedMB;
        private double maxMB;
        private double initMB;

        private MemoryProps() {
        }

        public long getUsed() {
            return this.used;
        }

        public void setUsed(long used) {
            this.used = used;
        }

        public long getMax() {
            return this.max;
        }

        public void setMax(long max) {
            this.max = max;
        }

        public long getInit() {
            return this.init;
        }

        public void setInit(long init) {
            this.init = init;
        }

        public double getUsedMB() {
            return this.usedMB;
        }

        public void setUsedMB(double usedMB) {
            this.usedMB = usedMB;
        }

        public double getMaxMB() {
            return this.maxMB;
        }

        public void setMaxMB(double maxMB) {
            this.maxMB = maxMB;
        }

        public double getInitMB() {
            return this.initMB;
        }

        public void setInitMB(double initMB) {
            this.initMB = initMB;
        }
    }
}

