/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.SystemlogCondition;
import jp.jasminesoft.jfc.model.systemlog.SystemlogKind;
import jp.jasminesoft.jfc.model.systemlog.SystemlogManager;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShowListLogController
extends BaseController {
    public static final String ShowListSizeName = "size";
    public static final String SystemlogManagerName = "_logman";
    public static final String LogDataName = "_logdata";
    public static final String LogTargetDateName = "_log_target_day";
    public static final String LogKeywordName = "_log_keyword";
    public static final String LogKindMapName = "_log_kind_map";
    public static final String LogTypeName = "_log_type";
    public static final String LogFileSelectedName = "_log_file_selected";
    public static final String LogTypeSelectedName = "_log_type_selected";
    public static final String LogBeginNumberName = "_log_begin";
    public static final String LogEndNumberName = "_log_end";
    public static final String LogCountName = "_log_count";
    public static final String LogReadStatusName = "_log_readstatus";
    @Autowired
    private SystemlogManager logman;
    protected Map<String, String> logKindMap = null;
    protected Map<String, SystemlogKind> logKind2Map = null;
    protected String[] logTypes = new String[]{"", "INFO", "WARN", "ERROR", "FATAL", "DEBUG"};
    private static final Logger logger = LogManager.getLogger(ShowListLogController.class);

    @Override
    public String getForwardHeader() {
        return "showListLog";
    }

    @Override
    @RequestMapping(value={"/showListLog.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.showListLog";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "showListLog");
    }

    protected synchronized void setLogKindMap(ActionParameter p) {
        TreeMap<String, String> _logkindmap = new TreeMap<String, String>();
        HashMap<String, SystemlogKind> _logkind2map = new HashMap<String, SystemlogKind>();
        SystemlogKind[] logkinds = this.logman.getLogKinds();
        for (int i = 0; i < logkinds.length; ++i) {
            _logkindmap.put(logkinds[i].getLabel(p), logkinds[i].getId());
            _logkind2map.put(logkinds[i].getId(), logkinds[i]);
        }
        this.logKindMap = Collections.unmodifiableMap(_logkindmap);
        this.logKind2Map = Collections.unmodifiableMap(_logkind2map);
    }

    public void do_preprocess(ActionParameter p) {
        if (this.logKindMap == null || this.logKind2Map == null) {
            this.setLogKindMap(p);
        }
        p.request.setAttribute(LogKindMapName, this.logKindMap);
        p.request.setAttribute(LogTypeName, (Object)this.logTypes);
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.action.length() == 0 || p.referrer == null || p.referrer.length() == 0) {
            return CommandType.None;
        }
        if (p.action != null && p.action.startsWith("Search")) {
            return CommandType.Search;
        }
        if (p.action != null && p.action.startsWith("Reset")) {
            return CommandType.Reset;
        }
        return CommandType.None;
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("syslog", "show");
    }

    @Override
    public String perform0(ActionParameter p) throws IOException, ServletException {
        String err_forward;
        this.setUserInfoMap(p);
        String forward = super.perform0(p);
        if (forward != null) {
            return forward;
        }
        this.setCommandToActionParameter(p);
        Date target_day = (Date)p.appMap.get(this.getStatus() + LogTargetDateName);
        if (target_day == null) {
            target_day = this.logman.getNowDate();
            p.appMap.put(this.getStatus() + LogTargetDateName, target_day);
        }
        SystemlogCondition cond = null;
        if (p.cmd == CommandType.Search || p.cmd == CommandType.ChangeSidebar) {
            cond = (SystemlogCondition)p.appMap.get(this.getStatus() + LogKeywordName);
        }
        if (cond == null) {
            cond = new SystemlogCondition();
            p.appMap.put(this.getStatus() + LogKeywordName, cond);
        }
        SystemlogKind logkind = this.logman.getDefaultLogKinds();
        String logfileid = logkind.getId();
        String logType = "ERROR";
        String keyword = null;
        int begin = -1;
        int end = -1;
        Systemlog[] logdata = null;
        this.do_preprocess(p);
        if (p.cmd == CommandType.UserDefined) {
            logger.info(this.getLogHeader(p, p.action));
            forward = this.do_original(p);
        } else if (p.cmd == CommandType.Search || p.cmd == CommandType.Reset || p.cmd == CommandType.ChangeSidebar) {
            String q_keyword;
            String end_str;
            String begin_str = p.request.getParameter("begin");
            if (begin_str != null && begin_str.length() > 0) {
                begin = StringUtil.intValue((String)begin_str);
            }
            if ((end_str = p.request.getParameter("end")) != null && end_str.length() > 0) {
                end = StringUtil.intValue((String)end_str);
            }
            String _logfileid = p.request.getParameter("logfilename");
            if (this.logKind2Map != null && this.logKind2Map.containsKey(_logfileid)) {
                logfileid = _logfileid;
                logkind = this.logKind2Map.get(_logfileid);
            } else {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00240), LogCodeManager.getMessage(LogCode.JFC00240, p.user, logfileid));
            }
            Date d_mdate = DateTimeUtil.getDate((String)p.request.getParameter("target_day"));
            if (d_mdate != null) {
                target_day = d_mdate;
            }
            logType = p.request.getParameter("logType");
            List<String> logTypeList = Arrays.asList(this.logTypes);
            if (logType == null || !logTypeList.contains(logType)) {
                logType = "";
            }
            if ((q_keyword = p.request.getParameter("keyword")) != null && q_keyword.length() > 0) {
                keyword = q_keyword;
            }
            StringBuilder msg = new StringBuilder();
            msg.append(" begin=" + begin);
            msg.append(" end=" + end);
            msg.append(" logkind.id=" + logkind.getId());
            msg.append(" logType=" + logType);
            msg.append(" keyword=" + keyword);
            msg.append(" target_day=" + target_day);
            logger.info(this.getLogHeader(p) + msg);
        } else {
            logger.info(this.getLogHeader(p));
        }
        if (p.cmd == CommandType.Search) {
            cond.setKeyword(keyword);
            cond.setBeginNumber(begin);
            cond.setEndNumber(end);
        }
        cond.setTargetDay(target_day);
        cond.setLogKind(logkind);
        cond.setLogType(logType);
        if (logger.isDebugEnabled()) {
            logger.debug("getLogData " + cond);
        }
        int count = (logdata = this.logman.getLogData(cond)) != null ? logdata.length : 0;
        p.request.setAttribute(LogDataName, (Object)logdata);
        p.request.setAttribute(LogBeginNumberName, (Object)cond.getBeginNumber());
        p.request.setAttribute(LogEndNumberName, (Object)(cond.getBeginNumber() + count - 1));
        p.request.setAttribute(LogCountName, (Object)cond.getCount());
        p.request.setAttribute(LogTargetDateName, (Object)target_day);
        p.request.setAttribute(LogFileSelectedName, (Object)logkind.getId());
        p.request.setAttribute(LogTypeSelectedName, (Object)cond.getLogType());
        p.request.setAttribute(LogKeywordName, (Object)cond.getKeyword());
        p.request.setAttribute(LogReadStatusName, (Object)cond.getReadStatus());
        p.appMap.put(this.getStatus() + LogTargetDateName, target_day);
        p.appMap.put(this.getStatus() + LogKeywordName, cond);
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            return this.getInputForward(p);
        }
        return forward;
    }

    private void setUserInfoMap(ActionParameter p) {
        Map _userinfoMap = (Map)p.request.getAttribute("__jfc_userinfoMap");
        if (_userinfoMap != null) {
            p.pageMap.put("__jfc_userinfoMap", _userinfoMap);
        } else {
            _userinfoMap = (Map)p.pageMap.get("__jfc_userinfoMap");
            if (_userinfoMap != null) {
                p.request.setAttribute("__jfc_userinfoMap", (Object)_userinfoMap);
            }
        }
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }

    public String do_original(ActionParameter p) throws IOException, ServletException {
        return this.getInputForward(p);
    }
}

