/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatus;
import jp.jasminesoft.jfc.LogonStatusComparator;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.model.juser.Juser;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShowListLogonUsersController
extends DbBaseController<Object> {
    public static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final Logger logger = LogManager.getLogger();

    @Override
    public String getForwardHeader() {
        return "showListLogonUsers";
    }

    @Override
    @RequestMapping(value={"/showListLogonUsers.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.showListLogonUsers";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "showListLogonUsers");
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("juser", "releaseLogonUser");
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String forward = super.perform_db(p);
        if (forward != null) {
            return forward;
        }
        if (p.user == null) {
            return this.getErrorForward(p);
        }
        LogonStatusManager LSMAN = (LogonStatusManager)p.appctx.getBean(LogonStatusManager.class);
        LogonStatus[] users = LSMAN.getCurrentLogonUsers();
        if (users == null) {
            logger.debug(this.getLogHeader(p, "No users is found. "));
            return this.getInputForward(p);
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        JFCEntityService service = (JFCEntityService)p.appctx.getBean("JuserEntityService", JFCEntityService.class);
        for (LogonStatus user : users) {
            String uid = user.getUsername();
            Juser juser = (Juser)service.findById(uid);
            if (juser != null) {
                nameMap.put(uid, StringUtils.defaultIfEmpty((String)juser.getName(), (String)""));
                continue;
            }
            logger.warn("No user is found, id=" + uid);
        }
        logger.log(LogCodeManager.getPriority(LogCode.JFC90015), LogCodeManager.getMessage(LogCode.JFC90015, p.user, String.valueOf(users.length)));
        StringBuilder sb = new StringBuilder();
        sb.append("<p>").append(StringUtil.CR);
        sb.append(JFCUtils.getRValue("__jfc_common.text.logon.now", p.locale)).append(StringUtil.CR);
        sb.append("</p>").append(StringUtil.CR);
        SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Arrays.sort(users, new LogonStatusComparator());
        boolean displayMachinename = ClusterManagerFactory.getClusterManager().getUseCluster();
        if (users == null || users.length < 1) {
            sb.append("<p>").append(JFCUtils.getRValue("__jfc_common.text.logon.none", p.locale)).append("</p>");
        } else {
            sb.append("<table class=\"display_table\" width=\"90%\" cellspacing=\"1\">").append(StringUtil.CR);
            sb.append("<tr>").append(StringUtil.CR);
            sb.append("<th class=\"display_label\"></th>").append(StringUtil.CR);
            sb.append("<th class=\"display_label\">").append(JFCUtils.getRValue("__jfc_common.tabletitle.account", p.locale)).append("</th>").append(StringUtil.CR);
            sb.append("<th class=\"display_label\">").append(JFCUtils.getRValue("__jfc_common.tabletitle.accountname", p.locale)).append("</th>").append(StringUtil.CR);
            if (displayMachinename) {
                sb.append("<th class=\"display_label\">").append(JFCUtils.getRValue("__jfc_common.tabletitle.machinename", p.locale)).append("</th>").append(StringUtil.CR);
            }
            sb.append("<th class=\"display_label\">").append(JFCUtils.getRValue("__jfc_common.tabletitle.logon.enter", p.locale)).append("</th>").append(StringUtil.CR);
            sb.append("<th class=\"display_label\">").append(JFCUtils.getRValue("__jfc_common.tabletitle.access.last", p.locale)).append("</th>").append(StringUtil.CR);
            sb.append("</tr>").append(StringUtil.CR);
            String td_class = null;
            String sessionId = null;
            String userName = null;
            String juserName = null;
            Date created = null;
            Date lastaccess = null;
            String createdTime = null;
            String lastaccessTime = null;
            String machinename = null;
            for (int i = 0; i < users.length; ++i) {
                td_class = i % 2 == 0 ? "display_field2_center" : "display_field_center";
                sessionId = users[i].getSessionId();
                userName = users[i].getUsername();
                juserName = nameMap != null ? (String)nameMap.get(userName) : "";
                created = new Date(users[i].getCreationTime());
                lastaccess = new Date(users[i].getLastAccessedTime());
                machinename = users[i].getMachinename();
                try {
                    createdTime = FORMAT.format(created);
                    lastaccessTime = FORMAT.format(lastaccess);
                }
                catch (IllegalStateException e) {
                    createdTime = null;
                    lastaccessTime = null;
                }
                sb.append("<tr>").append(StringUtil.CR);
                sb.append(" <td class=\"").append(td_class).append("\">").append(StringUtil.CR);
                if (!sessionId.equals(p.request.getSession().getId())) {
                    sb.append("<form name=\"releaseLogonUser\" method=\"post\" action=\"releaseLogonUser.do\">").append(StringUtil.CR);
                    sb.append("  <input type=\"hidden\" name=\"SENDACTION\"/>").append(StringUtil.CR);
                    sb.append("  <input type=\"hidden\" name=\"sessionId\"");
                    sb.append(" value=\"").append(StringUtil.getMD5Hash((String)sessionId)).append("\"/>").append(StringUtil.CR);
                    sb.append("  <input type=\"hidden\" name=\"userName\" value=\"").append(StringEscapeUtils.escapeHtml4((String)userName)).append("\"/>").append(StringUtil.CR);
                    if (displayMachinename) {
                        sb.append("  <input type=\"hidden\" name=\"machinename\" value=\"").append(StringEscapeUtils.escapeHtml4((String)machinename)).append("\"/>").append(StringUtil.CR);
                    }
                    sb.append("<button data-dojo-type=\"dijit/form/Button\" type=\"submit\" name=\"btn_Release\">");
                    sb.append(JFCUtils.getRValue("__jfc_common.submit.release.logon", p.locale));
                    sb.append("</button>").append(StringUtil.CR);
                    sb.append("</form>").append(StringUtil.CR);
                } else {
                    sb.append(JFCUtils.getRValue("__jfc_common.text.connect.yourself", p.locale));
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(td_class).append("\">").append(StringEscapeUtils.escapeHtml4((String)userName)).append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(td_class).append("\">").append(StringEscapeUtils.escapeHtml4((String)juserName)).append("</td>").append(StringUtil.CR);
                if (displayMachinename) {
                    sb.append("<td class=\"").append(td_class).append("\">").append(StringEscapeUtils.escapeHtml4((String)machinename)).append("</td>").append(StringUtil.CR);
                }
                sb.append("<td class=\"").append(td_class).append("\">");
                if (createdTime == null) {
                    sb.append(JFCUtils.getRValue("__jfc_common.text.unknown", p.locale));
                } else {
                    sb.append(createdTime);
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("<td class=\"").append(td_class).append("\">");
                if (lastaccessTime == null) {
                    sb.append(JFCUtils.getRValue("__jfc_common.text.unknown", p.locale));
                } else {
                    sb.append(lastaccessTime);
                }
                sb.append("</td>").append(StringUtil.CR);
                sb.append("</tr>").append(StringUtil.CR);
            }
            sb.append("</table>").append(StringUtil.CR);
        }
        sb.append("<br/>").append(StringUtil.CR);
        sb.append("<div style=\"text-align:center;\">").append(StringUtil.CR);
        sb.append("  <form name=\"showListLogonUsers\" action=\"showListLogonUsers.do\">").append(StringUtil.CR);
        sb.append("  <button data-dojo-type=\"dijit/form/Button\" name=\"btn_ShowListLogonUsers\" type=\"submit\">");
        sb.append(JFCUtils.getRValue("__jfc_common.submit.refresh.screen", p.locale));
        sb.append("</button>").append(StringUtil.CR);
        sb.append("  </form>").append(StringUtil.CR);
        sb.append("</div>").append(StringUtil.CR);
        p.request.setAttribute("showListLogonUserHTMLContent", (Object)sb.toString());
        return this.getInputForward(p);
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }
}

