/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.CssFileManager;
import jp.jasminesoft.jfc.FontsizeFileManager;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.menu.JFCAppMenu;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.jfc.model.csslist.Cssitem;
import jp.jasminesoft.jfc.model.csslist.Csslist;
import jp.jasminesoft.jfc.model.fontsizelist.Fontsizeitem;
import jp.jasminesoft.jfc.model.fontsizelist.Fontsizelist;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.util.MimeMailUtilities;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class UserPreferenceController
extends DbBaseController<Object> {
    private static final Logger logger = LogManager.getLogger(UserPreferenceController.class);
    @Autowired
    private ServletConfig servletConfig;

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public String getForwardHeader() {
        return "userPreference";
    }

    @Override
    @RequestMapping(value={"/userPreference.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.preference";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "userPreference");
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.action.length() == 0 || p.referrer == null || p.referrer.length() == 0) {
            return CommandType.BeginUpdate;
        }
        if (p.action != null && p.action.startsWith("Update")) {
            return CommandType.DoUpdate;
        }
        return CommandType.BeginUpdate;
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("common", "default");
    }

    @Override
    public boolean checkPermission(ActionParameter p) {
        if (p != null) {
            boolean isChangeFontsize = false;
            Enumeration em = p.request.getParameterNames();
            while (em.hasMoreElements()) {
                String key = (String)em.nextElement();
                if (key.equals("fontsizefilename")) {
                    isChangeFontsize = true;
                    continue;
                }
                if (key.equals("sessionId")) continue;
                isChangeFontsize = false;
                break;
            }
            if (isChangeFontsize) {
                return true;
            }
        }
        return super.checkPermission(p);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String passwordReminder_selectable;
        String display_passwordReminder_selectable;
        String display_passwordReminder;
        String bottomarea_selectable;
        String sidebar_selectable;
        String pankuzu_selectable;
        String calendarFirstDayOfWeek_selectable;
        String submenu_position_selectable;
        String submenu_selectable;
        String logofficon_selectable;
        String helpicon_selectable;
        String menuicon_selectable;
        String layoutType_selectable;
        String fontsize_selectable;
        String forward = super.perform_db(p);
        if (forward != null) {
            return forward;
        }
        if (p.user == null) {
            String err_forward = this.getErrorForward();
            if (err_forward != null) {
                forward = err_forward;
            }
            if (forward == null) {
                forward = "globalerror";
            }
            return forward;
        }
        ServletContext context = this.getServletConfig().getServletContext();
        String cssfilename_selectable = context.getInitParameter("cssfilename_selectable");
        if (StringUtils.isNotBlank((CharSequence)cssfilename_selectable) && !Boolean.parseBoolean(cssfilename_selectable)) {
            p.request.setAttribute("cssfilename_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(fontsize_selectable = context.getInitParameter("fontsize_selectable"))) && !Boolean.parseBoolean(fontsize_selectable)) {
            p.request.setAttribute("fontsize_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(layoutType_selectable = context.getInitParameter("display_layoutType_selectable"))) && !Boolean.parseBoolean(layoutType_selectable)) {
            p.request.setAttribute("display_layoutType_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(menuicon_selectable = context.getInitParameter("display_menuicon_selectable"))) && !Boolean.parseBoolean(menuicon_selectable)) {
            p.request.setAttribute("display_menuicon_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(helpicon_selectable = context.getInitParameter("display_helpicon_selectable"))) && !Boolean.parseBoolean(helpicon_selectable)) {
            p.request.setAttribute("display_helpicon_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(logofficon_selectable = context.getInitParameter("display_logofficon_selectable"))) && !Boolean.parseBoolean(logofficon_selectable)) {
            p.request.setAttribute("display_logofficon_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(submenu_selectable = context.getInitParameter("display_submenu_selectable"))) && !Boolean.parseBoolean(submenu_selectable)) {
            p.request.setAttribute("display_submenu_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(submenu_position_selectable = context.getInitParameter("submenu_position_selectable"))) && !Boolean.parseBoolean(submenu_position_selectable)) {
            p.request.setAttribute("submenu_position_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(calendarFirstDayOfWeek_selectable = context.getInitParameter("calendarFirstDayOfWeek_selectable"))) && !Boolean.parseBoolean(calendarFirstDayOfWeek_selectable)) {
            p.request.setAttribute("calendarFirstDayOfWeek_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(pankuzu_selectable = context.getInitParameter("display_pankuzu_selectable"))) && !Boolean.parseBoolean(pankuzu_selectable)) {
            p.request.setAttribute("display_pankuzu_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(sidebar_selectable = context.getInitParameter("display_sidebar_selectable"))) && !Boolean.parseBoolean(sidebar_selectable)) {
            p.request.setAttribute("display_sidebar_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(bottomarea_selectable = context.getInitParameter("display_bottomarea_selectable"))) && !Boolean.parseBoolean(bottomarea_selectable)) {
            p.request.setAttribute("display_bottomarea_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(display_passwordReminder = context.getInitParameter("display_passwordReminder"))) && !Boolean.parseBoolean(display_passwordReminder)) {
            p.request.setAttribute("display_passwordReminder", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(display_passwordReminder_selectable = context.getInitParameter("display_passwordReminder_selectable"))) && !Boolean.parseBoolean(display_passwordReminder_selectable)) {
            p.request.setAttribute("display_passwordReminder_selectable", (Object)Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)(passwordReminder_selectable = context.getInitParameter("passwordReminder_selectable"))) && !Boolean.parseBoolean(passwordReminder_selectable)) {
            p.request.setAttribute("passwordReminder_selectable", (Object)Boolean.FALSE);
        }
        HttpSession session = p.request.getSession();
        String selectedCssfilename = null;
        selectedCssfilename = (String)session.getAttribute("__jfc_cssfilename");
        String selectedFontsizefilename = null;
        FontsizeFileManager fsman = this.getFontsizeFileManager();
        selectedFontsizefilename = (String)session.getAttribute("__jfc_fontsizefilename");
        CssFileManager cssman = this.getCssFileManager();
        this.setCommandToActionParameter(p);
        this.do_preprocess(p);
        if (p.cmd == CommandType.UserDefined) {
            logger.info(this.getLogHeader(p, p.action));
            forward = this.do_original(p);
        } else {
            String submenuDisplayArea;
            String bottomAreaStatus;
            String pankuzuStatus;
            String submenuStatus;
            String logoffIconStatus;
            String helpIconStatus;
            String menuIconStatus;
            Fontsizelist fontsizelist;
            Cssitem[] items;
            Csslist csslist;
            String _cssfilename = p.request.getParameter("cssfilename");
            if (JFCUtils.isAcceptCssFilename(cssman, _cssfilename)) {
                String error_forward = this.checkSessionId(p);
                if (error_forward != null) {
                    return error_forward;
                }
                logger.debug(this.getLogHeader(p) + "Set cssfile to " + _cssfilename);
                session.setAttribute("__jfc_cssfilename", (Object)_cssfilename);
                p.user.setPreferenceItem("cssfilename", _cssfilename);
                selectedCssfilename = _cssfilename;
            }
            if ((csslist = cssman.getCsslist()) != null && selectedCssfilename != null && (items = csslist.getCssitem()) != null) {
                for (Cssitem item : items) {
                    if (selectedCssfilename.equals(item.getContent())) {
                        item.setChoice(true);
                        continue;
                    }
                    item.setChoice(false);
                }
            }
            p.request.setAttribute("__jfc_cssfilenamelist", (Object)csslist);
            String _fontsizefilename = p.request.getParameter("fontsizefilename");
            if (JFCUtils.isAcceptFontsizeFilename(fsman, _fontsizefilename, p)) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set fontsizefile to " + _fontsizefilename);
                p.user.setPreferenceItem("fontsizefilename", _fontsizefilename);
                selectedFontsizefilename = _fontsizefilename;
            }
            if ((fontsizelist = fsman.getFontsizelist(p)) != null && selectedFontsizefilename != null) {
                Fontsizeitem[] items2 = fontsizelist.getFontsizeitem();
                if (items2 != null) {
                    for (Fontsizeitem item : items2) {
                        if (selectedFontsizefilename.equals(item.getContent())) {
                            item.setChoice(true);
                            continue;
                        }
                        item.setChoice(false);
                    }
                }
                session.setAttribute("__jfc_fontsizefilename", (Object)selectedFontsizefilename);
            }
            p.request.setAttribute("__jfc_fontsizelist", (Object)fontsizelist);
            String layoutTypeStatus = p.request.getParameter("layoutType");
            if (layoutTypeStatus != null && layoutTypeStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set layout type to " + layoutTypeStatus);
                session.setAttribute("__jfc_layoutType", (Object)layoutTypeStatus);
                p.user.setPreferenceItem("__jfc_layoutType", layoutTypeStatus);
            }
            if ((menuIconStatus = p.request.getParameter("menuicon")) != null && menuIconStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set globallink menuicon mode to " + menuIconStatus);
                Boolean b = Boolean.valueOf(menuIconStatus);
                session.setAttribute("__jfc_globallink_menuicon", (Object)b);
                p.user.setPreferenceItem("__jfc_globallink_menuicon", b.toString());
            }
            if ((helpIconStatus = p.request.getParameter("helpicon")) != null && helpIconStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set globallink helpicon mode to " + helpIconStatus);
                Boolean b = Boolean.valueOf(helpIconStatus);
                session.setAttribute("__jfc_globallink_helpicon", (Object)b);
                p.user.setPreferenceItem("__jfc_globallink_helpicon", b.toString());
            }
            if ((logoffIconStatus = p.request.getParameter("logofficon")) != null && logoffIconStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set globallink logofficon mode to " + logoffIconStatus);
                Boolean b = Boolean.valueOf(logoffIconStatus);
                session.setAttribute("__jfc_globallink_logofficon", (Object)b);
                p.user.setPreferenceItem("__jfc_globallink_logofficon", b.toString());
            }
            if ((submenuStatus = p.request.getParameter("submenu")) != null && submenuStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set submenu mode to " + submenuStatus);
                Boolean b = Boolean.valueOf(submenuStatus);
                session.setAttribute("__jfc_submenu_mode", (Object)b);
                p.user.setPreferenceItem("__jfc_submenu_mode", b.toString());
                Menubar menubar = (Menubar)p.request.getAttribute("__jfc_menubar");
                if (menubar == null && Boolean.valueOf(submenuStatus).booleanValue()) {
                    JFCAppMenu ap = JFCAppMenu.getInstance(this.getAppmenu());
                    menubar = ap.getMenubar(p.user, this.getJfcConfig().getJspEncoding(), p.locale);
                    p.request.setAttribute("__jfc_menubar", (Object)menubar);
                }
            }
            if ((pankuzuStatus = p.request.getParameter("pankuzu")) != null && pankuzuStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set pankuzu mode to " + pankuzuStatus);
                Boolean b = Boolean.valueOf(pankuzuStatus);
                session.setAttribute("__jfc_pankuzu_mode", (Object)b);
                p.user.setPreferenceItem("__jfc_pankuzu_mode", b.toString());
            }
            if ((bottomAreaStatus = p.request.getParameter("bottomarea")) != null && bottomAreaStatus.length() > 0) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set bottom area mode to " + bottomAreaStatus);
                Boolean b = Boolean.valueOf(bottomAreaStatus);
                session.setAttribute("__jfc_bottomarea_mode", (Object)b);
                p.user.setPreferenceItem("__jfc_bottomarea_mode", b.toString());
            }
            String passwordReminderStatus = p.request.getParameter("passwordReminder");
            String email4passwordReminder = p.request.getParameter("passwordReminderEMail");
            if (StringUtils.isNotBlank((CharSequence)passwordReminderStatus)) {
                this.checkSessionId(p);
                logger.debug(this.getLogHeader(p) + "Set passwordReminder to " + passwordReminderStatus);
                Boolean passwordReminderStatusFlag = Boolean.valueOf(passwordReminderStatus);
                session.setAttribute("__jfc_passwordReminder", (Object)passwordReminderStatusFlag);
                if (!passwordReminderStatusFlag.booleanValue()) {
                    email4passwordReminder = "";
                    Item item = p.user.getPreferenceItem("__jfc_passwordReminder");
                    if (item != null && Boolean.parseBoolean(item.getContent())) {
                        p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.remindpassword.donotuse", p.locale));
                        p.request.setAttribute("__jfc_jfcerrors", (Object)p.errors);
                    }
                } else {
                    email4passwordReminder = StringUtil.getValueAsNormalizedAlphabet((String)email4passwordReminder);
                }
                p.request.setAttribute("passwordReminderEMailAddress", (Object)email4passwordReminder);
                if (StringUtils.isNotBlank((CharSequence)email4passwordReminder) && !MimeMailUtilities.isValidInternetAddress((String)email4passwordReminder)) {
                    Object[] o = new Object[]{JFCUtils.getRValue("__jfc_common.preference.select.passwordReminder", p.locale)};
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.input.mailaddress", o, p.locale));
                    p.request.setAttribute("__jfc_jfcerrors", (Object)p.errors);
                    p.request.setAttribute("inputfieldclass", (Object)"errorfield_nowidth");
                    return "userPreference.input";
                }
                p.user.setPreferenceItem("__jfc_passwordReminder", passwordReminderStatusFlag.toString());
                p.user.setPreferenceItem("__jfc_passwordReminderEMailAddress", email4passwordReminder);
            } else {
                Item item = p.user.getPreferenceItem("__jfc_passwordReminder");
                if (item != null) {
                    passwordReminderStatus = item.getContent();
                    Boolean passwordReminderStatusFlag = Boolean.valueOf(passwordReminderStatus);
                    session.setAttribute("__jfc_passwordReminder", (Object)passwordReminderStatusFlag);
                    if (passwordReminderStatusFlag.booleanValue()) {
                        item = p.user.getPreferenceItem("__jfc_passwordReminderEMailAddress");
                        p.request.setAttribute("passwordReminderEMailAddress", (Object)item.getContent());
                    } else {
                        p.request.setAttribute("passwordReminderEMailAddress", (Object)"");
                    }
                } else {
                    session.setAttribute("__jfc_passwordReminder", (Object)Boolean.FALSE);
                    p.request.setAttribute("passwordReminderEMailAddress", (Object)"");
                }
            }
            String calendarFirstDayOfWeek = p.request.getParameter("jfcCalendarFirstDayOfWeek");
            if (StringUtils.isNotBlank((CharSequence)calendarFirstDayOfWeek)) {
                this.checkSessionId(p);
                session.setAttribute("__jfc_calendarFirstDayOfWeek", (Object)calendarFirstDayOfWeek);
                p.user.setPreferenceItem("__jfc_calendarFirstDayOfWeek", calendarFirstDayOfWeek);
            }
            if (StringUtils.isNotBlank((CharSequence)(submenuDisplayArea = p.request.getParameter("jfcSubmenuDisplayArea")))) {
                this.checkSessionId(p);
                session.setAttribute("__jfc_submenu_displayArea", (Object)submenuDisplayArea);
                p.user.setPreferenceItem("__jfc_submenu_displayArea", submenuDisplayArea);
            }
            this.setLanguage(p);
            String raction = this.getLatestPankuzu(p);
            if (p.request.getSession().getAttribute("__jfc_locale") == null) {
                forward = "redirect:userPreference.do";
                JFCAppMenu jfcAppMenu = JFCAppMenu.getInstance(this.getAppmenu());
                jfcAppMenu.clearUserMenubar(p.user);
            } else {
                String name;
                forward = "userPreference".equals(p.referrer) ? "userPreference.input" : ("mainMenu".equals(p.referrer) ? ("userPreference".equals(name = p.request.getParameter("name")) ? "userPreference.input" : "forward:/" + raction) : "forward:/" + raction);
            }
        }
        return forward;
    }

    protected void setLanguage(ActionParameter p) {
        String language = p.request.getParameter("language");
        if (StringUtils.isBlank((CharSequence)language)) {
            return;
        }
        this.checkSessionId(p);
        String locale = JFCUtils.getLocaleStringByAcceptLanguage(language);
        p.user.setPreferenceItem("locale", locale);
        p.request.getSession().removeAttribute("__jfc_locale");
    }

    private String checkSessionId(ActionParameter p) {
        if (!super.isClientSessionIdValid(p)) {
            if (this.isNewLogon(p.request)) {
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.session.expired.update", p.locale));
                return "logon.afterLogon";
            }
            logger.log(LogCodeManager.getPriority(LogCode.JFC00102), LogCodeManager.getMessage(LogCode.JFC00102, p.user, new String[0]));
            throw new SecurityException();
        }
        return null;
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        return true;
    }

    public static void clearSessionCache(HttpSession session) {
        session.removeAttribute("__jfc_cssfilename");
        session.removeAttribute("__jfc_fontsizefilename");
        session.removeAttribute("__jfc_layoutType");
        session.removeAttribute("__jfc_globallink_menuicon");
        session.removeAttribute("__jfc_globallink_helpicon");
        session.removeAttribute("__jfc_globallink_logofficon");
        session.removeAttribute("__jfc_submenu_mode");
        session.removeAttribute("__jfc_pankuzu_mode");
        session.removeAttribute("__jfc_bottomarea_mode");
        session.removeAttribute("__jfc_passwordReminder");
        session.removeAttribute("__jfc_calendarFirstDayOfWeek");
        session.removeAttribute("__jfc_submenu_displayArea");
    }
}

