/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.charset;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Charsets {
    EUCJP("EUC-JP"),
    ISO2022JP("ISO-2022-JP"),
    Shift_JIS,
    ASCII("US-ASCII"),
    UTF8("UTF-8"),
    UTF16("UTF-16"),
    Windows31J("windows-31j");

    private static final Logger logger;
    private Charset charset = null;

    private Charsets() {
        this.setCharset(this.toString());
    }

    private Charsets(String charset) {
        this.setCharset(charset);
    }

    private void setCharset(String charset) {
        Charset cs = null;
        try {
            cs = Charset.forName(charset);
            if (!charset.equals(cs.name()) && !this.ignore(charset, cs)) {
                throw new IllegalArgumentException("parameter charset must be charset's canonical name. [ charset : " + charset + ", canonical name : " + cs.name() + "]");
            }
        }
        catch (UnsupportedCharsetException uce) {
            cs = null;
        }
        this.charset = cs;
    }

    private boolean ignore(String canonicalName, Charset cs) {
        String mappings = System.getProperty("sun.nio.cs.map");
        String combination = cs.name() + "/" + canonicalName;
        return mappings.toLowerCase().contains(combination.toLowerCase());
    }

    public Charset charset() {
        if (this.charset == null) {
            throw new UnsupportedCharsetException(this.toString());
        }
        return this.charset;
    }

    public static Charsets charsetsValue(Charset charset) {
        if (charset == null) {
            return null;
        }
        for (Charsets cs : Charsets.values()) {
            try {
                if (!charset.equals(cs.charset())) continue;
                return cs;
            }
            catch (UnsupportedCharsetException uce) {
                // empty catch block
            }
        }
        return null;
    }

    public static Charsets charsetsValue(String charset) {
        if (StringUtils.isBlank((String)charset)) {
            return null;
        }
        return Charsets.charsetsValue(Charset.forName(charset));
    }

    static {
        logger = LogManager.getLogger(Charsets.class);
    }
}

