/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.group;

import jp.jasminesoft.jfc.core.group.ElementUtils;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.model.juser.Juser;

public abstract class By {
    public static By userid(String ... userids) {
        return new ByUserId(userids);
    }

    public static By jgroupId(Integer ... jgroupids) {
        return new ByJgroupId(jgroupids);
    }

    public static By principal(String ... principals) {
        return new ByPrincipal(principals);
    }

    public static By principalId(Integer ... principalIds) {
        return new ByPrincipalId(principalIds);
    }

    public PropertyMeta<String> useridMeta() {
        return (PropertyMeta)ReflectionUtils.getPrivateField(StoreModelUtils.meta(Juser.class), "userid");
    }

    public MultiPropertyMeta<Integer> jgroupidMeta() {
        return (MultiPropertyMeta)ReflectionUtils.getPrivateField(StoreModelUtils.meta(Juser.class), "jgroupid");
    }

    public MultiPropertyMeta<Integer> jprincipalIdMeta() {
        return (MultiPropertyMeta)ReflectionUtils.getPrivateField(StoreModelUtils.meta(Juser.class), "jprincipalId");
    }

    public abstract void addCriterion(DetachedCriteria var1);

    public static class ByPrincipalId
    extends By {
        protected Integer[] principalIds;

        public ByPrincipalId(Integer ... principalIds) {
            this.principalIds = principalIds;
        }

        @Override
        public void addCriterion(DetachedCriteria criteria) {
            criteria.eq(this.jprincipalIdMeta(), this.principalIds);
        }
    }

    public static class ByPrincipal
    extends By {
        protected String[] principals;

        public ByPrincipal(String ... principals) {
            this.principals = principals;
        }

        @Override
        public void addCriterion(DetachedCriteria criteria) {
            criteria.eq(this.jprincipalIdMeta(), ElementUtils.getJprincipalIds(this.principals));
        }
    }

    public static class ByJgroupId
    extends By {
        protected Integer[] jgroupIds;

        public ByJgroupId(Integer ... jgroupIds) {
            this.jgroupIds = jgroupIds;
        }

        @Override
        public void addCriterion(DetachedCriteria criteria) {
            criteria.eq(this.jgroupidMeta(), this.jgroupIds);
        }
    }

    public static class ByUserId
    extends By {
        protected String[] userIds;

        public ByUserId(String ... userIds) {
            this.userIds = userIds;
        }

        @Override
        public void addCriterion(DetachedCriteria criteria) {
            criteria.eq(this.useridMeta(), this.userIds);
        }
    }
}

