/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.group;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.core.group.By;
import jp.jasminesoft.jfc.core.group.ElementUtils;
import jp.jasminesoft.jfc.core.group.GroupElement;
import jp.jasminesoft.jfc.core.group.UserElement;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.model.juser.Juser;
import org.springframework.context.ApplicationContext;

public class UserElementList
implements UserElement {
    private ApplicationContext appctx;
    private Juser[] jusers;

    public UserElementList(ApplicationContext appctx, Juser[] jusers) {
        this.appctx = appctx;
        this.jusers = jusers;
    }

    public Juser[] getJuser() {
        return this.jusers;
    }

    @Override
    public GroupElement group() {
        Integer[] jgroupids = (Integer[])Stream.of(this.jusers).flatMap(juser -> Stream.of(juser.getJgroupidAsInteger())).toArray(Integer[]::new);
        return ElementUtils.getGroupElement(this.appctx, jgroupids);
    }

    @Override
    public String name() {
        return Stream.of(this.jusers).map(juser -> juser.getUserid()).collect(Collectors.joining("|"));
    }

    @Override
    public String[] userid() {
        return (String[])Stream.of(this.jusers).map(juser -> juser.getUserid()).toArray(String[]::new);
    }

    @Override
    public UserElement find(By ... bys) {
        return ElementUtils.getUserElement(this.appctx, (By[])ArrayUtils.add((Object[])bys, (Object)By.userid(this.userid())));
    }

    @Override
    public int size() {
        return this.jusers.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.jusers);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        UserElementList other = (UserElementList)obj;
        return Arrays.equals(this.jusers, other.jusers);
    }

    public String toString() {
        return "UserElementList [jusers=" + Arrays.toString(this.jusers) + "]";
    }
}

