/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.FilterManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.validator.CtValidator;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class JFCJsonDeserializer<E extends ContainerBase<E>>
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected HttpServletRequest request;
    private String modelId;
    private String fieldName;

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        this.fieldName = property.getName();
        this.modelId = this.getModelId(property);
        return this;
    }

    private String getModelId(BeanProperty property) {
        return StoreModelUtils.getModelId(property.getMember().getDeclaringClass());
    }

    public Object deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ActionParameter p = this.createActionParameter();
        PropertyMetaBase<?> meta = StoreModelUtils.meta(this.modelId, p).propertyMeta(this.fieldName);
        if (meta instanceof MultiPropertyMeta) {
            return this.deserialize((MultiPropertyMeta)meta, parser, ctxt, p);
        }
        String stringValue = this.filter(meta, parser.getText(), p);
        this.validate(meta, stringValue, p);
        return StoreModelUtils.convertTypeValue(meta, stringValue);
    }

    private ActionParameter createActionParameter() {
        Jfcerrors errors = null;
        errors = (Jfcerrors)this.request.getAttribute("__jfc_jfcerrors");
        if (errors == null) {
            errors = new Jfcerrors();
            this.request.setAttribute("__jfc_jfcerrors", (Object)errors);
        }
        ActionParameter p = JFCUtils.createActionParameter(null, null, null, errors, this.applicationContext);
        return p;
    }

    private List<?> deserialize(MultiPropertyMeta<?> meta, JsonParser parser, DeserializationContext ctxt, ActionParameter p) {
        try {
            ValueInstantiator valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(null, ArrayList.class);
            Collection results = new StringCollectionDeserializer(null, null, valueInstantiator).deserialize(parser, ctxt);
            return StoreModelUtils.convertTypeValue(meta, this.filter(meta, results, p));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String filter(PropertyMetaBase<?> meta, String value, ActionParameter p) {
        return ((FilterManager)p.appctx.getBean("filterManager", FilterManager.class)).filter(meta, value);
    }

    protected Collection<String> filter(MultiPropertyMeta<?> meta, Collection<String> values, ActionParameter p) {
        return ((FilterManager)p.appctx.getBean("filterManager", FilterManager.class)).filter(meta, values);
    }

    protected void validate(PropertyMetaBase<?> meta, String value, ActionParameter p) {
        ((CtValidator)p.appctx.getBean(StoreModelUtils.validatorName(this.modelId), CtValidator.class)).validate(meta, value, p);
    }
}

