/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.spring.security;

import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoBase;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.service.JfcConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LogonFailureEventListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    private static final Logger logger = LogManager.getLogger(LogonFailureEventListener.class);
    @Autowired
    protected SecurityProperties securityProperties;
    @Autowired
    protected JfcConfig jfcConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        if (event.getException().getClass().equals(UsernameNotFoundException.class)) {
            return;
        }
        int passwordMaxFailureCount = this.jfcConfig.getUserinfoFailedpasswordCount();
        if (passwordMaxFailureCount <= 0) {
            return;
        }
        UserInfo userinfo = UserInfoFactory.getUserInfo();
        if (userinfo == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00012), LogCodeManager.getMessage(LogCode.JFC00012, new String[0]));
            return;
        }
        String username = (String)event.getAuthentication().getPrincipal();
        try {
            UserInfoBase userinfobase = (UserInfoBase)userinfo;
            IJuser juser = userinfobase.getJuser(username);
            if (juser == null) {
                return;
            }
            if (juser.getPasswdErrCount() < 1) {
                juser.setPasswdErrCount(1);
            } else {
                juser.setPasswdErrCount(juser.getPasswdErrCount() + 1);
            }
            userinfobase.updateJuser(juser);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00011), LogCodeManager.getMessage(LogCode.JFC00011, username));
        }
        finally {
            userinfo.close();
        }
    }
}

