/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.spring.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionRedirectStrategy;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.error.Jfcerrors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class MultipleSessionLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger logger = LogManager.getLogger(MultipleSessionLoginUrlAuthenticationEntryPoint.class);
    protected RedirectStrategy redirectStrategy = new MultipleSessionRedirectStrategy();

    public MultipleSessionLoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.addAutoLogoffMessage(request);
        this.redirectStrategy.sendRedirect(request, response, this.determineUrlToUseForThisRequest(request, response, authException));
    }

    private void addAutoLogoffMessage(HttpServletRequest request) {
        if (this.isUseForward()) {
            return;
        }
        if (!this.isRequestedSessionInvalid(request)) {
            return;
        }
        if ("/logoff.do".equals(request.getServletPath())) {
            return;
        }
        JFCErrorManager errorManager = ClassUtils.newInstance(JFCErrorManager.class);
        Jfcerrors errors = (Jfcerrors)request.getSession(true).getAttribute("__jfc_jfcerrors");
        if (errors == null) {
            errors = new Jfcerrors();
            request.getSession(true).setAttribute("__jfc_jfcerrors", (Object)errors);
        }
        errors.addJfcerror(errorManager.getJfcerror("error.session.timeout", JFCUtils.getLocaleString(request)));
        String username = "";
        logger.log(LogCodeManager.getPriority(LogCode.JFC00023), LogCodeManager.getMessage(LogCode.JFC00023, username));
    }

    private boolean isRequestedSessionInvalid(HttpServletRequest request) {
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }
}

