/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.velocity;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import jp.jasminesoft.jfc.core.charset.Charsets;
import jp.jasminesoft.jfc.core.resources.PropertiesFactory;
import jp.jasminesoft.jfc.core.resources.PropertyUtils;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public final class JFCVelocityEngine
extends VelocityEngine {
    private static final Logger logger = LogManager.getLogger(JFCVelocityEngine.class);
    public static final String USER_PROPERTIES_FILE_PATH = "/jp/jasminesoft/jfc/core/support/velocity/velocity.properties";
    private static final Properties SYSTEM_DEFAULT_PROPERTIES = new Properties();

    public JFCVelocityEngine() {
        this.setJFCExtendedProperties();
    }

    public JFCVelocityEngine(String propsFilename) {
        this.setJFCExtendedProperties();
        this.init(propsFilename);
    }

    public JFCVelocityEngine(Properties p) {
        this.setJFCExtendedProperties();
        this.init(p);
    }

    protected void setJFCExtendedProperties() {
        Properties userProperties = this.getUserDefaultProperties();
        Properties prop = PropertyUtils.combine(SYSTEM_DEFAULT_PROPERTIES, userProperties);
        this.setExtendedProperties(ExtendedProperties.convertProperties((Properties)prop));
    }

    protected Properties getUserDefaultProperties() {
        Properties userporperties = null;
        try {
            userporperties = (Properties)PropertiesFactory.getInstance().get(USER_PROPERTIES_FILE_PATH);
        }
        catch (FileNotFoundException fnfe) {
            logger.debug((Object)fnfe);
        }
        catch (IOException e) {
            throw new VelocityException(e.toString(), (Throwable)e);
        }
        return userporperties;
    }

    public void init(Properties p) {
        if (p == null) {
            this.init();
            return;
        }
        super.init(p);
    }

    public void init(String propsFilename) {
        if (StringUtils.isBlank((String)propsFilename)) {
            this.init();
            return;
        }
        super.init(propsFilename);
    }

    public Template getTemplate(String name) {
        this.init();
        if (name != null) {
            name = name.replaceAll("/+", "/");
        }
        return super.getTemplate(name);
    }

    static {
        SYSTEM_DEFAULT_PROPERTIES.put("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.CommonsLogLogChute");
        SYSTEM_DEFAULT_PROPERTIES.put("input.encoding", Charsets.UTF8.charset().name());
        SYSTEM_DEFAULT_PROPERTIES.put("output.encoding", Charsets.UTF8.charset().name());
        SYSTEM_DEFAULT_PROPERTIES.put("resource.loader", "file, class");
        SYSTEM_DEFAULT_PROPERTIES.put("class.resource.loader.class", ClasspathResourceLoader.class.getName());
    }
}

