/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.xml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.util.XMLUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtils {
    private static final Logger logger = LogManager.getLogger(DomUtils.class);

    protected DomUtils() {
    }

    public static Document makeDocument(String content) throws ParserConfigurationException {
        return DomUtils.makeDocument(new InputSource(new StringReader(XMLUtil.removeInvalidCharacter((String)content))));
    }

    public static Document makeDocument(File file) throws ParserConfigurationException {
        InputSource inputSource = new InputSource(file.toURI().toASCIIString());
        return DomUtils.makeDocument(inputSource);
    }

    public static Document makeDocument(InputSource inputSource) throws ParserConfigurationException {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try {
            doc = builder.parse(inputSource);
        }
        catch (SAXException e) {
            throw new ParserConfigurationException(e.getMessage());
        }
        catch (IOException e) {
            throw new ParserConfigurationException(e.getMessage());
        }
        return doc;
    }

    public static Document createWrappedDocument(String wrapElementName, String ... contents) throws ParserConfigurationException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        sb.append("<").append(wrapElementName).append(">");
        for (String content : contents) {
            int ptr = content.indexOf("?>");
            if (ptr <= 0) continue;
            sb.append(content.substring(ptr + 2));
        }
        sb.append("</").append(wrapElementName).append(">");
        return DomUtils.makeDocument(sb.toString());
    }
}

