/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Stack;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.JFCHibernateDao;
import jp.jasminesoft.jfc.meta.ContainerMeta;
import jp.jasminesoft.jfc.meta.ContainerPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCAbstractEntityService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    private static final Logger logger = LogManager.getLogger(ClassUtils.class);
    public static final String JAVA_FILE_EXTENSION = "java";

    protected ClassUtils() {
    }

    public static String getPackageDir(Class<?> clazz) {
        return ClassUtils.getPackageDir(clazz, '/');
    }

    public static String getPackageDir(Class<?> clazz, char separator) {
        return ClassUtils.getPackageName(clazz).replace('.', separator);
    }

    public static String getJavaFilePath(Class<?> clazz) {
        return ClassUtils.getJavaFilePath(clazz, '/');
    }

    public static String getJavaFilePath(Class<?> clazz, char separator) {
        return ClassUtils.getJavaFilePath(clazz.getCanonicalName(), separator);
    }

    public static String getJavaFilePath(String canonicalName) {
        return ClassUtils.getJavaFilePath(canonicalName, '/');
    }

    public static String getJavaFilePath(String canonicalName, char separator) {
        return canonicalName.replace('.', separator) + "." + JAVA_FILE_EXTENSION;
    }

    public static <E> Class<E> getDaoEntityClass(Class<? extends JFCHibernateDao<?, ?>> clazz) {
        return ClassUtils.getGenericType(clazz, JFCHibernateDao.class, "E");
    }

    public static <E> Class<E> getServiceEntityClass(Class<? extends JFCAbstractEntityService<?, ?>> clazz) {
        return ClassUtils.getGenericType(clazz, JFCAbstractEntityService.class, "E");
    }

    public static <E> Class<E> getCriteriaConverterConditionClass(Class<? extends CriteriaConverter<?>> clazz) {
        return ClassUtils.getGenericType(clazz, CriteriaConverter.class, "C");
    }

    public static <E, T> Class<E> getGenericType(Class<? extends T> clazz, Class<T> targetClass, String targetTypeName) {
        Stack stack = new Stack();
        while (!targetClass.equals(clazz.getSuperclass())) {
            stack.push(clazz);
            clazz = clazz.getSuperclass();
        }
        return ClassUtils.getGenericType(clazz, targetTypeName, stack);
    }

    private static <E, T> Class<E> getGenericType(Class<? extends T> clazz, String targetTypeName, Stack<Class<?>> stack) {
        TypeVariable<Class<? extends T>>[] typeParameters = clazz.getSuperclass().getTypeParameters();
        Type[] actualTypes = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        Type actualType = null;
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!targetTypeName.equals(typeParameters[i].getName())) continue;
            actualType = actualTypes[i];
        }
        if (actualType == null) {
            return null;
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            Class<?> subClass = stack.pop();
            return ClassUtils.getGenericType(subClass, typeVariable.getName(), stack);
        }
        if (actualType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualType;
            return (Class)parameterizedType.getRawType();
        }
        return null;
    }

    public static <P> Class<P> getTypeClass(PropertyMetaBase<P> meta) {
        if (meta == null) {
            return null;
        }
        Class<?> parentClass = null;
        parentClass = meta instanceof ContainerPropertyMeta ? ((ContainerPropertyMeta)meta).parent().containerClass() : meta.entityMeta().entityClass();
        Type type = null;
        try {
            type = parentClass.getDeclaredField(meta.name()).getGenericType();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        Class clazz = null;
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            clazz = (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return ClassUtils.primitiveToWrapper((Class)clazz);
    }

    public static <P extends ContainerBase<P>> Class<P> getTypeClass(ContainerMeta<P> meta) {
        if (meta == null) {
            return null;
        }
        return meta.containerClass();
    }

    public static <E> E newInstance(Class<E> clazz) {
        return (E)jp.jasminesoft.util.ClassUtils.newInstance(clazz);
    }

    public static final String getProperReturnType(Class<?> clazz) {
        return jp.jasminesoft.util.ClassUtils.getProperReturnType(clazz);
    }

    public static <E> E newInstanceByCopyConstructor(E obj) {
        return (E)jp.jasminesoft.util.ClassUtils.newInstanceByCopyConstructor(obj);
    }

    public static <E> E newInstanceByCopyConstructor(Class<E> clazz, E obj) {
        return (E)jp.jasminesoft.util.ClassUtils.newInstanceByCopyConstructor(clazz, obj);
    }
}

