/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.util;

import java.io.File;
import java.io.IOException;
import jp.jasminesoft.jfc.core.charset.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.taskdefs.Sync;
import org.apache.tools.ant.taskdefs.Untar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    protected FileUtils() {
    }

    protected static Project createProject() {
        Project project = new Project();
        project.init();
        return project;
    }

    public static void copy(String srcDir, String includes, String excludes, String destDir, boolean overwrite) {
        FileUtils.copy(new File(srcDir), includes, excludes, new File(destDir), overwrite);
    }

    public static void copy(File srcDir, String includes, String excludes, File destDir, boolean overwrite) {
        try {
            Copy copy = new Copy();
            copy.setProject(FileUtils.createProject());
            copy.setPreserveLastModified(true);
            copy.setTodir(destDir.getCanonicalFile());
            copy.setOverwrite(true);
            FileSet fileset = new FileSet();
            fileset.setDir(srcDir.getCanonicalFile());
            if (StringUtils.isNotBlank((CharSequence)includes)) {
                fileset.setIncludes(includes);
            }
            if (StringUtils.isNotBlank((CharSequence)excludes)) {
                fileset.setExcludes(excludes);
            }
            copy.addFileset(fileset);
            copy.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sync(File srcDir, File destDir, String includes1, String excludes1, String includes2, String excludes2) {
        try {
            Sync copy = new Sync();
            copy.setProject(FileUtils.createProject());
            copy.init();
            copy.setTodir(destDir.getCanonicalFile());
            copy.setIncludeEmptyDirs(true);
            copy.setOverwrite(true);
            FileSet fileset1 = new FileSet();
            fileset1.setDir(srcDir.getCanonicalFile());
            if (StringUtils.isNotBlank((CharSequence)includes1)) {
                fileset1.setIncludes(includes1);
            }
            if (StringUtils.isNotBlank((CharSequence)excludes1)) {
                fileset1.setExcludes(excludes1);
            }
            copy.addFileset(fileset1);
            if (StringUtils.isNotBlank((CharSequence)includes2) || StringUtils.isNotBlank((CharSequence)excludes2)) {
                FileSet fileset2 = new FileSet();
                fileset2.setDir(srcDir.getCanonicalFile());
                if (StringUtils.isNotBlank((CharSequence)includes2)) {
                    fileset2.setIncludes(includes2);
                }
                if (StringUtils.isNotBlank((CharSequence)excludes2)) {
                    fileset2.setExcludes(excludes2);
                }
                copy.addFileset(fileset2);
            }
            copy.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void move(String srcDir, String includes, String excludes, String destDir, boolean overwrite) {
        FileUtils.move(new File(srcDir), includes, excludes, new File(destDir), overwrite);
    }

    public static void move(File srcDir, String includes, String excludes, File destDir, boolean overwrite) {
        try {
            Move move = new Move();
            move.setProject(FileUtils.createProject());
            move.setPreserveLastModified(true);
            move.setTodir(destDir.getCanonicalFile());
            move.setOverwrite(true);
            FileSet fileset = new FileSet();
            fileset.setDir(srcDir.getCanonicalFile());
            if (StringUtils.isNotBlank((CharSequence)includes)) {
                fileset.setIncludes(includes);
            }
            if (StringUtils.isNotBlank((CharSequence)excludes)) {
                fileset.setExcludes(excludes);
            }
            move.addFileset(fileset);
            move.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unzip(File zipFile, String includes, String excludes, File destDir) {
        FileUtils.unzip(zipFile, FileUtils.createPatternSet(includes, excludes), destDir);
    }

    protected static PatternSet createPatternSet(String includes, String excludes) {
        if (StringUtils.isBlank((CharSequence)includes) && StringUtils.isBlank((CharSequence)excludes)) {
            return null;
        }
        PatternSet patternSet = new PatternSet();
        if (StringUtils.isNotBlank((CharSequence)includes)) {
            patternSet.setIncludes(includes);
        }
        if (StringUtils.isNotBlank((CharSequence)excludes)) {
            patternSet.setExcludes(excludes);
        }
        return patternSet;
    }

    public static void unzip(File zipFile, PatternSet patternSet, File destDir) {
        try {
            Expand unzip = new Expand();
            unzip.setTaskType("unzip");
            unzip.setTaskName("unzip");
            unzip.setOwningTarget(new Target());
            unzip.setProject(FileUtils.createProject());
            unzip.setSrc(zipFile.getCanonicalFile());
            unzip.setDest(destDir.getCanonicalFile());
            if (patternSet != null) {
                unzip.addPatternset(patternSet);
            }
            unzip.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void untar(File tgzFile, String includes, String excludes, File destDir) {
        FileUtils.untar(tgzFile, FileUtils.createPatternSet(includes, excludes), destDir);
    }

    public static void untar(File tgzFile, PatternSet patternSet, File destDir) {
        try {
            Untar untar = new Untar();
            untar.setProject(FileUtils.createProject());
            Untar.UntarCompressionMethod compression = new Untar.UntarCompressionMethod();
            compression.setValue("gzip");
            untar.setCompression(compression);
            untar.setSrc(tgzFile.getCanonicalFile());
            untar.setDest(destDir.getCanonicalFile());
            if (patternSet != null) {
                untar.addPatternset(patternSet);
            }
            untar.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zip(File basedir, File destFile) {
        FileUtils.zip(basedir, null, null, destFile);
    }

    public static void zip(File basedir, String includes, String excludes, File destFile) {
        Zip zip = new Zip();
        zip.setProject(FileUtils.createProject());
        zip.setBasedir(basedir);
        zip.setIncludes(includes);
        zip.setExcludes(excludes);
        zip.setDestFile(destFile);
        zip.setUpdate(true);
        zip.setEncoding(Charsets.UTF8.name());
        zip.execute();
    }

    public static void jar(File srcDir, File destFile, String includes1, String excludes1) throws BuildException, IOException {
        Jar zip = new Jar();
        zip.setProject(FileUtils.createProject());
        zip.setDestFile(destFile);
        zip.setUpdate(false);
        zip.setEncoding(Charsets.UTF8.name());
        FileSet fileset1 = new FileSet();
        fileset1.setDir(srcDir.getCanonicalFile());
        if (StringUtils.isNotBlank((CharSequence)includes1)) {
            fileset1.setIncludes(includes1);
        }
        if (StringUtils.isNotBlank((CharSequence)excludes1)) {
            fileset1.setExcludes(excludes1);
        }
        zip.addFileset(fileset1);
        zip.execute();
    }
}

