/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.validator;

import java.util.function.BiFunction;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.util.AbstractChartype;
import jp.jasminesoft.util.CtAnyCharacter;
import jp.jasminesoft.util.CtWildcard;
import jp.jasminesoft.util.SingleChartype;
import jp.jasminesoft.util.StringCheck;

public abstract class CtValidator {
    public abstract void validate(PropertyMetaBase<?> var1, String var2, ActionParameter var3);

    public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p, AbstractChartype ... chartypes) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        if (StringCheck.checkChartype((String)value, (AbstractChartype[])chartypes)) {
            return;
        }
        this.setErrorMessage(meta, p, chartypes);
    }

    public void setErrorMessage(PropertyMetaBase<?> meta, final ActionParameter p, AbstractChartype ... chartypes) {
        final JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        final String keyBase = StoreModelUtils.getModelId(meta.entityMeta().entityClass()) + "." + meta.itemName();
        Object[] o = new Object[]{JFCUtils.getRValue(keyBase, p.locale)};
        Jfcerror jfcerror = new Jfcerror();
        jfcerror.setCode("error.input.chartype");
        BiFunction<String, Object[], String> messages = new BiFunction<String, Object[], String>(){

            @Override
            public String apply(String key, Object[] o) {
                return errorManager.getJfcerror(keyBase + ".error.input.chartype." + key, o, p.locale).getContent();
            }
        };
        if (chartypes.length == 1 && chartypes[0] instanceof SingleChartype) {
            jfcerror.setContent((String)messages.apply(chartypes[0].resourceKey(), o));
            p.errors.addJfcerror(jfcerror);
            return;
        }
        StringBuilder content = new StringBuilder().append(errorManager.getJfcerror(keyBase + ".error.input.chartype", o, p.locale).getContent()).append(" [ ");
        for (AbstractChartype ctype : chartypes) {
            if (ctype instanceof CtWildcard) continue;
            content.append((String)messages.apply(ctype.resourceKey(), null));
            if (ctype instanceof CtAnyCharacter) {
                content.append(" '" + String.valueOf(ctype.getChartypeArray()) + "'");
            }
            if (ctype.getMinlength() != -1) {
                content.append((String)messages.apply("morethan", new Object[]{ctype.getMinlength()}));
            }
            if (ctype.getMaxlength() != -1) {
                content.append((String)messages.apply("lessthan", new Object[]{ctype.getMinlength()}));
            }
            content.append((String)messages.apply("endchar", null));
        }
        content.append(" ] ");
        jfcerror.setContent(content.toString());
        p.errors.addJfcerror(jfcerror);
    }
}

