/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.DataBindingContext;
import jp.jasminesoft.jfc.dao.SortKey;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.util.ClassUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class FinderContext<C>
extends DataBindingContext {
    protected C condition;
    private static final int INIT_ROW_COUNT = 0;
    protected int firstResult = 0;
    protected int pageSize = 0;
    protected int rowCount = 0;
    protected boolean isProcess = false;
    protected SortKey sortKey;
    private CriteriaConverter<C> criteriaConverter;

    public FinderContext() {
    }

    public FinderContext(FinderContext<C> source) {
        try {
            final List<String> ignoreProperties = Arrays.asList("pageNumber");
            new PropertyUtilsBean(){

                public boolean isReadable(Object bean, String name) {
                    if (ignoreProperties.contains(name)) {
                        return false;
                    }
                    return super.isReadable(bean, name);
                }
            }.copyProperties((Object)this, source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (this.isImmutableCondition(source.getCondition())) {
            this.setCondition(source.getCondition());
        } else {
            this.setCondition(ClassUtils.newInstanceByCopyConstructor(source.getCondition()));
        }
        if (source.getSortKey() != null) {
            this.setSortKey(new SortKey(source.getSortKey()));
        }
    }

    private boolean isImmutableCondition(C obj) {
        return obj instanceof Byte || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof String;
    }

    public void setCondition(C condition) {
        this.condition = condition;
    }

    public C getCondition() {
        return this.condition;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        if (firstResult < 0) {
            firstResult = 0;
        }
        this.firstResult = firstResult;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 0) {
            pageSize = 0;
        }
        this.pageSize = pageSize;
    }

    public SortKey getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(SortKey sortKey) {
        this.sortKey = sortKey;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getPageNumber() {
        if (this.pageSize == 0) {
            return 1;
        }
        return this.firstResult / this.pageSize + 1;
    }

    public void setPageNumber(int pageNumber) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.setFirstResult((pageNumber - 1) * this.pageSize);
    }

    public void updateCount(int size, CountUpdator countUpdator) {
        if (this.pageSize == 0 || size < this.pageSize) {
            this.updateCount((this.getPageNumber() - 1) * this.pageSize + size);
            return;
        }
        if (this.rowCount != 0 && this.rowCount < (this.getPageNumber() - 1) * this.pageSize + size) {
            this.updateCount((this.getPageNumber() - 1) * this.pageSize + size);
            return;
        }
        if (this.rowCount == 0) {
            this.updateCount(countUpdator.count());
            return;
        }
    }

    public void updateCount(int count) {
        this.rowCount = count;
        this.isProcess = true;
    }

    public void setCriteriaConverter(CriteriaConverter<C> criteriaConverter) {
        this.criteriaConverter = criteriaConverter;
    }

    public CriteriaConverter<C> getCriteriaConverter() {
        return this.criteriaConverter;
    }

    public DetachedCriteria criteria() {
        return this.criteria(false);
    }

    public DetachedCriteria criteria(boolean rowCountQuery) {
        SortKey skey = this.sortKey;
        if (rowCountQuery) {
            skey = this.sortKey == null ? new SortKey() : new SortKey(this.sortKey);
            skey.setRowCountQuery(true);
        }
        return this.criteriaConverter.convert(this.condition, skey);
    }

    public boolean isBlankCondition() {
        return this.criteriaConverter.isBlankCondition(this.condition);
    }

    public void reset() {
        this.firstResult = 0;
        this.resetRowCount();
    }

    public void resetRowCount() {
        this.rowCount = 0;
        this.isProcess = false;
    }

    public void next() {
        int next = this.getNext();
        if (next == this.getRowCount()) {
            this.last();
        } else {
            this.setFirstResult(next);
        }
    }

    public void prev() {
        this.setFirstResult(this.getPrev());
    }

    public void first() {
        this.setFirstResult(0);
    }

    public void last() {
        this.setFirstResult(this.getLast());
    }

    public void setPageNumberWithCheck(int pageNumber) {
        if (this.getPageSize() <= 0) {
            this.first();
        } else if (pageNumber <= 1) {
            this.first();
        } else if (this.getRowCount() <= 0) {
            this.first();
        } else {
            int maxpagenum = (this.getRowCount() - 1) / this.getPageSize() + 1;
            if (pageNumber > maxpagenum) {
                this.last();
            } else {
                this.setPageNumber(pageNumber);
            }
        }
    }

    public int getLast() {
        if (this.getPageSize() > 0) {
            int mod = this.getRowCount() % this.getPageSize();
            if (mod == 0) {
                return this.getRowCount() - this.getPageSize();
            }
            return this.getRowCount() - mod;
        }
        return 0;
    }

    public int getNext() {
        if (this.getPageSize() > 0) {
            int next = this.getFirstResult() + this.getPageSize();
            if (next > this.getRowCount()) {
                next = this.getRowCount();
            }
            return next;
        }
        return this.getRowCount();
    }

    public int getPrev() {
        if (this.getPageSize() > 0) {
            int prev = this.getFirstResult() - this.getPageSize();
            if (prev <= 0) {
                prev = 0;
            }
            return prev;
        }
        return 0;
    }

    public boolean isProcess() {
        return this.isProcess;
    }

    public boolean isNextPage() {
        if (this.getPageSize() > 0) {
            return this.getRowCount() - this.getFirstResult() > this.getPageSize();
        }
        return false;
    }

    public boolean isPrevPage() {
        if (this.getPageSize() > 0) {
            return this.getFirstResult() - this.getPageSize() >= 0;
        }
        return false;
    }

    public void absorb(DataBindingContext dataBindingContext) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)dataBindingContext);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static abstract class CountUpdator {
        protected abstract int count();
    }
}

