/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.util.Arrays;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.SortKey;
import jp.jasminesoft.jfc.hibernate.CriteriaUtils;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.ForeignkeyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class ForeignKeyCriteriaConverter<FK, E extends ContainerBase<E>>
extends CriteriaConverter<FK> {
    private boolean includingImplicit = false;
    private String parentModelId;
    private EntityMeta<E> entityMeta;
    private ForeignkeyMeta<?>[] foreignkeyMetas;

    public ForeignKeyCriteriaConverter(EntityMeta<E> entityMeta) {
        super(entityMeta.entityClass());
        this.entityMeta = entityMeta;
    }

    protected CriteriaConverter<?> defaultCriteriaConverter() {
        try {
            return StoreModelUtils.criteriaConverter(this.entityClass, this.getActionParameterContainer().get());
        }
        catch (NoSuchBeanDefinitionException e) {
            return new CriteriaConverter(this.entityClass);
        }
    }

    @Override
    protected DetachedCriteria initializedCtiteria(boolean isRowCountQuery) {
        return this.defaultCriteriaConverter().defaultCriteria(isRowCountQuery);
    }

    @Override
    public Order[] getDefaultOrders() {
        return this.defaultCriteriaConverter().getDefaultOrders();
    }

    public void setIncludingImplicit(boolean includingImplicit) {
        this.includingImplicit = includingImplicit;
    }

    public void setParentModelId(String parentModelId) {
        this.parentModelId = parentModelId;
    }

    @Override
    protected DetachedCriteria convert(DetachedCriteria criteria, FK foreignkey) {
        this.validate();
        ForeignkeyMeta<?>[] fkmetas = this.foreignkeyMeta();
        if (foreignkey instanceof ContainerBase) {
            for (ForeignkeyMeta<?> meta : fkmetas) {
                this.addCriterion(criteria, meta, ReflectionUtils.getPrivateField(foreignkey, meta.roleid().name()));
            }
        } else {
            this.addCriterion(criteria, fkmetas[0], foreignkey);
        }
        return criteria;
    }

    protected ForeignkeyMeta<?>[] foreignkeyMeta() {
        if (this.foreignkeyMetas != null) {
            return this.foreignkeyMetas;
        }
        ForeignkeyMeta<?>[] fkmetas = this.entityMeta.foreignkeyMeta();
        if (StringUtils.isBlank((String)this.parentModelId)) {
            this.foreignkeyMetas = fkmetas;
            return this.foreignkeyMetas;
        }
        this.foreignkeyMetas = (ForeignkeyMeta[])Arrays.stream(fkmetas).filter(fkMeta -> this.parentModelId.equals(StoreModelUtils.getModelId(fkMeta.roleid().entityMeta().entityClass()))).toArray(ForeignkeyMeta[]::new);
        return this.foreignkeyMetas;
    }

    protected void validate() {
        if (StringUtils.isNotBlank((String)this.parentModelId)) {
            if (this.foreignkeyMeta().length == 0) {
                throw new IllegalStateException(StoreModelUtils.getModelId(this.entityMeta.entityClass()) + " does not have foreignkey : " + this.parentModelId);
            }
            return;
        }
        long parentCounter = Arrays.stream(this.foreignkeyMeta()).map(fkeymeta -> fkeymeta.roleid().entityMeta().entityClass()).distinct().count();
        if (parentCounter > 1L) {
            throw new IllegalStateException("parentModelId must not be null.");
        }
    }

    protected <T> void addCriterion(DetachedCriteria criteria, ForeignkeyMeta<T> meta, Object obj) {
        Object value = obj;
        if (this.includingImplicit) {
            criteria.add(CriteriaUtils.or(CriteriaUtils.eq(meta, value), CriteriaUtils.isNull(meta)));
        } else {
            criteria.eq(meta, value);
        }
    }

    @Override
    protected FK copyCondition(FK foreignkey) {
        try {
            return ClassUtils.newInstanceByCopyConstructor(foreignkey);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                return foreignkey;
            }
            throw e;
        }
    }

    @Override
    protected void beforeSearch(FK condition) {
    }

    @Override
    protected DetachedCriteria convert(DetachedCriteria criteria, SortKey sortKey) {
        return criteria;
    }
}

