/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.CloneConverter;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.dao.DataBindingContext;
import jp.jasminesoft.jfc.dao.IScroller;
import jp.jasminesoft.jfc.dao.JFCHibernateDao;
import jp.jasminesoft.jfc.dao.Updator;
import jp.jasminesoft.jfc.initdb.XMLLoader;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.InitLoaderBaseService;
import jp.jasminesoft.util.JaxbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class JFCStaticDao<E extends ContainerBase<E>, PK extends Serializable>
extends JFCHibernateDao<E, PK> {
    private static final Logger logger = LogManager.getLogger(JFCStaticDao.class);
    @Autowired
    @Qualifier(value="initLoaderService")
    protected InitLoaderBaseService initLoaderBaseService;
    protected static Map<Class<? extends ContainerBase<?>>, Map<?, ?>> storage = new HashMap();

    public JFCStaticDao(Class<E> entityClass) {
        super(entityClass);
    }

    protected Map<PK, E> map() {
        Map<Object, Object> map = storage.get(this.entityClass);
        if (map == null) {
            map = this.initalizeMap();
            storage.put(this.entityClass, map);
        }
        return map;
    }

    public static void clearStaticStorage() {
        storage.clear();
    }

    private E data(PK pkey) {
        return (E)((ContainerBase)ClassUtils.newInstanceByCopyConstructor(this.map().get(pkey)));
    }

    private List<E> data() {
        return Arrays.asList(new CloneConverter<A[]>(this.entityClass).convert(CollectionUtils.toArray(this.map().values(), this.entityClass)));
    }

    protected Map<PK, E> initalizeMap() {
        TreeMap map = new TreeMap();
        String modelId = StoreModelUtils.getModelId(this.entityClass);
        String initdataBasePath = this.initLoaderBaseService.getInitdataPath();
        File initdataDir = new File(initdataBasePath, "init/" + modelId);
        if (logger.isDebugEnabled()) {
            logger.debug("initdataDir:" + initdataDir);
            logger.debug("Dao classname:" + this.getClass());
        }
        if (!initdataDir.exists()) {
            logger.debug("initdataDir is not exists");
            return map;
        }
        List<File> list = new XMLLoader().createTargetList(initdataDir);
        if (logger.isDebugEnabled()) {
            logger.debug("list size is " + list.size());
        }
        for (File file : list) {
            ContainerBase entity;
            try {
                entity = (ContainerBase)JaxbUtil.unmarshal((File)file, (Class)this.entityClass);
            }
            catch (JAXBException e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("file:" + file);
                logger.error("Dao classname:" + this.getClass());
                continue;
            }
            map.put(this.helper.getPrimarykey(entity), entity);
        }
        return map;
    }

    @Override
    public E get(PK pkey, boolean forUpdate, DataBindingContext context) {
        return this.data(pkey);
    }

    @Override
    public List<E> findAll() {
        return this.data();
    }

    @Override
    public List<E> findAll(DataBindingContext context) {
        return this.data();
    }

    @Override
    public PK save(E entity) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public void update(E entity, boolean checkLocked) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public void updatePersistentEntity(E persistentEntity, boolean isReleasableLock) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public E update(PK primarykey, Updator<E> updator) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public E load(PK primarykey) {
        return this.data(primarykey);
    }

    @Override
    public E deleteById(PK pkey, boolean lock) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public void delete(E entity, boolean lock) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public <T> List<T> findByCriteria(DetachedCriteria criteria, int firstResult, int maxResults, DataBindingContext context) {
        return this.data();
    }

    @Override
    public int count(DetachedCriteria criteria) {
        return this.map().size();
    }

    @Override
    public List<PK> findKeys(DetachedCriteria criteria, int firstResult, int maxResults) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public <P> List<P> distinct(PropertyMeta<P> property) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }

    @Override
    public void scroll(IScroller<E> scroller) {
        throw new UnsupportedOperationException(JFCStaticDao.class.getName() + " doesn't support this method.");
    }
}

