/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.filter;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.JFCUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckDataSourceFilter
implements Filter {
    public static final Logger logger = LogManager.getLogger((String)CheckDataSourceFilter.class.getName());
    private String checktype_before;
    private String checktype_after;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.checktype_before = filterConfig.getInitParameter("checktype_before");
        this.checktype_after = filterConfig.getInitParameter("checktype_after");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int aidle;
        int aactive;
        int bidle;
        int bactive;
        int[] params;
        String method = "";
        String uri = "";
        if (request instanceof HttpServletRequest) {
            method = ((HttpServletRequest)request).getMethod();
            uri = ((HttpServletRequest)request).getRequestURI();
        }
        if ((params = this.getDataSourceParameter()) != null) {
            bactive = params[0];
            bidle = params[1];
            if (this.isDisplayBeforeValue(request, response, bactive, bidle)) {
                CheckType ct = this.getCheckType(this.checktype_before);
                String header = ct == CheckType.All ? "" : ct.toString() + " ";
                logger.info("before " + header + method + " " + uri + " active=" + bactive + " idle=" + bidle);
            }
        } else {
            chain.doFilter(request, response);
            return;
        }
        chain.doFilter(request, response);
        params = this.getDataSourceParameter();
        if (params != null && this.isDisplayAfterValue(request, response, bactive, bidle, aactive = params[0], aidle = params[1])) {
            CheckType ct = this.getCheckType(this.checktype_after);
            String header = ct == CheckType.All ? "" : ct.toString() + " ";
            logger.info("after " + header + method + " " + uri + " active=" + aactive + " idle=" + aidle);
        }
    }

    public boolean isDisplayBeforeValue(ServletRequest request, ServletResponse response, int bactive, int bidle) {
        CheckType ct = this.getCheckType(this.checktype_before);
        if (ct == CheckType.All) {
            return true;
        }
        if (ct == CheckType.ActiveOver0) {
            return bactive > 0;
        }
        logger.error("Unknown checktype_before " + this.checktype_before + " use " + (Object)((Object)CheckType.All));
        return true;
    }

    public boolean isDisplayAfterValue(ServletRequest request, ServletResponse response, int bactive, int bidle, int aactive, int aidle) {
        CheckType ct = this.getCheckType(this.checktype_after);
        if (ct == CheckType.All) {
            return true;
        }
        if (ct == CheckType.ActiveOver0) {
            return aactive > 0;
        }
        if (ct == CheckType.ChangeBeforeAfter) {
            return bactive != aactive;
        }
        if (ct == CheckType.OverBeforeToAfter) {
            return bactive < aactive;
        }
        logger.error("Unknown checktype_after " + this.checktype_after + " use " + (Object)((Object)CheckType.All));
        return true;
    }

    public int[] getDataSourceParameter() {
        DataSource dataSource = JFCUtils.getDataSource();
        if (dataSource == null) {
            logger.error("Failed to get DataSource");
            return null;
        }
        if (dataSource instanceof BasicDataSource) {
            BasicDataSource bds = (BasicDataSource)dataSource;
            int[] params = new int[]{};
            params[0] = bds.getNumActive();
            params[1] = bds.getNumIdle();
            return params;
        }
        int[] params = this.getDataSourceParameter(dataSource);
        if (params != null) {
            return params;
        }
        logger.error("Unknown datasource class " + dataSource.getClass());
        return null;
    }

    public int[] getDataSourceParameter(DataSource dataSource) {
        Class<?> dsclass = dataSource.getClass();
        try {
            Method methodGetNumActive = dsclass.getMethod("getNumActive", new Class[0]);
            Method methodGetNumIdle = dsclass.getMethod("getNumIdle", new Class[0]);
            Number numActive = (Number)methodGetNumActive.invoke((Object)dataSource, new Object[0]);
            Number numIdle = (Number)methodGetNumIdle.invoke((Object)dataSource, new Object[0]);
            int[] params = new int[]{numActive.intValue(), numIdle.intValue()};
            return params;
        }
        catch (Exception e) {
            logger.debug("Failed to get DataSource Parameter", (Throwable)e);
            return null;
        }
    }

    public CheckType getCheckType(String ct) {
        if (ct == null) {
            return CheckType.All;
        }
        if (ct.equals(CheckType.All.toString())) {
            return CheckType.All;
        }
        if (ct.equals(CheckType.ActiveOver0.toString())) {
            return CheckType.ActiveOver0;
        }
        if (ct.equals(CheckType.ChangeBeforeAfter.toString())) {
            return CheckType.ChangeBeforeAfter;
        }
        if (ct.equals(CheckType.OverBeforeToAfter.toString())) {
            return CheckType.OverBeforeToAfter;
        }
        return null;
    }

    static enum CheckType {
        All,
        ActiveOver0,
        ChangeBeforeAfter,
        OverBeforeToAfter;

    }
}

