/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.hibernate;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.core.filter.BlankFilter;
import jp.jasminesoft.jfc.core.filter.NullFilter;
import jp.jasminesoft.jfc.core.pattern.DecorativeArrayFilter;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.SortKey;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.hibernate.Junction;
import jp.jasminesoft.jfc.hibernate.LikeExpression;
import jp.jasminesoft.jfc.hibernate.Operator;
import jp.jasminesoft.jfc.hibernate.SubqueryExpressionHashCodeHelper;
import jp.jasminesoft.jfc.meta.ContainerMultiPropertyMeta;
import jp.jasminesoft.jfc.meta.ContainerPropertyMeta;
import jp.jasminesoft.jfc.meta.ContainerRelationMeta;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.meta.ReferenceMeta;
import jp.jasminesoft.jfc.meta.ReferenceMultiPropertyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.criterion.SubqueryExpression;

public class CriteriaUtils {
    private static final Logger logger = LogManager.getLogger((String)CriteriaUtils.class.getName());
    public static final String OR_SPLIT_PREFIX = "OR ";

    protected CriteriaUtils() {
    }

    public static <P> Criterion eq(PropertyMetaBase<P> meta, P ... values) {
        return CriteriaUtils.eq(meta.name(), values);
    }

    public static <P> Criterion eq(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P ... values) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.eq(meta, values));
    }

    private static <P> Criterion eq(MultiPropertyMeta<P> meta, P ... values) {
        return CriteriaUtils.eq(meta.table() + ".elements", values);
    }

    public static <P> Criterion eq(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P ... values) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.eq(meta, values));
    }

    public static <P> Criterion eq(DetachedCriteria criteria, ContainerMultiPropertyMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])(values = CriteriaUtils.filterBlank(values)))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta.parent());
        subquery.add(CriteriaUtils.eq(subquery, meta, values));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion eq(DetachedCriteria criteria, ReferenceMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.eq_(criteria, meta, values);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.eq_(subquery, meta, values));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion eq_(DetachedCriteria criteria, ReferenceMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.eq(subquery, (ReferenceMeta)meta.referenceItemMeta(), values) : CriteriaUtils.eq(meta.referenceItemMeta(), values);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion eq(DetachedCriteria criteria, ReferenceMultiPropertyMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMultiPropertyMeta ? CriteriaUtils.eq(subquery, (ReferenceMultiPropertyMeta)meta.referenceItemMeta(), values) : CriteriaUtils.eq(subquery, meta.referenceItemMeta(), values);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion eq(String propertyName, P ... values) {
        if (ArrayUtils.isEmpty((Object[])(values = CriteriaUtils.filterBlank(values)))) {
            return null;
        }
        if (values.length == 1) {
            return Restrictions.eq((String)propertyName, values[0]);
        }
        return Restrictions.in((String)propertyName, (Object[])values);
    }

    public static <P> Criterion eqAsPropertyMetaBase(DetachedCriteria criteria, PropertyMetaBase<P> meta, Object value) {
        if (meta instanceof ContainerPropertyMeta) {
            return CriteriaUtils.eq(criteria, (ContainerPropertyMeta)meta, CriteriaUtils.toArray(value));
        }
        if (meta instanceof ContainerMultiPropertyMeta) {
            return CriteriaUtils.eq(criteria, (ContainerMultiPropertyMeta)meta, CriteriaUtils.toArray(value));
        }
        if (meta instanceof ReferenceMultiPropertyMeta) {
            return CriteriaUtils.eq(criteria, (ReferenceMultiPropertyMeta)meta, CriteriaUtils.toArray(value));
        }
        if (meta instanceof MultiPropertyMeta) {
            return CriteriaUtils.eq(criteria, (MultiPropertyMeta)meta, CriteriaUtils.toArray(value));
        }
        if (meta instanceof ReferenceMeta) {
            return CriteriaUtils.eq(criteria, (ReferenceMeta)meta, CriteriaUtils.toArray(value));
        }
        return CriteriaUtils.eq(meta, CriteriaUtils.toArray(value));
    }

    public static <P> P[] toArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                Class<?> componentType = value.getClass().getComponentType();
                if (componentType.equals(Boolean.TYPE)) {
                    return ArrayUtils.toObject((boolean[])((boolean[])value));
                }
                if (componentType.equals(Character.TYPE)) {
                    return ArrayUtils.toObject((char[])((char[])value));
                }
                if (componentType.equals(Byte.TYPE)) {
                    return ArrayUtils.toObject((byte[])((byte[])value));
                }
                if (componentType.equals(Short.TYPE)) {
                    return ArrayUtils.toObject((short[])((short[])value));
                }
                if (componentType.equals(Integer.TYPE)) {
                    return ArrayUtils.toObject((int[])((int[])value));
                }
                if (componentType.equals(Long.TYPE)) {
                    return ArrayUtils.toObject((long[])((long[])value));
                }
                if (componentType.equals(Float.TYPE)) {
                    return ArrayUtils.toObject((float[])((float[])value));
                }
                if (componentType.equals(Double.TYPE)) {
                    return ArrayUtils.toObject((double[])((double[])value));
                }
                throw new IllegalArgumentException(componentType + " is inappropriate argument.");
            }
            return (Object[])value;
        }
        Object[] array = (Object[])Array.newInstance(value.getClass(), 1);
        array[0] = value;
        return array;
    }

    public static <P> Criterion ne(PropertyMetaBase<P> meta, P ... values) {
        return CriteriaUtils.ne(meta.name(), values);
    }

    public static <P> Criterion ne(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P ... values) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.ne(meta, values));
    }

    private static <P> Criterion ne(MultiPropertyMeta<P> meta, P ... values) {
        return CriteriaUtils.ne(meta.table() + ".elements", values);
    }

    public static <P> Criterion ne(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P ... values) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.ne(meta, values));
    }

    public static <P> Criterion ne(DetachedCriteria criteria, ReferenceMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.ne_(criteria, meta, values);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.ne_(subquery, meta, values));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion ne_(DetachedCriteria criteria, ReferenceMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.ne(subquery, (ReferenceMeta)meta.referenceItemMeta(), values) : CriteriaUtils.ne(meta.referenceItemMeta(), values);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion ne(String propertyName, P ... values) {
        if (ArrayUtils.isEmpty((Object[])(values = CriteriaUtils.filterBlank(values)))) {
            return null;
        }
        if (values.length == 1) {
            return Restrictions.ne((String)propertyName, values[0]);
        }
        ArrayList<Criterion> conjunction = new ArrayList<Criterion>();
        for (P value : values) {
            conjunction.add((Criterion)Restrictions.ne((String)propertyName, value));
        }
        return CriteriaUtils.and(conjunction);
    }

    public static <P> Criterion between(PropertyMetaBase<P> meta, P lowValue, P highValue) {
        return CriteriaUtils.between(meta.name(), lowValue, highValue);
    }

    public static <P> Criterion between(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P lowValue, P highValue) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.between(meta, lowValue, highValue));
    }

    private static <P> Criterion between(MultiPropertyMeta<P> meta, P lowValue, P highValue) {
        return CriteriaUtils.between(meta.table() + ".elements", lowValue, highValue);
    }

    public static <P> Criterion between(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P lowValue, P highValue) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.between(meta, lowValue, highValue));
    }

    public static <P> Criterion between(DetachedCriteria criteria, ReferenceMeta<P> meta, P lowValue, P highValue) {
        if (CriteriaUtils.isBlank(lowValue) && CriteriaUtils.isBlank(highValue)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.between_(criteria, meta, lowValue, highValue);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.between_(subquery, meta, lowValue, highValue));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion between_(DetachedCriteria criteria, ReferenceMeta<P> meta, P lowValue, P highValue) {
        if (CriteriaUtils.isBlank(lowValue) && CriteriaUtils.isBlank(highValue)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.between(subquery, (ReferenceMeta)meta.referenceItemMeta(), lowValue, highValue) : CriteriaUtils.between(meta.referenceItemMeta(), lowValue, highValue);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion between(String propertyName, P lowValue, P highValue) {
        if (CriteriaUtils.isBlank(lowValue) && CriteriaUtils.isBlank(highValue)) {
            return null;
        }
        if (CriteriaUtils.isNotBlank(lowValue) && CriteriaUtils.isNotBlank(highValue)) {
            return Restrictions.between((String)propertyName, lowValue, highValue);
        }
        if (CriteriaUtils.isNotBlank(lowValue)) {
            return CriteriaUtils.ge(propertyName, lowValue);
        }
        return CriteriaUtils.le(propertyName, highValue);
    }

    public static <P> Criterion ge(PropertyMetaBase<P> meta, P value) {
        return CriteriaUtils.ge(meta.name(), value);
    }

    public static <P> Criterion ge(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.ge(meta, value));
    }

    private static <P> Criterion ge(MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.ge(meta.table() + ".elements", value);
    }

    public static <P> Criterion ge(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.ge(meta, value));
    }

    public static <P> Criterion ge(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.ge_(criteria, meta, value);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.ge_(subquery, meta, value));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion ge_(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.ge(subquery, (ReferenceMeta)meta.referenceItemMeta(), value) : CriteriaUtils.ge(meta.referenceItemMeta(), value);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion ge(String propertyName, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        return Restrictions.ge((String)propertyName, value);
    }

    public static <P> Criterion le(PropertyMetaBase<P> meta, P value) {
        return CriteriaUtils.le(meta.name(), value);
    }

    public static <P> Criterion le(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.le(meta, value));
    }

    private static <P> Criterion le(MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.le(meta.table() + ".elements", value);
    }

    public static <P> Criterion le(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.le(meta, value));
    }

    public static <P> Criterion le(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.le_(criteria, meta, value);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.le_(subquery, meta, value));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion le_(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.le(subquery, (ReferenceMeta)meta.referenceItemMeta(), value) : CriteriaUtils.le(meta.referenceItemMeta(), value);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion le(String propertyName, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        return Restrictions.le((String)propertyName, value);
    }

    public static <P> Criterion gt(PropertyMetaBase<P> meta, P value) {
        return CriteriaUtils.gt(meta.name(), value);
    }

    public static <P> Criterion gt(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.gt(meta, value));
    }

    private static <P> Criterion gt(MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.gt(meta.table() + ".elements", value);
    }

    public static <P> Criterion gt(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.gt(meta, value));
    }

    public static <P> Criterion gt(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.gt_(criteria, meta, value);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.gt_(subquery, meta, value));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion gt_(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.gt(subquery, (ReferenceMeta)meta.referenceItemMeta(), value) : CriteriaUtils.gt(meta.referenceItemMeta(), value);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion gt(String propertyName, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        return Restrictions.gt((String)propertyName, value);
    }

    public static <P> Criterion lt(PropertyMetaBase<P> meta, P value) {
        return CriteriaUtils.lt(meta.name(), value);
    }

    public static <P> Criterion lt(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.lt(meta, value));
    }

    private static <P> Criterion lt(MultiPropertyMeta<P> meta, P value) {
        return CriteriaUtils.lt(meta.table() + ".elements", value);
    }

    public static <P> Criterion lt(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P value) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.lt(meta, value));
    }

    public static <P> Criterion lt(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.lt_(criteria, meta, value);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.lt_(subquery, meta, value));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static <P> Criterion lt_(DetachedCriteria criteria, ReferenceMeta<P> meta, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.lt(subquery, (ReferenceMeta)meta.referenceItemMeta(), value) : CriteriaUtils.lt(meta.referenceItemMeta(), value);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion lt(String propertyName, P value) {
        if (CriteriaUtils.isBlank(value)) {
            return null;
        }
        return Restrictions.lt((String)propertyName, value);
    }

    public static Criterion like(PropertyMetaBase<String> meta, String ... values) {
        return CriteriaUtils.like(meta, MatchMode.ANYWHERE, Operator.OR, values);
    }

    public static Criterion like(PropertyMetaBase<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(meta, MatchMode.ANYWHERE, operator, values);
    }

    public static Criterion like(PropertyMetaBase<String> meta, Junction junction) {
        return CriteriaUtils.like(meta, MatchMode.ANYWHERE, junction);
    }

    public static Criterion like(DetachedCriteria criteria, MultiPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, Operator.OR, values);
    }

    public static Criterion like(DetachedCriteria criteria, MultiPropertyMeta<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, operator, values);
    }

    public static Criterion like(DetachedCriteria criteria, MultiPropertyMeta<String> meta, Junction junction) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, junction);
    }

    public static Criterion like(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, Operator.OR, values);
    }

    public static Criterion like(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, operator, values);
    }

    public static Criterion like(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, Junction junction) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, junction);
    }

    public static Criterion like(DetachedCriteria criteria, ReferenceMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, Operator.OR, values);
    }

    public static Criterion like(DetachedCriteria criteria, ReferenceMeta<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, operator, values);
    }

    public static Criterion like(DetachedCriteria criteria, ReferenceMeta<String> meta, Junction junction) {
        return CriteriaUtils.like(criteria, meta, MatchMode.ANYWHERE, junction);
    }

    public static Criterion like(String propertyName, String ... values) {
        return CriteriaUtils.like(propertyName, MatchMode.ANYWHERE, values);
    }

    public static Criterion likePrefix(PropertyMetaBase<String> meta, String ... values) {
        return CriteriaUtils.like(meta, MatchMode.START, values);
    }

    public static Criterion likePrefix(DetachedCriteria criteria, MultiPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.START, values);
    }

    public static Criterion likePrefix(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.START, values);
    }

    public static Criterion likePrefix(DetachedCriteria criteria, ReferenceMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.START, values);
    }

    public static Criterion likePrefix(String propertyName, String ... values) {
        return CriteriaUtils.like(propertyName, MatchMode.START, values);
    }

    public static Criterion likeSuffix(PropertyMetaBase<String> meta, String ... values) {
        return CriteriaUtils.like(meta, MatchMode.END, values);
    }

    public static Criterion likeSuffix(DetachedCriteria criteria, MultiPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.END, values);
    }

    public static Criterion likeSuffix(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.END, values);
    }

    public static Criterion likeSuffix(DetachedCriteria criteria, ReferenceMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.END, values);
    }

    public static Criterion likeSuffix(String propertyName, String ... values) {
        return CriteriaUtils.like(propertyName, MatchMode.END, values);
    }

    public static Criterion likeRuntime(PropertyMetaBase<String> meta, String ... values) {
        return CriteriaUtils.like(meta, MatchMode.EXACT, Operator.OR, values);
    }

    public static Criterion likeRuntime(PropertyMetaBase<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(meta, MatchMode.EXACT, operator, values);
    }

    public static Criterion likeRuntime(PropertyMetaBase<String> meta, Junction junction) {
        return CriteriaUtils.like(meta, MatchMode.EXACT, junction);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, MultiPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, Operator.OR, values);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, MultiPropertyMeta<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, operator, values);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, MultiPropertyMeta<String> meta, Junction junction) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, junction);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, Operator.OR, values);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, operator, values);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, Junction junction) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, junction);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, ReferenceMeta<String> meta, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, Operator.OR, values);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, ReferenceMeta<String> meta, Operator operator, String ... values) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, operator, values);
    }

    public static Criterion likeRuntime(DetachedCriteria criteria, ReferenceMeta<String> meta, Junction junction) {
        return CriteriaUtils.like(criteria, meta, MatchMode.EXACT, junction);
    }

    public static Criterion likeRuntime(String propertyName, String ... values) {
        return CriteriaUtils.like(propertyName, MatchMode.EXACT, values);
    }

    public static Criterion like(PropertyMetaBase<String> meta, MatchMode matchMode, String ... values) {
        return CriteriaUtils.like(meta, matchMode, Operator.OR, values);
    }

    public static Criterion like(PropertyMetaBase<String> meta, MatchMode matchMode, Operator operator, String ... values) {
        return CriteriaUtils.like(meta.name(), matchMode, operator, values);
    }

    public static Criterion like(PropertyMetaBase<String> meta, MatchMode matchMode, Junction junction) {
        return CriteriaUtils.like(meta.name(), matchMode, junction);
    }

    public static Criterion like(DetachedCriteria criteria, MultiPropertyMeta<String> meta, MatchMode matchMode, String ... values) {
        return CriteriaUtils.like(criteria, meta, matchMode, Operator.OR, values);
    }

    public static Criterion like(DetachedCriteria criteria, MultiPropertyMeta<String> meta, MatchMode matchMode, Operator operator, String ... values) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.like(meta, matchMode, operator, values));
    }

    public static Criterion like(DetachedCriteria criteria, MultiPropertyMeta<String> meta, MatchMode matchMode, Junction junction) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.like(meta, matchMode, junction.getOperator(), junction.getValues()));
    }

    private static Criterion like(MultiPropertyMeta<String> meta, MatchMode matchMode, Operator operator, String ... values) {
        return CriteriaUtils.like(meta.table() + ".elements", matchMode, operator, values);
    }

    public static Criterion like(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, MatchMode matchMode, String ... values) {
        return CriteriaUtils.like(criteria, meta, matchMode, Operator.OR, values);
    }

    public static Criterion like(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, MatchMode matchMode, Operator operator, String ... values) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.like(meta, matchMode, operator, values));
    }

    public static Criterion like(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, MatchMode matchMode, Junction junction) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.like(meta, matchMode, junction));
    }

    public static Criterion like(DetachedCriteria criteria, ReferenceMeta<String> meta, MatchMode matchMode, String ... values) {
        return CriteriaUtils.like(criteria, meta, matchMode, Operator.OR, values);
    }

    public static Criterion like(DetachedCriteria criteria, ReferenceMeta<String> meta, MatchMode matchMode, Junction junction) {
        return CriteriaUtils.like(criteria, meta, matchMode, junction.getOperator(), junction.getValues());
    }

    public static Criterion like(DetachedCriteria criteria, ReferenceMeta<String> meta, MatchMode matchMode, Operator operator, String ... values) {
        if (ArrayUtils.isEmpty((Object[])new BlankFilter().filter(values))) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.like_(criteria, meta, matchMode, operator, values);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.like_(subquery, meta, matchMode, operator, values));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static Criterion like_(DetachedCriteria criteria, ReferenceMeta<String> meta, MatchMode matchMode, Operator operator, String ... values) {
        if (ArrayUtils.isEmpty((Object[])new BlankFilter().filter(values))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.like(subquery, (ReferenceMeta<String>)((ReferenceMeta)meta.referenceItemMeta()), matchMode, operator, values) : CriteriaUtils.like(meta.referenceItemMeta(), matchMode, operator, values);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static Criterion like(String propertyName, MatchMode matchMode, String ... values) {
        return CriteriaUtils.like(propertyName, matchMode, Operator.OR, values);
    }

    public static Criterion like(String propertyName, MatchMode matchMode, Junction junction) {
        return CriteriaUtils.like(propertyName, matchMode, junction.getOperator(), junction.getValues());
    }

    public static Criterion like(String propertyName, MatchMode matchMode, Operator operator, String ... values) {
        if (ArrayUtils.isEmpty((Object[])(values = new BlankFilter().filter(values)))) {
            return null;
        }
        if (values.length == 1) {
            return new LikeExpression(propertyName, values[0], matchMode);
        }
        ArrayList<Criterion> junction = new ArrayList<Criterion>();
        for (String value : values) {
            junction.add((Criterion)new LikeExpression(propertyName, value, matchMode));
        }
        if (operator == Operator.AND) {
            return CriteriaUtils.and(junction);
        }
        return CriteriaUtils.or(junction);
    }

    public static Criterion isNull(String propertyName) {
        return Restrictions.isNull((String)propertyName);
    }

    public static Criterion isNull(PropertyMetaBase<?> meta) {
        if (meta.isTransient()) {
            return null;
        }
        return CriteriaUtils.isNull(meta.name());
    }

    public static Criterion isNull(DetachedCriteria criteria, ContainerPropertyMeta<?> meta) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.isNull(meta));
    }

    public static Criterion isNull(DetachedCriteria criteria, ReferenceMeta<?> meta) {
        if (CriteriaUtils.isTransient(meta)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.isNull_(criteria, meta);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.isNull_(subquery, meta));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static Criterion isNull_(DetachedCriteria criteria, ReferenceMeta<?> meta) {
        if (CriteriaUtils.isTransient(meta)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.isNull(subquery, (ReferenceMeta)meta.referenceItemMeta()) : CriteriaUtils.isNull(meta.referenceItemMeta());
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static Criterion isNull(DetachedCriteria criteria, PropertyMetaBase<?> ... propertyMetas) {
        ArrayList<Criterion> conjunction = new ArrayList<Criterion>();
        for (PropertyMetaBase<?> meta : propertyMetas) {
            if (meta instanceof ReferenceMeta) {
                conjunction.add(CriteriaUtils.isNull(criteria, (ReferenceMeta)meta));
                continue;
            }
            if (meta instanceof PropertyMeta) {
                conjunction.add(CriteriaUtils.isNull((PropertyMeta)meta));
                continue;
            }
            if (!(meta instanceof ContainerPropertyMeta)) continue;
            conjunction.add(CriteriaUtils.isNull(criteria, (ContainerPropertyMeta)meta));
        }
        return CriteriaUtils.and(conjunction);
    }

    public static Criterion isNull(DetachedCriteria criteria, EntityMeta<?> entityMeta, String ... names) {
        if (ArrayUtils.isEmpty((Object[])new BlankFilter().filter(names))) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (String name : names) {
            if (name.endsWith("1jshparam")) {
                name = StringUtils.removeEnd((String)name, (String)"1jshparam");
            }
            list.add(entityMeta.propertyMeta(name));
        }
        return CriteriaUtils.isNull(criteria, list.toArray(new PropertyMetaBase[list.size()]));
    }

    public static Criterion isNotNull(String propertyName) {
        return Restrictions.isNotNull((String)propertyName);
    }

    public static Criterion isNotNull(PropertyMetaBase<?> meta) {
        if (meta.isTransient()) {
            return null;
        }
        return CriteriaUtils.isNotNull(meta.name());
    }

    public static <P> Criterion isNotNull(DetachedCriteria criteria, MultiPropertyMeta<P> meta) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.isNotNull(meta));
    }

    private static <P> Criterion isNotNull(MultiPropertyMeta<P> meta) {
        return CriteriaUtils.isNotNull(meta.table() + ".elements");
    }

    public static Criterion isNotNull(DetachedCriteria criteria, ContainerPropertyMeta<?> meta) {
        return CriteriaUtils.subquery(criteria, meta, CriteriaUtils.isNotNull(meta));
    }

    public static Criterion isNotNull(DetachedCriteria criteria, ReferenceMeta<?> meta) {
        if (CriteriaUtils.isTransient(meta)) {
            return null;
        }
        if (!(meta.relatedItemsMeta()[0] instanceof ContainerRelationMeta)) {
            return CriteriaUtils.isNotNull_(criteria, meta);
        }
        ContainerRelationMeta relatedItemMeta = (ContainerRelationMeta)meta.relatedItemsMeta()[0];
        DetachedCriteria subquery = criteria.createSubqueries(relatedItemMeta.parent());
        subquery.add(CriteriaUtils.isNotNull_(subquery, meta));
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    static Criterion isNotNull_(DetachedCriteria criteria, ReferenceMeta<?> meta) {
        if (CriteriaUtils.isTransient(meta)) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        Criterion criterion = meta.referenceItemMeta() instanceof ReferenceMeta ? CriteriaUtils.isNotNull(subquery, (ReferenceMeta)meta.referenceItemMeta()) : CriteriaUtils.isNotNull(meta.referenceItemMeta());
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion notContains(DetachedCriteria criteria, MultiPropertyMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createUnSharedSubqueries(meta);
        subquery.add(CriteriaUtils.eq(meta, values));
        return Subqueries.notExists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static <P> Criterion notContains(DetachedCriteria criteria, ContainerPropertyMeta<P> meta, P ... values) {
        if (ArrayUtils.isEmpty((Object[])CriteriaUtils.filterBlank(values))) {
            return null;
        }
        DetachedCriteria subquery = criteria.createUnSharedSubqueries(meta.parent());
        subquery.add(CriteriaUtils.eq(meta, values));
        return Subqueries.notExists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static boolean isTransient(ReferenceMeta<?> meta) {
        PropertyMetaBase<?> referenceItemMeta = meta.referenceItemMeta();
        if (referenceItemMeta instanceof ReferenceMeta) {
            return CriteriaUtils.isTransient((ReferenceMeta)referenceItemMeta);
        }
        return referenceItemMeta.isTransient();
    }

    public static Criterion subquery(DetachedCriteria criteria, MultiPropertyMeta<?> meta, Criterion criterion) {
        if (criterion == null) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta);
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static Criterion subquery(DetachedCriteria criteria, ContainerPropertyMeta<?> meta, Criterion criterion) {
        if (criterion == null) {
            return null;
        }
        DetachedCriteria subquery = criteria.createSubqueries(meta.parent());
        subquery.add(criterion);
        return Subqueries.exists((org.hibernate.criterion.DetachedCriteria)subquery);
    }

    public static Criterion and(Criterion ... values) {
        if (ArrayUtils.isEmpty((Object[])(values = CriteriaUtils.filterDuplicateExpressions(values)))) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return Restrictions.and((Criterion[])values);
    }

    public static Criterion and(Collection<Criterion> values) {
        return CriteriaUtils.and(values.toArray(new Criterion[values.size()]));
    }

    public static Criterion or(Criterion ... values) {
        if (ArrayUtils.isEmpty((Object[])(values = CriteriaUtils.filterDuplicateExpressions(values)))) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return Restrictions.or((Criterion[])values);
    }

    public static Criterion or(Collection<Criterion> values) {
        return CriteriaUtils.or(values.toArray(new Criterion[values.size()]));
    }

    public static Criterion not(Criterion value) {
        return Restrictions.not((Criterion)value);
    }

    private static <P> boolean isBlank(P value) {
        if (!(value instanceof String)) {
            return value == null;
        }
        return StringUtils.isBlank((String)((String)value));
    }

    private static <P> boolean isNotBlank(P value) {
        return !CriteriaUtils.isBlank(value);
    }

    private static <P> P[] filterBlank(P[] values) {
        return new NullFilter<P>(){

            @Override
            protected boolean accept(P target) {
                if (!(target instanceof String)) {
                    return super.accept(target);
                }
                return StringUtils.isNotBlank((String)((String)target));
            }
        }.filter(values);
    }

    private static Criterion[] filterDuplicateExpressions(Criterion[] values) {
        return new DecorativeArrayFilter<Criterion>(){
            private Set<SubqueryExpressionHashCodeHelper> subqueryExpressions = new HashSet<SubqueryExpressionHashCodeHelper>();

            @Override
            protected boolean accept(Criterion criterion) {
                if (criterion == null) {
                    return false;
                }
                if (!(criterion instanceof SubqueryExpression)) {
                    return true;
                }
                SubqueryExpressionHashCodeHelper expression = new SubqueryExpressionHashCodeHelper((SubqueryExpression)criterion);
                if (this.subqueryExpressions.contains(expression)) {
                    return false;
                }
                this.subqueryExpressions.add(expression);
                return true;
            }
        }.filter(values);
    }

    public static Order[] orderBy(SortKey sortKey) {
        return CriteriaUtils.orderBy(sortKey, null);
    }

    public static <E extends ContainerBase<E>> Order[] orderBy(SortKey sortKey, Class<E> eclass) {
        if (sortKey == null) {
            return new Order[0];
        }
        EntityMeta<E> emeta = null;
        if (eclass != null) {
            emeta = StoreModelUtils.meta(eclass);
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        for (SortKey.SortItem sortItem : sortKey.getSortItems()) {
            if (emeta != null && !CriteriaUtils.isSortable(sortItem.getName(), emeta)) {
                return new Order[0];
            }
            Order order = null;
            order = sortItem.isAscending() ? Order.asc((String)sortItem.getName()) : Order.desc((String)sortItem.getName());
            orders.add(order);
        }
        return orders.toArray(new Order[orders.size()]);
    }

    private static boolean isSortable(String sortItemName, EntityMeta<?> emeta) {
        try {
            PropertyMetaBase<?> pmeta;
            if (logger.isDebugEnabled()) {
                logger.info("sortItemName " + sortItemName);
            }
            if (!CriteriaUtils.isSortable(pmeta = emeta.propertyMetaEntityName(sortItemName))) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("illegal. return false.", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private static boolean isSortable(PropertyMetaBase<?> pmeta) {
        return pmeta != null && pmeta instanceof PropertyMeta;
    }

    public static boolean contains(List<Order> list, Order order) {
        if (order == null || CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (Order o : list) {
            if (!order.getPropertyName().equals(o.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    public static String[] orSplit(String searchValue) {
        if (searchValue == null) {
            return null;
        }
        if (!searchValue.trim().startsWith(OR_SPLIT_PREFIX)) {
            return new String[]{searchValue};
        }
        String removeStartString = StringUtils.removeStart((String)searchValue.trim(), (String)OR_SPLIT_PREFIX);
        Object[] values = new BlankFilter().filter(StringUtils.split((String)removeStartString, (String)" "));
        if (ArrayUtils.isEmpty((Object[])values) || values.length < 2) {
            return new String[]{searchValue};
        }
        return values;
    }

    public static String[] andSplit(String searchValue) {
        if (searchValue == null) {
            return null;
        }
        Object[] values = new BlankFilter().filter(StringUtils.split((String)searchValue.trim(), (String)" "));
        if (ArrayUtils.isEmpty((Object[])values)) {
            return new String[]{searchValue};
        }
        return values;
    }

    public static Junction split(String searchValue) {
        Object[] values = CriteriaUtils.orSplit(searchValue);
        if (ArrayUtils.isNotEmpty((Object[])values) && values.length > 1) {
            return new Junction(Operator.OR, (String[])values);
        }
        return new Junction(Operator.AND, CriteriaUtils.andSplit(searchValue));
    }

    public static Criterion unreadStatusSearch(DetachedCriteria criteria, MultiPropertyMeta<String> meta, Integer status, String ... userids) {
        if (status == null) {
            return null;
        }
        if (status == 1) {
            return CriteriaUtils.eq(criteria, meta, userids);
        }
        if (status == 2) {
            return CriteriaUtils.notContains(criteria, meta, userids);
        }
        return null;
    }

    public static Criterion unreadStatusSearch(DetachedCriteria criteria, ContainerPropertyMeta<String> meta, Integer status, String ... userids) {
        if (status == null) {
            return null;
        }
        if (status == 1) {
            return CriteriaUtils.eq(criteria, meta, userids);
        }
        if (status == 2) {
            return CriteriaUtils.notContains(criteria, meta, userids);
        }
        return null;
    }
}

